/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.defuse.chain.build;

import com.pvsstudio.dataflow.defuse.AbstractDepthWalker;
import com.pvsstudio.dataflow.defuse.DefUseGraph;
import com.pvsstudio.dataflow.defuse.DefUseScanner;
import com.pvsstudio.dataflow.defuse.NodeMetaInfo;
import com.pvsstudio.dataflow.defuse.NodeVariables;
import com.pvsstudio.dataflow.defuse.chain.build.BuildingChainsBuffer;
import com.pvsstudio.dataflow.defuse.chain.build.SimpleDefUseChainBuilder;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.intermediate.Variable;
import fr.inria.controlflow.ControlFlowGraph;
import fr.inria.controlflow.ControlFlowNode;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DefUseChainBuildWalker
extends AbstractDepthWalker {
    private final Map<ControlFlowNode, NodeMetaInfo> nodes;
    private final DefUseGraph result = new DefUseGraph();
    private BuildingChainsBuffer buildingChainsBuffer;

    public DefUseChainBuildWalker(Map<ControlFlowNode, NodeMetaInfo> nodes) {
        this.nodes = nodes;
    }

    public DefUseGraph process(ControlFlowGraph cfg) {
        ChainElement startNode = this.nodes.get(cfg.vertexSet().iterator().next()).getChainElement();
        this.buildingChainsBuffer = new BuildingChainsBuffer(startNode, this.nodes);
        this.walk(cfg);
        this.buildingChainsBuffer.getVariables().stream().map(x -> this.buildingChainsBuffer.get((Variable)x)).filter(Objects::nonNull).forEach(builder -> this.result.addChain(builder.getResult()));
        return this.result;
    }

    @Override
    protected void onEnterNode() {
        ControlFlowNode currentNode = this.getCurrentNode();
        DefUseScanner scanner = new DefUseScanner();
        scanner.scan(currentNode.getStatement());
        NodeVariables vars = scanner.getResult();
        NodeMetaInfo nodeMetaInfo = this.nodes.get(currentNode);
        ChainElement element = nodeMetaInfo.getChainElement();
        this.addReading(element, vars, vars.getNonImpactVariables());
        this.addReading(element, vars, vars.getReadVariables());
        this.buildingChainsBuffer.addInitialization(element, vars);
        nodeMetaInfo.addSnapshot(this.buildingChainsBuffer);
    }

    private void addReading(ChainElement element, NodeVariables allVariablesInNode, Set<Variable> variableSet) {
        variableSet.stream().filter(variable -> !allVariablesInNode.containsWrite((Variable)variable)).forEach(variable -> this.buildingChainsBuffer.addUsing((Variable)variable, element));
    }

    @Override
    protected void onExitNode() {
        ControlFlowNode currentNode = this.getCurrentNode();
        this.nodes.get(currentNode).saveInfoAboutLastAddedElements(this.nodes, this.getAllNextNodes());
        this.popOrStepBack(new HashSet<Variable>(this.buildingChainsBuffer.getVariables()), this.nodes.get(currentNode).getChainElement());
    }

    private void popOrStepBack(Set<Variable> variables, ChainElement element) {
        for (Variable variable : variables) {
            SimpleDefUseChainBuilder defUseChainBuilder = this.buildingChainsBuffer.get(variable);
            if (defUseChainBuilder == null || defUseChainBuilder.getLastAddedElement() != element) continue;
            if (defUseChainBuilder.isEmpty()) {
                this.buildingChainsBuffer.remove(variable);
                this.result.addChain(defUseChainBuilder.getResult());
                defUseChainBuilder = this.buildingChainsBuffer.get(variable);
                if (defUseChainBuilder == null || defUseChainBuilder.getLastAddedElement() != element) continue;
                defUseChainBuilder.stepBack();
                continue;
            }
            defUseChainBuilder.stepBack();
        }
    }

    @Override
    protected void onEnterVisitedNode() {
        this.nodes.get(this.getCurrentNode()).generateSubgraph(this.buildingChainsBuffer, this.result);
    }
}

