/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.defuse.chain.build;

import com.pvsstudio.dataflow.defuse.NodeMetaInfo;
import com.pvsstudio.dataflow.defuse.NodeVariables;
import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.defuse.chain.build.SimpleDefUseChainBuilder;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.intermediate.Field;
import com.pvsstudio.dataflow.intermediate.Variable;
import fr.inria.controlflow.ControlFlowNode;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.declaration.CtElement;

public class BuildingChainsBuffer {
    private final ChainElement startNode;
    private final Map<Variable, Deque<SimpleDefUseChainBuilder>> chainsBuffer = new HashMap<Variable, Deque<SimpleDefUseChainBuilder>>();
    private final Map<ControlFlowNode, NodeMetaInfo> nodes;

    public BuildingChainsBuffer(ChainElement startNode, Map<ControlFlowNode, NodeMetaInfo> nodes) {
        this.startNode = startNode;
        this.nodes = nodes;
    }

    public void addUsing(Variable variable, ChainElement element) {
        this.unpackField(variable, element);
        this.processVariable(variable);
        this.chainsBuffer.get(variable).getFirst().addVertex(element);
    }

    private void processVariable(Variable variable) {
        Variable owner;
        SimpleDefUseChainBuilder ownerBuilder;
        ChainElement startNodeForChain = this.startNode;
        Collection<DefUseChain> parents = Collections.emptyList();
        if (variable instanceof Field && (ownerBuilder = this.get(owner = ((Field)variable).getOwner())) != null) {
            NodeMetaInfo metaInfo;
            DefUseChain ownerChainFromSnapshot;
            startNodeForChain = ownerBuilder.getResult().getFirstChainElement();
            parents = ownerBuilder.getResult().getParents();
            SimpleDefUseChainBuilder previousBuilder = this.get(variable);
            if (previousBuilder != null && (ownerChainFromSnapshot = (metaInfo = this.nodes.get(previousBuilder.getLastAddedElement().getNode())).getSnapshotChain(owner)) != ownerBuilder.getResult()) {
                this.createNewChain(variable, startNodeForChain, ownerBuilder.getResult().getDefaultExpression(), null, parents);
            }
        }
        if (this.get(variable) == null) {
            this.createNewChain(variable, startNodeForChain, null, null, parents);
        }
    }

    private void unpackField(Variable field, ChainElement element) {
        if (!(field instanceof Field)) {
            return;
        }
        LinkedList<Variable> unpackedVariables = new LinkedList<Variable>();
        do {
            field = ((Field)field).getOwner();
            unpackedVariables.add(0, field);
        } while (field instanceof Field);
        for (Variable variable : unpackedVariables) {
            this.processVariable(variable);
            this.chainsBuffer.get(variable).getFirst().addVertex(element);
        }
    }

    private void createNewChain(@Nullable Variable variable, ChainElement element, @Nullable CtElement defaultExpression, @Nullable NodeVariables variables, @Nullable Collection<DefUseChain> parents) {
        SimpleDefUseChainBuilder builder = new SimpleDefUseChainBuilder(variable, element, defaultExpression);
        if (element != this.startNode && variables != null) {
            for (Variable readVar : variables.getReadVariables()) {
                SimpleDefUseChainBuilder previousVersion = this.get(readVar);
                if (previousVersion == null) {
                    if (!readVar.equals(variable)) continue;
                    this.addUsing(readVar, element);
                    builder.addParent(this.get(readVar));
                    continue;
                }
                if (readVar.equals(variable)) {
                    previousVersion.addVertex(element);
                }
                builder.addParent(previousVersion);
            }
            if (!this.chainsBuffer.containsKey(variable)) {
                variables.getWriteVariables().forEach(writeVar -> builder.addParent(this.get((Variable)writeVar)));
            }
        } else {
            builder.addParents(parents);
        }
        this.chainsBuffer.computeIfAbsent(variable, k -> new ArrayDeque());
        this.chainsBuffer.get(variable).push(builder);
    }

    public void addInitialization(ChainElement element, NodeVariables variables) {
        this.addNewVersions(element, variables, variables.getWriteVariables());
        this.addNewVersions(element, variables, variables.getInitializeVariables());
    }

    private void addNewVersions(ChainElement element, NodeVariables variables, Set<Variable> newVars) {
        for (Variable writeVariable : newVars) {
            this.unpackField(writeVariable, element);
            this.createNewChain(writeVariable, element, variables.getDefaultExpression(writeVariable), variables, null);
        }
    }

    public void remove(Variable variable) {
        Deque<SimpleDefUseChainBuilder> deque = this.chainsBuffer.get(variable);
        if (deque == null) {
            return;
        }
        deque.pop();
        if (deque.isEmpty()) {
            this.chainsBuffer.remove(variable);
        }
    }

    @Nullable
    public SimpleDefUseChainBuilder get(Variable variable) {
        Deque<SimpleDefUseChainBuilder> deque = this.chainsBuffer.get(variable);
        if (deque == null) {
            return null;
        }
        return deque.getFirst();
    }

    public Set<Variable> getVariables() {
        return this.chainsBuffer.keySet();
    }
}

