/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.defuse;

import com.pvsstudio.dataflow.intermediate.Variable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.declaration.CtElement;

public class NodeVariables {
    private final Set<Variable> writeVariables = new HashSet<Variable>();
    private final Set<Variable> readVariables = new HashSet<Variable>();
    private final Set<Variable> nonImpactVariables = new HashSet<Variable>();
    private final Set<Variable> initializeVariables = new HashSet<Variable>();
    private final Map<Variable, CtElement> defaultExpressions = new HashMap<Variable, CtElement>();

    public Set<Variable> getInitializeVariables() {
        return this.initializeVariables;
    }

    public Set<Variable> getWriteVariables() {
        return this.writeVariables;
    }

    public Set<Variable> getReadVariables() {
        return this.readVariables;
    }

    public Set<Variable> getNonImpactVariables() {
        return this.nonImpactVariables;
    }

    @Nullable
    public CtElement getDefaultExpression(Variable variable) {
        return this.defaultExpressions.get(variable);
    }

    public void addRead(Variable variable) {
        this.readVariables.add(variable);
    }

    public void addNonImpactRead(Variable variable) {
        this.nonImpactVariables.add(variable);
    }

    public void addWrite(Variable variable) {
        this.writeVariables.add(variable);
    }

    public void addInitialize(Variable variable) {
        this.initializeVariables.add(variable);
    }

    public void addDefaultExpression(Variable variable, @Nullable CtElement defaultExpression) {
        this.defaultExpressions.put(variable, defaultExpression);
    }

    public boolean containsWrite(Variable variable) {
        return this.writeVariables.contains(variable);
    }

    public boolean containsRead(Variable variable) {
        return this.readVariables.contains(variable);
    }
}

