/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.defuse;

import com.pvsstudio.dataflow.defuse.DefUseGraph;
import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.defuse.chain.DefUseChainImpl;
import com.pvsstudio.dataflow.defuse.chain.build.BuildingChainsBuffer;
import com.pvsstudio.dataflow.defuse.chain.build.SimpleDefUseChainBuilder;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import com.pvsstudio.dataflow.defuse.element.ChainElementFactory;
import com.pvsstudio.dataflow.intermediate.Variable;
import fr.inria.controlflow.ControlFlowNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class NodeMetaInfo {
    private final ControlFlowNode node;
    private final ChainElement chainElement;
    private final Map<Variable, Map.Entry<DefUseChainImpl, ChainElement>> snapshot = new HashMap<Variable, Map.Entry<DefUseChainImpl, ChainElement>>();
    private final Map<Variable, Set<ChainElement>> addedElements = new HashMap<Variable, Set<ChainElement>>();

    public NodeMetaInfo(ControlFlowNode node) {
        this.node = node;
        this.chainElement = ChainElementFactory.create(node);
    }

    @Nullable
    public Set<ChainElement> getLastAddedElements(Variable variable) {
        return this.addedElements.get(variable);
    }

    public ChainElement getChainElement() {
        return this.chainElement;
    }

    public DefUseChain getSnapshotChain(Variable variable) {
        return (DefUseChain)((Map.Entry)this.snapshot.getOrDefault(variable, new AbstractMap.SimpleEntry<Object, Object>(null, null))).getKey();
    }

    public void addSnapshot(BuildingChainsBuffer buffer) {
        for (Variable variable : buffer.getVariables()) {
            SimpleDefUseChainBuilder chain = buffer.get(variable);
            this.snapshot.put(variable, new AbstractMap.SimpleEntry<DefUseChainImpl, ChainElement>(chain.getResult(), chain.getLastAddedElement()));
        }
    }

    public void generateSubgraph(BuildingChainsBuffer buffer, DefUseGraph graph) {
        for (Variable variable : buffer.getVariables()) {
            if (!this.snapshot.containsKey(variable) || !this.addedElements.containsKey(variable) || this.addedElements.get(variable).isEmpty()) continue;
            Optional.ofNullable(buffer.get(variable)).ifPresent(chain -> chain.addElementsFromOtherChain(chain.getLastAddedElement(), this.snapshot.get(variable).getKey(), new ArrayList<ChainElement>((Collection)this.addedElements.get(variable)), graph));
        }
    }

    public void saveInfoAboutLastAddedElements(Map<ControlFlowNode, NodeMetaInfo> metaInfoMap, List<ControlFlowNode> nextNodes) {
        for (Map.Entry<Variable, Map.Entry<DefUseChainImpl, ChainElement>> entry : this.snapshot.entrySet()) {
            Map.Entry<DefUseChainImpl, ChainElement> valueFromSnapshot = entry.getValue();
            if (valueFromSnapshot.getValue().getNode().equals(this.node)) {
                this.addedElements.put(entry.getKey(), Set.of(valueFromSnapshot.getValue()));
                continue;
            }
            HashSet lastAddedNodes = new HashSet();
            nextNodes.stream().map(metaInfoMap::get).map(metaInfo -> metaInfo.getLastAddedElements((Variable)entry.getKey())).filter(Objects::nonNull).forEach(lastAddedNodes::addAll);
            if (lastAddedNodes.isEmpty()) continue;
            this.addedElements.put(entry.getKey(), lastAddedNodes);
        }
    }
}

