/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.defuse;

import com.pvsstudio.dataflow.defuse.NodeVariables;
import com.pvsstudio.dataflow.intermediate.Variable;
import com.pvsstudio.dataflow.intermediate.VariableFactory;
import java.lang.annotation.Annotation;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCasePattern;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtRecordPattern;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTextBlock;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtTypePattern;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.CtYieldStatement;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtModuleRequirement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtPackageDeclaration;
import spoon.reflect.declaration.CtPackageExport;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtProvidedService;
import spoon.reflect.declaration.CtReceiverParameter;
import spoon.reflect.declaration.CtRecord;
import spoon.reflect.declaration.CtRecordComponent;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtUsedService;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeMemberWildcardImportReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtUnboundVariableReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtScanner;

public class DefUseScanner
extends CtScanner {
    NodeVariables result = new NodeVariables();
    private boolean usingNonImpactVariables;
    private Variable assigned = null;

    private void addRead(@Nullable Variable variable) {
        if (variable == null) {
            return;
        }
        if (this.usingNonImpactVariables) {
            this.result.addNonImpactRead(variable);
        } else {
            this.result.addRead(variable);
        }
    }

    private void setImpact() {
        if (this.usingNonImpactVariables) {
            this.usingNonImpactVariables = false;
        }
    }

    public final NodeVariables getResult() {
        return this.result;
    }

    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        this.addRead(this.getVariable((CtElement)variableRead));
    }

    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        Variable variable = this.getVariable((CtElement)variableWrite);
        if (variable != null) {
            this.result.addWrite(variable);
            this.assigned = variable;
        }
    }

    @Nullable
    private Variable getVariable(CtElement variableUse) {
        if (variableUse instanceof CtArrayAccess) {
            variableUse = ((CtArrayAccess)variableUse).getTarget();
        }
        return VariableFactory.parseFromAst(variableUse);
    }

    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        this.setImpact();
        Variable variable = this.getVariable((CtElement)assignment.getAssigned());
        if (variable != null) {
            this.addRead(variable);
            this.result.addWrite(variable);
            this.result.addDefaultExpression(variable, (CtElement)assignment);
        } else {
            this.scan((CtElement)assignment.getAssigned());
        }
        this.scan((CtElement)assignment.getAssignment());
    }

    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.setImpact();
        UnaryOperatorKind kind = operator.getKind();
        if (kind == UnaryOperatorKind.POSTDEC || kind == UnaryOperatorKind.POSTINC || kind == UnaryOperatorKind.PREDEC || kind == UnaryOperatorKind.PREINC) {
            Variable variable = this.getVariable((CtElement)operator.getOperand());
            if (variable != null) {
                this.result.addWrite(variable);
                this.addRead(variable);
                this.result.addDefaultExpression(variable, (CtElement)operator);
            } else {
                this.scan((CtElement)operator.getOperand());
            }
        } else {
            this.scan((CtElement)operator.getOperand());
        }
    }

    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.setImpact();
        Variable variable = this.getVariable((CtElement)localVariable);
        if (variable != null) {
            this.result.addInitialize(variable);
            this.result.addDefaultExpression(variable, (CtElement)localVariable.getDefaultExpression());
        }
        this.scan((CtElement)localVariable.getDefaultExpression());
    }

    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        Variable variable = this.getVariable((CtElement)arrayRead);
        if (variable != null) {
            this.addRead(variable);
        }
    }

    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        this.setImpact();
        Variable variable = this.getVariable((CtElement)arrayWrite);
        if (variable != null) {
            this.result.addWrite(variable);
            this.assigned = variable;
        }
    }

    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        this.setImpact();
        this.scan(CtRole.ASSIGNED, (CtElement)assignement.getAssigned());
        this.scan(CtRole.ASSIGNMENT, (CtElement)assignement.getAssignment());
        this.result.addDefaultExpression(this.assigned, (CtElement)assignement.getAssignment());
        this.assigned = null;
    }

    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        if (fieldRead.getVariable().getDeclaration() == null) {
            this.scan(CtRole.TARGET, (CtElement)fieldRead.getTarget());
            return;
        }
        Variable variable = this.getVariable((CtElement)fieldRead);
        if (variable != null) {
            this.addRead(variable);
        }
    }

    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        if (fieldWrite.getVariable().getDeclaration() == null) {
            this.scan(CtRole.TARGET, (CtElement)fieldWrite.getTarget());
            return;
        }
        Variable variable = this.getVariable((CtElement)fieldWrite);
        if (variable != null) {
            this.result.addWrite(variable);
            this.assigned = variable;
        }
    }

    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        Variable variable = this.getVariable((CtElement)catchVariable);
        if (variable != null) {
            this.result.addInitialize(variable);
            this.result.addDefaultExpression(variable, (CtElement)catchVariable.getDefaultExpression());
        }
    }

    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.scan(CtRole.CONDITION, (CtElement)asserted.getAssertExpression());
        this.scan(CtRole.EXPRESSION, (CtElement)asserted.getExpression());
    }

    public void visitCtYieldStatement(CtYieldStatement statement) {
        this.scan(CtRole.EXPRESSION, (CtElement)statement.getExpression());
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        this.scan(CtRole.LEFT_OPERAND, (CtElement)operator.getLeftHandOperand());
        this.scan(CtRole.RIGHT_OPERAND, (CtElement)operator.getRightHandOperand());
    }

    public <R> void visitCtBlock(CtBlock<R> block) {
        this.scan(CtRole.STATEMENT, block.getStatements());
    }

    public <S> void visitCtCase(CtCase<S> caseStatement) {
        this.scan(CtRole.EXPRESSION, caseStatement.getCaseExpressions());
        this.scan(CtRole.STATEMENT, caseStatement.getStatements());
    }

    public void visitCtCatch(CtCatch catchBlock) {
        this.scan(CtRole.PARAMETER, (CtElement)catchBlock.getParameter());
        this.scan(CtRole.BODY, (CtElement)catchBlock.getBody());
    }

    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.usingNonImpactVariables = true;
        this.scan(CtRole.CONDITION, (CtElement)conditional.getCondition());
        this.usingNonImpactVariables = false;
        this.scan(CtRole.THEN, (CtElement)conditional.getThenExpression());
        this.scan(CtRole.ELSE, (CtElement)conditional.getElseExpression());
    }

    public <T> void visitCtField(CtField<T> f) {
        this.scan(CtRole.DEFAULT_EXPRESSION, (CtElement)f.getDefaultExpression());
    }

    public void visitCtIf(CtIf ifElement) {
        this.scan(CtRole.CONDITION, (CtElement)ifElement.getCondition());
    }

    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.scan(CtRole.TARGET, (CtElement)invocation.getTarget());
        this.scan(CtRole.ARGUMENT, invocation.getArguments());
    }

    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        this.scan(CtRole.EXPRESSION, newArray.getElements());
        this.scan(CtRole.DIMENSION, newArray.getDimensionExpressions());
    }

    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.scan(CtRole.TARGET, (CtElement)ctConstructorCall.getTarget());
        this.scan(CtRole.ARGUMENT, ctConstructorCall.getArguments());
    }

    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.scan(CtRole.TARGET, (CtElement)newClass.getTarget());
        this.scan(CtRole.ARGUMENT, newClass.getArguments());
    }

    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.scan(CtRole.EXPRESSION, (CtElement)returnStatement.getReturnedExpression());
    }

    public <R> void visitCtStatementList(CtStatementList statements) {
        this.scan(CtRole.STATEMENT, statements.getStatements());
    }

    public void visitCtSynchronized(CtSynchronized synchro) {
        this.scan(CtRole.BODY, (CtElement)synchro.getBlock());
    }

    public void visitCtTry(CtTry tryBlock) {
        this.scan(CtRole.BODY, (CtElement)tryBlock.getBody());
        this.scan(CtRole.CATCH, tryBlock.getCatchers());
        this.scan(CtRole.FINALIZER, (CtElement)tryBlock.getFinalizer());
    }

    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        this.scan(CtRole.TRY_RESOURCE, tryWithResource.getResources());
        this.scan(CtRole.BODY, (CtElement)tryWithResource.getBody());
        this.scan(CtRole.CATCH, tryWithResource.getCatchers());
        this.scan(CtRole.FINALIZER, (CtElement)tryWithResource.getFinalizer());
    }

    public void visitCtWhile(CtWhile whileLoop) {
        this.scan(CtRole.EXPRESSION, (CtElement)whileLoop.getLoopingExpression());
        this.scan(CtRole.BODY, (CtElement)whileLoop.getBody());
    }

    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
    }

    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
    }

    public <T> void visitCtUnboundVariableReference(CtUnboundVariableReference<T> reference) {
    }

    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
    }

    public final void visitCtComment(CtComment comment) {
    }

    public final void visitCtJavaDoc(CtJavaDoc javaDoc) {
    }

    public final void visitCtJavaDocTag(CtJavaDocTag docTag) {
    }

    public void visitCtImport(CtImport ctImport) {
    }

    public void visitCtModule(CtModule module) {
    }

    public void visitCtModuleReference(CtModuleReference moduleReference) {
    }

    public void visitCtPackageExport(CtPackageExport moduleExport) {
    }

    public void visitCtModuleRequirement(CtModuleRequirement moduleRequirement) {
    }

    public void visitCtProvidedService(CtProvidedService moduleProvidedService) {
    }

    public void visitCtUsedService(CtUsedService usedService) {
    }

    public void visitCtCompilationUnit(CtCompilationUnit compilationUnit) {
    }

    public void visitCtPackageDeclaration(CtPackageDeclaration packageDeclaration) {
    }

    public void visitCtTypeMemberWildcardImportReference(CtTypeMemberWildcardImportReference wildcardReference) {
    }

    public void visitCtTypePattern(CtTypePattern pattern) {
    }

    public void visitCtRecord(CtRecord recordType) {
    }

    public void visitCtRecordComponent(CtRecordComponent recordType) {
    }

    public void visitCtReceiverParameter(CtReceiverParameter receiverParameter) {
    }

    public void visitCtCasePattern(CtCasePattern casePattern) {
    }

    public void visitCtRecordPattern(CtRecordPattern recordPattern) {
    }

    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
    }

    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
    }

    public <T> void visitCtParameter(CtParameter<T> parameter) {
    }

    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
    }

    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
    }

    public void visitCtWildcardReference(CtWildcardReference wildcardReference) {
    }

    public <T> void visitCtIntersectionTypeReference(CtIntersectionTypeReference<T> reference) {
    }

    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
    }

    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
    }

    public void visitCtBreak(CtBreak breakStatement) {
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
    }

    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
    }

    public <T> void visitCtConstructor(CtConstructor<T> c) {
    }

    public final void visitCtContinue(CtContinue continueStatement) {
    }

    public void visitCtDo(CtDo doLoop) {
    }

    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
    }

    public final <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
    }

    public <T> void visitCtEnumValue(CtEnumValue<T> enumValue) {
    }

    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
    }

    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
    }

    public void visitCtFor(CtFor forLoop) {
    }

    public void visitCtForEach(CtForEach foreach) {
    }

    public <T> void visitCtInterface(CtInterface<T> intrface) {
    }

    public void visitCtAnonymousExecutable(CtAnonymousExecutable anonymousExec) {
    }

    public final <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
    }

    public final <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
    }

    public <T> void visitCtLiteral(CtLiteral<T> literal) {
    }

    public void visitCtTextBlock(CtTextBlock literal) {
    }

    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
    }

    public <T> void visitCtCatchVariableReference(CtCatchVariableReference<T> reference) {
    }

    public <T> void visitCtMethod(CtMethod<T> m) {
    }

    public <T> void visitCtAnnotationMethod(CtAnnotationMethod<T> annotationMethod) {
    }

    public <T> void visitCtLambda(CtLambda<T> lambda) {
    }

    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
    }

    public void visitCtPackage(CtPackage ctPackage) {
    }

    public void visitCtPackageReference(CtPackageReference reference) {
    }

    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
    }

    public <T, S> void visitCtSwitchExpression(CtSwitchExpression<T, S> switchExpression) {
    }

    public void visitCtThrow(CtThrow throwStatement) {
    }
}

