/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.defuse;

import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.intermediate.Variable;
import com.pvsstudio.dataflow.intermediate.VariableFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.EarlyTerminatingScanner;

public class DefUseGraph {
    private final Map<Variable, List<DefUseChain>> defUseChains = new HashMap<Variable, List<DefUseChain>>();

    public void addChain(DefUseChain chain) {
        Variable variable = chain.getOwnerVariable();
        if (!this.defUseChains.containsKey(variable)) {
            this.defUseChains.put(variable, new ArrayList());
        }
        this.defUseChains.get(variable).add(chain);
    }

    public List<DefUseChain> getChains(final CtVariableAccess<?> access) {
        Variable variable = VariableFactory.parseFromAst(access);
        List<DefUseChain> chains = this.getChains(variable);
        LinkedList<DefUseChain> result = new LinkedList<DefUseChain>();
        for (DefUseChain chain : chains) {
            CtElement defaultExpression = chain.getDefaultExpression();
            if (defaultExpression == null) {
                result.add(chain);
                continue;
            }
            EarlyTerminatingScanner<Boolean> controller = new EarlyTerminatingScanner<Boolean>(){

                public void scan(CtElement element) {
                    if (access == element) {
                        this.setResult(true);
                        this.terminate();
                        return;
                    }
                    super.scan(element);
                }
            };
            controller.scan(defaultExpression);
            if (Boolean.TRUE.equals(controller.getResult())) continue;
            result.add(chain);
        }
        return result;
    }

    public List<DefUseChain> getChains(@Nullable Variable variable) {
        if (variable == null) {
            return Collections.emptyList();
        }
        List<DefUseChain> chains = this.defUseChains.get(variable);
        return chains != null ? chains : Collections.emptyList();
    }

    public Set<Variable> getVariables() {
        return this.defUseChains.keySet();
    }
}

