/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.defuse;

import fr.inria.controlflow.ControlFlowGraph;
import fr.inria.controlflow.ControlFlowNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractDepthWalker {
    private final List<ControlFlowNode> path = new ArrayList<ControlFlowNode>();
    private final List<Integer> verifiedEdgeCounters = new ArrayList<Integer>();
    private ControlFlowNode currentNode = null;
    private final Set<ControlFlowNode> visitedNodes = new HashSet<ControlFlowNode>();

    private ControlFlowNode getLastVisitedNode() {
        return this.path.get(this.path.size() - 1);
    }

    private int getCountOfVerifiedEdges() {
        return this.verifiedEdgeCounters.get(this.verifiedEdgeCounters.size() - 1);
    }

    private void removeFirst() {
        this.path.remove(this.path.size() - 1);
        this.verifiedEdgeCounters.remove(this.verifiedEdgeCounters.size() - 1);
    }

    private void addToPath(ControlFlowNode currentNode, int currentLevelDepth) {
        this.path.add(currentNode);
        this.verifiedEdgeCounters.add(currentLevelDepth);
    }

    public ControlFlowNode getCurrentNode() {
        return this.currentNode;
    }

    private boolean findNextNode() {
        List<ControlFlowNode> nextNodes;
        int notVerifiedEdgeIndex = this.getCountOfVerifiedEdges();
        if (notVerifiedEdgeIndex == (nextNodes = this.getAllNextNodes()).size()) {
            return false;
        }
        ControlFlowNode newNode = nextNodes.get(notVerifiedEdgeIndex);
        this.removeFirst();
        this.addToPath(this.currentNode, notVerifiedEdgeIndex + 1);
        this.addToPath(newNode, 0);
        return true;
    }

    protected List<ControlFlowNode> getAllNextNodes() {
        ArrayList<ControlFlowNode> nextNodes = new ArrayList<ControlFlowNode>();
        for (ControlFlowNode nextNode : this.currentNode.next()) {
            if (this.path.contains(nextNode)) {
                nextNodes.addAll(this.unboxLoop(nextNode));
                continue;
            }
            nextNodes.add(nextNode);
        }
        return nextNodes;
    }

    private List<ControlFlowNode> unboxLoop(ControlFlowNode loopNode) {
        return loopNode.next().stream().filter(vertex -> !this.path.contains(vertex)).collect(Collectors.toList());
    }

    protected final void walk(ControlFlowGraph graph) {
        ControlFlowNode startNode = (ControlFlowNode)graph.vertexSet().iterator().next();
        this.addToPath(startNode, 0);
        boolean firstCheckFlag = true;
        do {
            this.currentNode = this.getLastVisitedNode();
            if (this.visitedNodes.contains(this.currentNode) && firstCheckFlag) {
                this.onEnterVisitedNode();
                this.removeFirst();
                firstCheckFlag = false;
                continue;
            }
            if (firstCheckFlag) {
                this.onEnterNode();
                this.visitedNodes.add(this.currentNode);
            }
            if (firstCheckFlag = this.findNextNode()) continue;
            this.onExitNode();
            this.removeFirst();
        } while (!this.path.isEmpty());
    }

    protected abstract void onEnterNode();

    protected abstract void onExitNode();

    protected abstract void onEnterVisitedNode();
}

