/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.contradiction;

import com.pvsstudio.dataflow.contradiction.BranchCondition;
import com.pvsstudio.dataflow.contradiction.ContradictionHelper;
import com.pvsstudio.dataflow.contradiction.Interval;
import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;

public class VariableCondition
implements BranchCondition {
    private static final Comparator<DefUseChain> DEF_USE_CHAIN_COMPARATOR = Comparator.comparing(defUseChain -> defUseChain.getOwnerVariableReference().getSimpleName());
    private final DefUseChain left;
    private final DefUseChain right;
    private final BinaryOperatorKind operator;

    public VariableCondition(@NotNull DefUseChain left, @NotNull DefUseChain right, @NotNull BinaryOperatorKind operator) {
        if (DEF_USE_CHAIN_COMPARATOR.compare(left, right) > 0) {
            this.left = right;
            this.right = left;
            this.operator = ContradictionHelper.flip(operator);
        } else {
            this.left = left;
            this.right = right;
            this.operator = operator;
        }
    }

    @Override
    public boolean areConditionsContradictory(@Nullable BranchCondition condition) {
        if (!(condition instanceof VariableCondition)) {
            return false;
        }
        VariableCondition other = (VariableCondition)condition;
        if (this.left != other.left || this.right != other.right) {
            return false;
        }
        return this.toInterval().contradicts(other.toInterval());
    }

    @Override
    @NotNull
    public Interval toInterval() {
        switch (this.operator) {
            case GT: {
                return Interval.fromLower(false, 0.0);
            }
            case GE: {
                return Interval.fromLower(true, 0.0);
            }
            case LT: {
                return Interval.fromUpper(false, 0.0);
            }
            case LE: {
                return Interval.fromUpper(true, 0.0);
            }
            case EQ: {
                return Interval.from(true, 0.0, true, 0.0);
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + String.valueOf(this.operator));
    }
}

