/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.contradiction;

import com.pvsstudio.dataflow.contradiction.BranchCondition;
import com.pvsstudio.dataflow.contradiction.Interval;
import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.utility.AnalyzerCopied;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtLiteral;

public class LiteralCondition
implements BranchCondition {
    private final DefUseChain variable;
    private final BinaryOperatorKind operator;
    private final CtLiteral<?> literal;

    public LiteralCondition(@NotNull DefUseChain varName, @NotNull CtLiteral<?> constant, @NotNull BinaryOperatorKind operator) {
        this.variable = varName;
        this.operator = operator;
        this.literal = constant;
    }

    @Override
    public boolean areConditionsContradictory(@Nullable BranchCondition condition) {
        if (!(condition instanceof LiteralCondition)) {
            return false;
        }
        LiteralCondition other = (LiteralCondition)condition;
        if (this.variable != other.variable) {
            return false;
        }
        if (this.literal.getValue() == null || other.literal.getValue() == null) {
            return false;
        }
        if (!AnalyzerCopied.isSubtypeOf(other.literal, new String[]{"java.lang.Number"}) || !AnalyzerCopied.isSubtypeOf(this.literal, new String[]{"java.lang.Number"})) {
            return false;
        }
        return this.toInterval().contradicts(other.toInterval());
    }

    @Override
    @NotNull
    public Interval toInterval() {
        double value = LiteralCondition.doubleValue(this.literal);
        switch (this.operator) {
            case GT: {
                return Interval.fromLower(false, value);
            }
            case GE: {
                return Interval.fromLower(true, value);
            }
            case LT: {
                return Interval.fromUpper(false, value);
            }
            case LE: {
                return Interval.fromUpper(true, value);
            }
            case EQ: {
                return Interval.from(true, value, true, value);
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + String.valueOf(this.operator));
    }

    private static double doubleValue(@NotNull CtLiteral<?> literal) {
        Object value = literal.getValue();
        return value instanceof Character ? (double)((Character)value).charValue() : ((Number)value).doubleValue();
    }
}

