/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.contradiction;

public class Interval {
    private double lowerBound = Double.NEGATIVE_INFINITY;
    private boolean lowerInclusive = false;
    private double upperBound = Double.POSITIVE_INFINITY;
    private boolean upperInclusive = false;

    private Interval() {
    }

    public static Interval fromLower(boolean inclusive, double value) {
        Interval i = new Interval();
        i.lowerInclusive = inclusive;
        i.lowerBound = value;
        return i;
    }

    public static Interval fromUpper(boolean inclusive, double value) {
        Interval i = new Interval();
        i.upperInclusive = inclusive;
        i.upperBound = value;
        return i;
    }

    public static Interval from(boolean lowerInclusive, double lowerBound, boolean upperInclusive, double upperBound) {
        Interval i = new Interval();
        i.lowerInclusive = lowerInclusive;
        i.lowerBound = lowerBound;
        i.upperInclusive = upperInclusive;
        i.upperBound = upperBound;
        return i;
    }

    public boolean contradicts(Interval other) {
        double newUpper;
        double newLower = Math.max(this.lowerBound, other.lowerBound);
        if (newLower > (newUpper = Math.min(this.upperBound, other.upperBound))) {
            return true;
        }
        if (newLower == newUpper) {
            return !this.isPointIncluded(newLower) || !other.isPointIncluded(newLower);
        }
        return false;
    }

    private boolean isPointIncluded(double point) {
        return (point > this.lowerBound || point == this.lowerBound && this.lowerInclusive) && (point < this.upperBound || point == this.upperBound && this.upperInclusive);
    }
}

