/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.contradiction;

import com.pvsstudio.dataflow.contradiction.BranchCondition;
import com.pvsstudio.dataflow.contradiction.LiteralCondition;
import com.pvsstudio.dataflow.contradiction.VariableCondition;
import com.pvsstudio.dataflow.defuse.DefUseGraph;
import com.pvsstudio.dataflow.defuse.chain.DefUseChain;
import com.pvsstudio.dataflow.defuse.element.ChainElement;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;

public class ContradictionHelper {
    public static BinaryOperatorKind flip(BinaryOperatorKind k) {
        switch (k) {
            case GT: {
                return BinaryOperatorKind.LT;
            }
            case GE: {
                return BinaryOperatorKind.LE;
            }
            case LT: {
                return BinaryOperatorKind.GT;
            }
            case LE: {
                return BinaryOperatorKind.GE;
            }
            case EQ: {
                return BinaryOperatorKind.EQ;
            }
        }
        throw new IllegalArgumentException("bad op " + String.valueOf(k));
    }

    @Nullable
    private static DefUseChain getVariableChain(CtVariableAccess<?> access, DefUseGraph du) {
        if (du == null || access.getVariable() == null || access.getVariable().getDeclaration() == null) {
            return null;
        }
        List<DefUseChain> chains = du.getChains(access);
        DefUseChain targetChain = null;
        for (DefUseChain chain : chains) {
            ChainElement chainElement = chain.find((CtElement)access);
            if (chainElement == null) continue;
            targetChain = chain;
            break;
        }
        return targetChain;
    }

    public static void collectAtoms(CtExpression<?> expr, List<BranchCondition> out, boolean negate, DefUseGraph du) {
        if (!(expr instanceof CtBinaryOperator)) {
            return;
        }
        CtBinaryOperator bo = (CtBinaryOperator)expr;
        switch (bo.getKind()) {
            case AND: 
            case OR: {
                ContradictionHelper.collectAtoms(bo.getLeftHandOperand(), out, negate, du);
                ContradictionHelper.collectAtoms(bo.getRightHandOperand(), out, negate, du);
                return;
            }
            case GT: 
            case GE: 
            case LT: 
            case LE: 
            case EQ: {
                BinaryOperatorKind op = negate ? ContradictionHelper.flip(bo.getKind()) : bo.getKind();
                CtExpression lhs = bo.getLeftHandOperand();
                CtExpression rhs = bo.getRightHandOperand();
                if (lhs instanceof CtVariableRead && rhs instanceof CtLiteral) {
                    DefUseChain el = ContradictionHelper.getVariableChain((CtVariableAccess)lhs, du);
                    if (el == null) {
                        return;
                    }
                    out.add(new LiteralCondition(el, (CtLiteral)rhs, op));
                    return;
                }
                if (lhs instanceof CtLiteral && rhs instanceof CtVariableRead) {
                    DefUseChain el = ContradictionHelper.getVariableChain((CtVariableAccess)rhs, du);
                    if (el == null) {
                        return;
                    }
                    out.add(new LiteralCondition(el, (CtLiteral)lhs, ContradictionHelper.flip(op)));
                    return;
                }
                if (lhs instanceof CtVariableRead && rhs instanceof CtVariableRead) {
                    DefUseChain el1 = ContradictionHelper.getVariableChain((CtVariableAccess)lhs, du);
                    DefUseChain el2 = ContradictionHelper.getVariableChain((CtVariableAccess)rhs, du);
                    if (el1 == null || el2 == null) {
                        return;
                    }
                    out.add(new VariableCondition(el1, el2, op));
                }
                return;
            }
        }
    }
}

