/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.call;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public class MethodSignature {
    private final String qualifiedName;
    private final String clazz;
    private final String simpleName;
    private final List<String> parameters;

    private MethodSignature(String qualifiedName, String clazz, String simpleName, List<String> parameters) {
        this.qualifiedName = qualifiedName;
        this.clazz = clazz;
        this.simpleName = simpleName;
        this.parameters = parameters;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSignature that = (MethodSignature)o;
        return Objects.equals(this.qualifiedName, that.qualifiedName) && Objects.equals(this.clazz, that.clazz) && Objects.equals(this.simpleName, that.simpleName) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.qualifiedName, this.clazz, this.simpleName, this.parameters);
    }

    public String toString() {
        return this.clazz + "." + this.simpleName + "(" + this.parameters.stream().map(x -> x.substring(0, 1).toUpperCase()).collect(Collectors.joining()) + ")";
    }

    public static MethodSignature of(CtAbstractInvocation<?> invocation) {
        CtExecutableReference executable = invocation.getExecutable();
        if (executable.getDeclaringType() != null) {
            CtTypeReference declaringType = executable.getDeclaringType();
            ArrayList<String> parameters = new ArrayList<String>();
            for (CtTypeReference parameter : executable.getParameters()) {
                if (parameter == null) continue;
                parameters.add(parameter.getSimpleName());
            }
            return new MethodSignature(declaringType.getQualifiedName(), declaringType.getSimpleName(), executable.getSimpleName(), parameters);
        }
        return null;
    }

    public static MethodSignature of(CtExecutable<?> executable) {
        CtType type = (CtType)executable.getParent(CtType.class);
        if (type != null) {
            ArrayList<String> parameters = new ArrayList<String>();
            for (CtParameter parameter : executable.getParameters()) {
                if (parameter.getType() == null) continue;
                parameters.add(parameter.getType().getSimpleName());
            }
            return new MethodSignature(type.getQualifiedName(), type.getSimpleName(), executable.getSimpleName(), parameters);
        }
        return null;
    }
}

