/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.call;

import com.pvsstudio.dataflow.call.CallGraph;
import com.pvsstudio.dataflow.call.MethodSignature;
import com.pvsstudio.dataflow.graph.SimpleEdge;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.graph.DirectedPseudograph;
import spoon.reflect.CtModelImpl;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.reference.CtTypeReference;

public class CallGraphImpl
extends DirectedPseudograph<MethodSignature, SimpleEdge.Call>
implements CallGraph {
    public CallGraphImpl() {
        super(SimpleEdge.Call.class);
    }

    private MethodSignature createSignature(CtElement el) {
        MethodSignature signature;
        MethodSignature methodSignature = el instanceof CtInvocation ? MethodSignature.of((CtInvocation)el) : (signature = el instanceof CtExecutable ? MethodSignature.of((CtExecutable)el) : null);
        if (signature == null) {
            throw new IllegalArgumentException("el must be either CtInvocation or CtExecutable");
        }
        return signature;
    }

    private Set<CtExecutable<?>> getCallers(CtElement el) {
        MethodSignature signature = this.createSignature(el);
        if (!this.containsVertex(signature)) {
            return Set.of();
        }
        Set incomingEdges = this.incomingEdgesOf(signature);
        CtPackage rootPackage = (CtPackage)el.getParent(CtModelImpl.CtRootPackage.class);
        Set<CtExecutable<?>> executableSet = Collections.newSetFromMap(new IdentityHashMap());
        incomingEdges.forEach(e -> this.collectExecutablesFromClass((MethodSignature)e.getSourceNode(), rootPackage, executableSet));
        return executableSet;
    }

    @Override
    public Set<CtExecutable<?>> getCallers(CtInvocation<?> invocation) {
        return this.getCallers((CtElement)invocation);
    }

    @Override
    public Set<CtExecutable<?>> getCallers(CtExecutable<?> executable) {
        return this.getCallers((CtElement)executable);
    }

    private Set<CtExecutable<?>> getCalls(CtElement el) {
        MethodSignature signature = this.createSignature(el);
        if (!this.containsVertex(signature)) {
            return Set.of();
        }
        Set outgoingEdges = this.outgoingEdgesOf(signature);
        CtPackage rootPackage = (CtPackage)el.getParent(CtModelImpl.CtRootPackage.class);
        Set<CtExecutable<?>> executableSet = Collections.newSetFromMap(new IdentityHashMap());
        outgoingEdges.forEach(e -> this.collectExecutablesFromClass((MethodSignature)e.getTargetNode(), rootPackage, executableSet));
        return executableSet;
    }

    @Override
    public Set<CtExecutable<?>> getCalls(CtInvocation<?> invocation) {
        return this.getCalls((CtElement)invocation);
    }

    @Override
    public Set<CtExecutable<?>> getCalls(CtExecutable<?> executable) {
        return this.getCalls((CtElement)executable);
    }

    @Override
    public Set<SimpleEdge.Call> getEdgesBetween(MethodSignature source, MethodSignature target) {
        Set<SimpleEdge.Call> edges = this.getAllEdges(source, target);
        return edges != null ? edges : Set.of();
    }

    @Override
    public Set<SimpleEdge.Call> getOutgoingEdges(MethodSignature source) {
        return this.containsVertex(source) ? this.outgoingEdgesOf(source) : Set.of();
    }

    @Override
    public Set<SimpleEdge.Call> getIncomingEdges(MethodSignature source) {
        return this.containsVertex(source) ? this.incomingEdgesOf(source) : Set.of();
    }

    private void collectExecutablesFromClass(MethodSignature methodSignature, CtPackage rootPackage, Set<CtExecutable<?>> executableSet) {
        CtType<?> ctClass = this.getTypeFromFullName(methodSignature.getQualifiedName(), rootPackage);
        if (ctClass == null) {
            return;
        }
        executableSet.addAll(ctClass.getTypeMembers().stream().filter(x -> x instanceof CtExecutable).map(x -> (CtExecutable)x).filter(x -> this.isExecutableOfSignature((CtExecutable<?>)x, methodSignature)).collect(Collectors.toList()));
    }

    private boolean isExecutableOfSignature(CtExecutable<?> executable, MethodSignature signature) {
        return signature.getSimpleName().equals(executable.getSimpleName()) && executable.getParameters().stream().map(CtTypedElement::getType).map(CtTypeReference::getSimpleName).collect(Collectors.toList()).equals(signature.getParameters());
    }

    private CtType<?> getTypeFromFullName(String name, CtPackage rootPackage) {
        String[] packs = name.split("\\.");
        CtPackage ctPackage = rootPackage;
        for (int i = 0; i < packs.length - 1; ++i) {
            if (ctPackage == null) continue;
            ctPackage = ctPackage.getPackage(packs[i]);
        }
        if (ctPackage == null) {
            return null;
        }
        String[] typeName = packs[packs.length - 1].split("\\$");
        CtType ctType = ctPackage.getType(typeName[0]);
        if (ctType == null) {
            return null;
        }
        for (int i = 1; i < typeName.length; ++i) {
            String type = typeName[i];
            Optional<CtType> optional = ctType.getTypeMembers().stream().filter(x -> x instanceof CtType).map(x -> (CtType)x).filter(x -> x.getSimpleName().equals(type)).findAny();
            if (!optional.isPresent()) continue;
            ctType = optional.get();
        }
        return ctType;
    }
}

