/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.call;

import com.pvsstudio.dataflow.call.CallGraph;
import com.pvsstudio.dataflow.call.CallGraphImpl;
import com.pvsstudio.dataflow.call.MethodSignature;
import com.pvsstudio.dataflow.graph.InvocationEdge;
import java.util.List;
import java.util.Optional;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class CallGraphBuilder {
    private CallGraphImpl callGraph;

    public CallGraphBuilder(CallGraph callGraph) {
        this.callGraph = (CallGraphImpl)callGraph;
    }

    public void buildCallGraph(CtExecutable<?> exe, MethodSignature signature) {
        if (this.isEmptyConstructor(exe)) {
            return;
        }
        this.callGraph.addVertex(signature);
        if (exe.getBody() == null) {
            return;
        }
        List invocationList = exe.getBody().getElements((Filter)new TypeFilter(CtAbstractInvocation.class));
        for (CtAbstractInvocation inv : invocationList) {
            MethodSignature invType;
            if (inv instanceof CtNewClass || inv instanceof CtInvocation && ((CtInvocation)inv).getTarget() != null && this.isStandardJavaPackage((CtInvocation)inv) || (invType = MethodSignature.of(inv)) == null || invType.getQualifiedName().startsWith("java.")) continue;
            this.callGraph.addVertex(invType);
            this.callGraph.addEdge(signature, invType, (Object)new InvocationEdge(inv));
        }
    }

    private boolean isStandardJavaPackage(CtInvocation<?> inv) {
        return inv.getExecutable() != null && inv.getExecutable().getDeclaringType() != null && inv.getExecutable().getDeclaringType().getQualifiedName().startsWith("java.") || inv.getTarget() instanceof CtTypeAccess && ((CtTypeAccess)inv.getTarget()).getAccessedType().getQualifiedName().startsWith("java.");
    }

    private boolean isEmptyConstructor(CtExecutable<?> exe) {
        return exe instanceof CtConstructor && exe.getParameters().isEmpty() && exe.getBody().getStatements().isEmpty() || Optional.of(exe).filter(e -> e.getBody() != null).filter(e -> e.getBody().getStatements().size() == 1).map(e -> e.getBody().getStatements()).filter(s -> s.get(0) instanceof CtInvocation).map(s -> (CtInvocation)s.get(0)).filter(i -> i.getArguments().isEmpty()).filter(i -> i.getExecutable().getSimpleName().equals("<init>")).isPresent();
    }
}

