/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.dataflow.java.DataFlowImpl;
import com.pvsstudio.dataflow.taint.cache.TaintCacheModule;
import com.pvsstudio.dataflow.taint.utils.tracer.TaintDumbPrinter;
import com.pvsstudio.dataflow.taint.utils.tracer.TaintLoggingPrinter;
import com.pvsstudio.dataflow.taint.utils.tracer.TaintPrinter;

public class DataFlowModule
extends AbstractModule {
    private final AnalyzerConfig config;
    private final boolean isDevelopmentVersion;

    public DataFlowModule() {
        this.config = null;
        this.isDevelopmentVersion = false;
    }

    public DataFlowModule(AnalyzerConfig config, boolean isDevelopmentVersion) {
        this.config = config;
        this.isDevelopmentVersion = isDevelopmentVersion;
    }

    protected void configure() {
        this.install((Module)new TaintCacheModule());
        this.bind(DataFlow.class).to(DataFlowImpl.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    private TaintPrinter providesPrinter() {
        if (this.config != null && this.isDevelopmentVersion) {
            this.config.configureTaintLogger();
            return new TaintLoggingPrinter();
        }
        return new TaintDumbPrinter();
    }
}

