/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow;

import com.pvsstudio.dataflow.call.CallGraphBuilder;
import com.pvsstudio.dataflow.call.MethodSignature;
import com.pvsstudio.dataflow.graph.GraphModel;
import com.pvsstudio.dataflow.graph.GraphModelImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.CtModel;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.visitor.CtScanner;

public class DataFlowLauncher {
    private CallGraphBuilder callGraphBuilder;
    private static final Logger logger = LoggerFactory.getLogger(DataFlowLauncher.class);

    public GraphModel buildGraphModel(CtModel model) {
        GraphModelImpl result = new GraphModelImpl();
        this.callGraphBuilder = new CallGraphBuilder(result.getCallGraph());
        CtScanner scanner = new CtScanner(){

            public <T> void visitCtMethod(CtMethod<T> method) {
                DataFlowLauncher.this.buildCallGraphVertex((CtExecutable<?>)method);
            }

            public <T> void visitCtConstructor(CtConstructor<T> constructor) {
                DataFlowLauncher.this.buildCallGraphVertex((CtExecutable<?>)constructor);
            }

            public <T> void visitCtNewClass(CtNewClass<T> newClass) {
            }

            public <T> void visitCtLambda(CtLambda<T> lambda) {
            }
        };
        scanner.scan((CtElement)model.getRootPackage());
        return result;
    }

    private void buildCallGraphVertex(CtExecutable<?> executable) {
        try {
            MethodSignature signature = MethodSignature.of(executable);
            if (signature == null) {
                logger.error("{} method type is not found", (Object)executable.getSimpleName());
                return;
            }
            this.callGraphBuilder.buildCallGraph(executable, signature);
        }
        catch (RuntimeException ex) {
            logger.error("Exception on dataflow build: ", (Throwable)ex);
        }
    }
}

