/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DOMToModelPopulator;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.TypeNameMatchRequestorWrapper;
import org.eclipse.jdt.internal.core.util.Util;

public class DOMCodeSelector {
    private final CompilationUnit unit;
    private final WorkingCopyOwner owner;

    public DOMCodeSelector(CompilationUnit unit, WorkingCopyOwner owner) {
        this.unit = unit;
        this.owner = owner;
    }

    public IJavaElement[] codeSelect(int offset, int length) throws JavaModelException {
        boolean newChildFound;
        IBinding binding;
        Object type;
        ASTNode node;
        if (offset < 0) {
            throw new JavaModelException(new IndexOutOfBoundsException(offset), 980);
        }
        if (offset + length > this.unit.getSource().length()) {
            throw new JavaModelException(new IndexOutOfBoundsException(offset + length), 980);
        }
        org.eclipse.jdt.core.dom.CompilationUnit currentAST = this.unit.getOrBuildAST(this.owner);
        if (currentAST == null) {
            return new IJavaElement[0];
        }
        String rawText = this.unit.getSource().substring(offset, offset + length);
        int initialOffset = offset;
        int initialLength = length;
        boolean insideComment = currentAST.getCommentList().stream().anyMatch(comment -> comment.getStartPosition() <= initialOffset && comment.getStartPosition() + comment.getLength() >= initialOffset + initialLength);
        if (!insideComment) {
            boolean changed = false;
            do {
                changed = false;
                if (length > 0 && Character.isWhitespace(this.unit.getSource().charAt(offset))) {
                    ++offset;
                    --length;
                    changed = true;
                }
                if (length > 0 && Character.isWhitespace(this.unit.getSource().charAt(offset + length - 1))) {
                    changed = true;
                }
                List comments = currentAST.getCommentList();
                int offset1 = offset;
                int length1 = --length;
                OptionalInt leadingCommentEnd = comments.stream().filter(comment -> {
                    int commentEndOffset = comment.getStartPosition() + comment.getLength() - 1;
                    return comment.getStartPosition() <= offset1 && commentEndOffset > offset1 && commentEndOffset < offset1 + length1 - 1;
                }).mapToInt(comment -> comment.getStartPosition() + comment.getLength() - 1).findAny();
                if (length > 0 && leadingCommentEnd.isPresent()) {
                    changed = true;
                    int newStart = leadingCommentEnd.getAsInt();
                    int removedLeading = newStart + 1 - offset;
                    offset = newStart + 1;
                    length -= removedLeading;
                }
                int offset2 = offset;
                int length2 = length;
                OptionalInt trailingCommentStart = comments.stream().filter(comment -> comment.getStartPosition() >= offset2 && comment.getStartPosition() < offset2 + length2 && comment.getStartPosition() + comment.getLength() > offset2 + length2).mapToInt(ASTNode::getStartPosition).findAny();
                if (length <= 0 || !trailingCommentStart.isPresent()) continue;
                changed = true;
                int newEnd = trailingCommentStart.getAsInt();
                int removedTrailing = offset + length - 1 - newEnd;
                length -= removedTrailing;
            } while (changed);
        }
        String trimmedText = rawText.trim();
        NodeFinder finder = new NodeFinder(currentAST, offset, length);
        ASTNode aSTNode = node = finder.getCoveredNode() != null && finder.getCoveredNode().getStartPosition() > offset && finder.getCoveringNode().getStartPosition() + finder.getCoveringNode().getLength() > offset + length ? finder.getCoveredNode() : finder.getCoveringNode();
        if (node instanceof TagElement && "@inheritDoc".equals(((TagElement)node).getTagName())) {
            Javadoc javadoc;
            ASTNode parent;
            IBinding binding2;
            TagElement tagElement = (TagElement)node;
            ASTNode javadocNode = node;
            while (javadocNode != null && !(javadocNode instanceof Javadoc)) {
                javadocNode = javadocNode.getParent();
            }
            if (javadocNode instanceof Javadoc && (binding2 = DOMCodeSelector.resolveBinding(parent = (javadoc = (Javadoc)javadocNode).getParent())) instanceof IMethodBinding) {
                IJavaElement element;
                IMethodBinding methodBinding = (IMethodBinding)binding2;
                ITypeBinding typeBinding = methodBinding.getDeclaringClass();
                if (typeBinding != null) {
                    ArrayList<ITypeBinding> types = new ArrayList<ITypeBinding>(Arrays.asList(typeBinding.getInterfaces()));
                    if (typeBinding.getSuperclass() != null) {
                        types.add(typeBinding.getSuperclass());
                    }
                    while (!types.isEmpty()) {
                        type = (ITypeBinding)types.remove(0);
                        for (IMethodBinding m : Arrays.stream(type.getDeclaredMethods()).filter(methodBinding::overrides).collect(Collectors.toUnmodifiableList())) {
                            if (m.getJavaElement() instanceof IMethod && ((IMethod)m.getJavaElement()).getJavadocRange() != null) {
                                IMethod methodElement = (IMethod)m.getJavaElement();
                                return new IJavaElement[]{methodElement};
                            }
                            types.addAll(Arrays.asList(type.getInterfaces()));
                            if (type.getSuperclass() == null) continue;
                            types.add(type.getSuperclass());
                        }
                    }
                }
                if ((element = methodBinding.getJavaElement()) != null) {
                    return new IJavaElement[]{element};
                }
            }
        }
        ImportDeclaration importDecl = DOMCodeSelector.findImportDeclaration(node);
        if (node instanceof ExpressionMethodReference && ((ExpressionMethodReference)node).getExpression().getStartPosition() + ((ExpressionMethodReference)node).getExpression().getLength() <= offset && offset + length <= ((ExpressionMethodReference)node).getName().getStartPosition()) {
            VariableDeclaration variableDeclaration;
            ITypeBinding requestedType;
            ExpressionMethodReference emr = (ExpressionMethodReference)node;
            if (!(rawText.isEmpty() || rawText.equals(":") || rawText.equals("::"))) {
                return new IJavaElement[0];
            }
            if (emr.getParent() instanceof MethodInvocation) {
                MethodInvocation methodInvocation = (MethodInvocation)emr.getParent();
                int index = methodInvocation.arguments().indexOf(emr);
                return new IJavaElement[]{methodInvocation.resolveMethodBinding().getParameterTypes()[index].getDeclaredMethods()[0].getJavaElement()};
            }
            if (emr.getParent() instanceof VariableDeclaration && (requestedType = (variableDeclaration = (VariableDeclaration)emr.getParent()).resolveBinding().getType()).getDeclaredMethods().length == 1 && requestedType.getDeclaredMethods()[0].getJavaElement() instanceof IMethod) {
                IMethod overridenMethod = (IMethod)requestedType.getDeclaredMethods()[0].getJavaElement();
                return new IJavaElement[]{overridenMethod};
            }
        }
        if (node instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)node;
            if (!(rawText.isEmpty() || rawText.equals("-") || rawText.equals(">") || rawText.equals("->"))) {
                return new IJavaElement[0];
            }
            if (lambda.resolveMethodBinding() != null && lambda.resolveMethodBinding().getMethodDeclaration() != null && lambda.resolveMethodBinding().getMethodDeclaration().getJavaElement() != null) {
                return new IJavaElement[]{lambda.resolveMethodBinding().getMethodDeclaration().getJavaElement()};
            }
        }
        if (importDecl != null && importDecl.isStatic()) {
            IBinding importBinding = importDecl.resolveBinding();
            if (importBinding instanceof IMethodBinding) {
                IMethodBinding methodBinding = (IMethodBinding)importBinding;
                ArrayDeque overloadedMethods = Stream.of(methodBinding.getDeclaringClass().getDeclaredMethods()).filter(otherMethodBinding -> methodBinding.getName().equals(otherMethodBinding.getName())).map(IBinding::getJavaElement).filter(IJavaElement::exists).collect(Collectors.toCollection(ArrayDeque::new));
                IJavaElement[] reorderedOverloadedMethods = new IJavaElement[overloadedMethods.size()];
                Iterator reverseIterator = overloadedMethods.descendingIterator();
                int i = 0;
                while (i < reorderedOverloadedMethods.length) {
                    reorderedOverloadedMethods[i] = (IJavaElement)reverseIterator.next();
                    ++i;
                }
                return reorderedOverloadedMethods;
            }
            return new IJavaElement[]{importBinding.getJavaElement()};
        }
        if (DOMCodeSelector.findTypeDeclaration(node) == null && (binding = DOMCodeSelector.resolveBinding(node)) != null && !binding.isRecovered()) {
            IJavaElement parent;
            IMethod method;
            Optional<ILocalVariable> parameter;
            IVariableBinding variableBinding;
            IField field;
            if (node instanceof SuperMethodInvocation && binding instanceof IMethodBinding && ((IMethodBinding)binding).getDeclaringClass() instanceof ITypeBinding && ((IMethodBinding)binding).getDeclaringClass().getJavaElement() instanceof IType) {
                IType type2 = (IType)((IMethodBinding)binding).getDeclaringClass().getJavaElement();
                ITypeBinding typeBinding = ((IMethodBinding)binding).getDeclaringClass();
                IMethodBinding methodBinding = (IMethodBinding)binding;
                return new IJavaElement[]{type2};
            }
            if (binding instanceof IPackageBinding && trimmedText.length() > 0 && !trimmedText.equals(((IPackageBinding)binding).getName()) && ((IPackageBinding)binding).getName().startsWith(trimmedText)) {
                IPackageBinding packageBinding = (IPackageBinding)binding;
                IJavaElement fragment = this.unit.getJavaProject().findPackageFragment(trimmedText);
                if (fragment != null) {
                    return new IJavaElement[]{fragment};
                }
            }
            if (binding instanceof IVariableBinding && ((IVariableBinding)binding).getDeclaringMethod() instanceof IMethodBinding && ((IVariableBinding)binding).getDeclaringMethod().isCompactConstructor()) {
                if (Arrays.stream(((IVariableBinding)binding).getDeclaringMethod().getParameterNames()).anyMatch(((IVariableBinding)binding).getName()::equals) && ((IVariableBinding)binding).getDeclaringMethod().getDeclaringClass() instanceof ITypeBinding && ((IVariableBinding)binding).getDeclaringMethod().getDeclaringClass().isRecord() && ((IVariableBinding)binding).getDeclaringMethod().getDeclaringClass().getJavaElement() instanceof IType && ((IType)((IVariableBinding)binding).getDeclaringMethod().getDeclaringClass().getJavaElement()).getField(((IVariableBinding)binding).getName()) instanceof SourceField) {
                    IType recordType = (IType)((IVariableBinding)binding).getDeclaringMethod().getDeclaringClass().getJavaElement();
                    field = (SourceField)recordType.getField(((IVariableBinding)binding).getName());
                    ITypeBinding recordBinding = ((IVariableBinding)binding).getDeclaringMethod().getDeclaringClass();
                    IMethodBinding declaringMethod = ((IVariableBinding)binding).getDeclaringMethod();
                    IVariableBinding variableBinding2 = (IVariableBinding)binding;
                    return new IJavaElement[]{new LocalVariable((JavaElement)((Object)field), variableBinding2.getName(), 0, ((SourceRefElement)((Object)field)).getSourceRange().getOffset() + ((SourceRefElement)((Object)field)).getSourceRange().getLength() - 1, ((Member)((Object)field)).getNameRange().getOffset(), ((Member)((Object)field)).getNameRange().getOffset() + ((Member)((Object)field)).getNameRange().getLength() - 1, ((SourceField)field).getTypeSignature(), null, ((Member)((Object)field)).getFlags(), true)};
                }
            }
            if (binding instanceof ITypeBinding && ((ITypeBinding)binding).isIntersectionType()) {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                return (IJavaElement[])Arrays.stream(typeBinding.getTypeBounds()).map(IBinding::getJavaElement).filter(Objects::nonNull).toArray(IJavaElement[]::new);
            }
            IJavaElement element = binding.getJavaElement();
            if (element != null && (element instanceof IPackageFragment || element.exists())) {
                return new IJavaElement[]{element};
            }
            if (binding instanceof ITypeBinding) {
                IType type3;
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (this.unit.getJavaProject() != null && (type3 = this.unit.getJavaProject().findType(typeBinding.getQualifiedName())) != null) {
                    return new IJavaElement[]{type3};
                }
                IJavaElement[] indexMatch = this.findTypeInIndex(typeBinding.getPackage() != null ? typeBinding.getPackage().getName() : null, typeBinding.getName());
                if (indexMatch.length > 0) {
                    return indexMatch;
                }
            }
            if (binding instanceof IVariableBinding && ((IVariableBinding)binding).getDeclaringMethod() != null && ((IVariableBinding)binding).getDeclaringMethod().isCompactConstructor() && (variableBinding = (IVariableBinding)binding).getDeclaringMethod().getJavaElement() instanceof IMethod && (parameter = Arrays.stream((method = (IMethod)variableBinding.getDeclaringMethod().getJavaElement()).getParameters()).filter(param -> Objects.equals(param.getElementName(), variableBinding.getName())).findAny()).isPresent()) {
                return new IJavaElement[]{parameter.get()};
            }
            if (binding instanceof IMethodBinding && ((IMethodBinding)binding).isSyntheticRecordMethod() && ((IMethodBinding)binding).getDeclaringClass().getJavaElement() instanceof IType && ((IType)((IMethodBinding)binding).getDeclaringClass().getJavaElement()).getField(((IMethodBinding)binding).getName()) instanceof IField) {
                field = ((IType)((IMethodBinding)binding).getDeclaringClass().getJavaElement()).getField(((IMethodBinding)binding).getName());
                IType recordType = (IType)((IMethodBinding)binding).getDeclaringClass().getJavaElement();
                IMethodBinding methodBinding = (IMethodBinding)binding;
                return new IJavaElement[]{field};
            }
            ASTNode bindingNode = currentAST.findDeclaringNode(binding);
            if (bindingNode != null && (parent = this.unit.getElementAt(bindingNode.getStartPosition())) != null && bindingNode instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration variableDecl = (SingleVariableDeclaration)bindingNode;
                return new IJavaElement[]{DOMToModelPopulator.toLocalVariable(variableDecl, (JavaElement)parent)};
            }
        }
        IJavaElement currentElement = this.unit;
        int finalOffset = offset;
        int finalLength = length;
        do {
            newChildFound = false;
            if (!(currentElement instanceof IParent)) continue;
            IParent parentElement = currentElement;
            Optional<IJavaElement> candidate = Stream.of(parentElement.getChildren()).filter(ISourceReference.class::isInstance).map(ISourceReference.class::cast).filter(sourceRef -> {
                try {
                    ISourceRange elementRange = sourceRef.getSourceRange();
                    return elementRange != null && elementRange.getOffset() >= 0 && elementRange.getOffset() <= finalOffset && elementRange.getOffset() + elementRange.getLength() >= finalOffset + finalLength;
                }
                catch (JavaModelException e) {
                    return false;
                }
            }).map(IJavaElement.class::cast).findAny();
            if (!candidate.isPresent()) continue;
            newChildFound = true;
            currentElement = candidate.get();
        } while (newChildFound);
        if (currentElement instanceof JavaElement && ((JavaElement)currentElement).getElementInfo() instanceof AnnotatableInfo && ((AnnotatableInfo)((JavaElement)currentElement).getElementInfo()).getNameSourceStart() >= 0 && ((AnnotatableInfo)((JavaElement)currentElement).getElementInfo()).getNameSourceStart() <= offset && ((AnnotatableInfo)((JavaElement)currentElement).getElementInfo()).getNameSourceEnd() + 1 >= offset) {
            AnnotatableInfo annotable = (AnnotatableInfo)((JavaElement)currentElement).getElementInfo();
            JavaElement impl = currentElement;
            return new IJavaElement[]{currentElement};
        }
        if (insideComment) {
            String toSearch = trimmedText.isBlank() ? this.findWord(offset) : trimmedText;
            String resolved = currentAST.imports().stream().map(ImportDeclaration::getName).map(ASTNode::toString).filter(importedPackage -> importedPackage.endsWith(toSearch)).findAny().orElse(toSearch);
            if (this.unit.getJavaProject().findType(resolved) instanceof IType) {
                IType type4 = this.unit.getJavaProject().findType(resolved);
                return new IJavaElement[]{type4};
            }
        }
        ASTNode currentNode = node;
        while (currentNode != null && !(currentNode instanceof Type)) {
            currentNode = currentNode.getParent();
        }
        if (currentNode instanceof Type) {
            String packageName;
            Type parentType = (Type)currentNode;
            if (this.unit.getJavaProject() != null) {
                StringBuilder buffer = new StringBuilder();
                Util.getFullyQualifiedName(parentType, buffer);
                type = this.unit.getJavaProject().findType(buffer.toString());
                if (type != null) {
                    return new IJavaElement[]{type};
                }
            }
            String string = parentType instanceof QualifiedType ? ((QualifiedType)parentType).getQualifier().toString() : (parentType instanceof SimpleType ? (((SimpleType)parentType).getName() instanceof QualifiedName ? ((QualifiedName)((SimpleType)parentType).getName()).getQualifier().toString() : null) : (packageName = null));
            String simpleName = parentType instanceof QualifiedType ? ((QualifiedType)parentType).getName().toString() : (parentType instanceof SimpleType ? (((SimpleType)parentType).getName() instanceof SimpleName ? ((SimpleName)((SimpleType)parentType).getName()).getIdentifier() : (((SimpleType)parentType).getName() instanceof QualifiedName ? ((QualifiedName)((SimpleType)parentType).getName()).getName().toString() : null)) : null);
            IJavaElement[] indexResult = this.findTypeInIndex(packageName, simpleName);
            if (indexResult.length > 0) {
                return indexResult;
            }
        }
        return new IJavaElement[0];
    }

    static IBinding resolveBinding(ASTNode node) {
        if (node instanceof MethodDeclaration) {
            MethodDeclaration decl = (MethodDeclaration)node;
            return decl.resolveBinding();
        }
        if (node instanceof MethodInvocation) {
            MethodInvocation invocation = (MethodInvocation)node;
            return invocation.resolveMethodBinding();
        }
        if (node instanceof VariableDeclaration) {
            VariableDeclaration decl = (VariableDeclaration)node;
            return decl.resolveBinding();
        }
        if (node instanceof FieldAccess) {
            FieldAccess access = (FieldAccess)node;
            return access.resolveFieldBinding();
        }
        if (node instanceof Type) {
            Type type = (Type)node;
            return type.resolveBinding();
        }
        if (node instanceof Name) {
            IMethodBinding constructorBinding;
            Name aName = (Name)node;
            ClassInstanceCreation newInstance = DOMCodeSelector.findConstructor(aName);
            if (newInstance != null && (constructorBinding = newInstance.resolveConstructorBinding()) != null) {
                IJavaElement constructorElement = constructorBinding.getJavaElement();
                if (constructorElement != null) {
                    boolean hasSource = true;
                    try {
                        hasSource = ((ISourceReference)((Object)constructorElement.getParent())).getSource() != null;
                    }
                    catch (Exception e) {
                        hasSource = false;
                    }
                    if (constructorBinding.getParameterTypes().length > 0 || constructorElement instanceof SourceMethod || !hasSource) {
                        return constructorBinding;
                    }
                } else if (newInstance.resolveTypeBinding().isAnonymous()) {
                    ITypeBinding superclassBinding = newInstance.getType().resolveBinding();
                    while (superclassBinding != null) {
                        Optional<IMethodBinding> potentialConstructor = Stream.of(superclassBinding.getDeclaredMethods()).filter(methodBinding -> methodBinding.isConstructor() && DOMCodeSelector.matchSignatures(constructorBinding, methodBinding)).findFirst();
                        if (potentialConstructor.isPresent()) {
                            IMethodBinding theConstructor = potentialConstructor.get();
                            if (theConstructor.isDefaultConstructor()) {
                                return theConstructor.getDeclaringClass();
                            }
                            return theConstructor;
                        }
                        superclassBinding = superclassBinding.getSuperclass();
                    }
                    return null;
                }
            }
            if (node.getParent() instanceof ExpressionMethodReference && ((ExpressionMethodReference)node.getParent()).getName() == node) {
                ExpressionMethodReference exprMethodReference = (ExpressionMethodReference)node.getParent();
                return DOMCodeSelector.resolveBinding(exprMethodReference);
            }
            if (node.getParent() instanceof TypeMethodReference && ((TypeMethodReference)node.getParent()).getName() == node) {
                TypeMethodReference typeMethodReference = (TypeMethodReference)node.getParent();
                return DOMCodeSelector.resolveBinding(typeMethodReference);
            }
            IBinding res = aName.resolveBinding();
            if (res != null) {
                return res;
            }
            return DOMCodeSelector.resolveBinding(aName.getParent());
        }
        if (node instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)node;
            return lambda.resolveMethodBinding();
        }
        if (node instanceof ExpressionMethodReference) {
            boolean allowExtraParam;
            IMethodBinding methodBinding2;
            ExpressionMethodReference methodRef;
            block36: {
                block35: {
                    methodRef = (ExpressionMethodReference)node;
                    methodBinding2 = methodRef.resolveMethodBinding();
                    if (methodBinding2 != null) break block35;
                    return null;
                }
                IMethod methodModel = (IMethod)methodBinding2.getJavaElement();
                allowExtraParam = true;
                if ((methodModel.getFlags() & 8) == 0) break block36;
                allowExtraParam = false;
                if (!(methodRef.getExpression() instanceof ClassInstanceCreation)) break block36;
                return null;
            }
            try {
                ITypeBinding type = null;
                ASTNode cursor = methodRef;
                while (type == null && cursor != null) {
                    if (cursor.getParent() instanceof VariableDeclarationFragment) {
                        VariableDeclarationFragment declFragment = (VariableDeclarationFragment)cursor.getParent();
                        type = declFragment.resolveBinding().getType();
                        continue;
                    }
                    if (cursor.getParent() instanceof MethodInvocation) {
                        MethodInvocation methodInvocation = (MethodInvocation)cursor.getParent();
                        IMethodBinding methodInvocationBinding = methodInvocation.resolveMethodBinding();
                        int index = methodInvocation.arguments().indexOf(cursor);
                        type = methodInvocationBinding.getParameterTypes()[index];
                        continue;
                    }
                    cursor = cursor.getParent();
                }
                IMethodBinding boundMethod = type.getDeclaredMethods()[0];
                if (!(boundMethod.getParameterTypes().length == methodBinding2.getParameterTypes().length || allowExtraParam && boundMethod.getParameterTypes().length == methodBinding2.getParameterTypes().length + 1)) {
                    return null;
                }
            }
            catch (JavaModelException e) {
                return null;
            }
            return methodBinding2;
        }
        if (node instanceof MethodReference) {
            MethodReference methodRef = (MethodReference)node;
            return methodRef.resolveMethodBinding();
        }
        if (node instanceof TypeParameter) {
            TypeParameter typeParameter = (TypeParameter)node;
            return typeParameter.resolveBinding();
        }
        if (node instanceof SuperConstructorInvocation) {
            SuperConstructorInvocation superConstructor = (SuperConstructorInvocation)node;
            return superConstructor.resolveConstructorBinding();
        }
        if (node instanceof ConstructorInvocation) {
            ConstructorInvocation constructor = (ConstructorInvocation)node;
            return constructor.resolveConstructorBinding();
        }
        if (node instanceof Annotation) {
            Annotation annotation = (Annotation)node;
            return annotation.resolveTypeBinding();
        }
        if (node instanceof SuperMethodInvocation) {
            SuperMethodInvocation superMethod = (SuperMethodInvocation)node;
            return superMethod.resolveMethodBinding();
        }
        return null;
    }

    private static ClassInstanceCreation findConstructor(ASTNode node) {
        while (node != null && !(node instanceof ClassInstanceCreation)) {
            ASTNode parent = node.getParent();
            node = parent instanceof SimpleType && ((SimpleType)parent).getName() == node || parent instanceof ClassInstanceCreation && ((ClassInstanceCreation)parent).getType() == node || parent instanceof ParameterizedType && ((ParameterizedType)parent).getType() == node ? parent : null;
        }
        return (ClassInstanceCreation)node;
    }

    private static AbstractTypeDeclaration findTypeDeclaration(ASTNode node) {
        ASTNode cursor = node;
        while (cursor != null && (cursor instanceof Type || cursor instanceof Name)) {
            cursor = cursor.getParent();
        }
        if (cursor instanceof AbstractTypeDeclaration && ((AbstractTypeDeclaration)cursor).getName() == node) {
            AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)cursor;
            return typeDecl;
        }
        return null;
    }

    private static ImportDeclaration findImportDeclaration(ASTNode node) {
        while (node != null && !(node instanceof ImportDeclaration)) {
            node = node.getParent();
        }
        return (ImportDeclaration)node;
    }

    private static boolean matchSignatures(IMethodBinding invocation, IMethodBinding declaration) {
        if (declaration.getTypeParameters().length == 0) {
            return invocation.isSubsignature(declaration);
        }
        if (invocation.getParameterTypes().length != declaration.getParameterTypes().length) {
            return false;
        }
        int i = 0;
        while (i < invocation.getParameterTypes().length) {
            if (declaration.getParameterTypes()[i].isTypeVariable()) {
                if (declaration.getParameterTypes()[i].getTypeBounds().length > 0) {
                    ITypeBinding[] bounds = declaration.getParameterTypes()[i].getTypeBounds();
                    int j = 0;
                    while (j < bounds.length) {
                        if (!invocation.getParameterTypes()[i].isSubTypeCompatible(bounds[j])) {
                            return false;
                        }
                        ++j;
                    }
                }
            } else if (!invocation.getParameterTypes()[i].isSubTypeCompatible(declaration.getParameterTypes()[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IJavaElement[] findTypeInIndex(String packageName, String simpleName) throws JavaModelException {
        final ArrayList indexMatch = new ArrayList();
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            @Override
            public void acceptTypeNameMatch(TypeNameMatch match) {
                indexMatch.add(match.getType());
            }
        };
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope(new IJavaProject[]{this.unit.getJavaProject()});
        new SearchEngine(this.owner).searchAllTypeNames(packageName != null ? packageName.toCharArray() : null, 0, simpleName.toCharArray(), 8, 0, scope, requestor, 3, (IProgressMonitor)new NullProgressMonitor());
        if (!indexMatch.isEmpty()) {
            return (IJavaElement[])indexMatch.toArray(IJavaElement[]::new);
        }
        scope = BasicSearchEngine.createWorkspaceScope();
        new BasicSearchEngine(this.owner).searchAllTypeNames(packageName != null ? packageName.toCharArray() : null, 0, simpleName.toCharArray(), 8, 0, scope, new TypeNameMatchRequestorWrapper(requestor, scope), 3, (IProgressMonitor)new NullProgressMonitor());
        if (!indexMatch.isEmpty()) {
            return (IJavaElement[])indexMatch.toArray(IJavaElement[]::new);
        }
        return new IJavaElement[0];
    }

    private String findWord(int offset) throws JavaModelException {
        int start = offset;
        String source = this.unit.getSource();
        while (start >= 0 && Character.isJavaIdentifierPart(source.charAt(start))) {
            --start;
        }
        int end = offset + 1;
        while (end < source.length() && Character.isJavaIdentifierPart(source.charAt(end))) {
            ++end;
        }
        return source.substring(start, end);
    }
}

