/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FakeDefaultLiteral;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.YieldStatement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;

public class SwitchStatement
extends Expression {
    public static final SingletonBootstrap PRIMITIVE_CLASS__BOOTSTRAP = new SingletonBootstrap("ConstantBootStraps.primitiveClass", PRIMITIVE_CLASS, PRIMITIVE_CLASS__SIGNATURE);
    public static final SingletonBootstrap GET_STATIC_FINAL__BOOTSTRAP = new SingletonBootstrap("ConstantBootStraps.getStaticFinal", GET_STATIC_FINAL, GET_STATIC_FINAL__SIGNATURE);
    public Expression expression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public BranchLabel breakLabel;
    public CaseStatement[] cases;
    public CaseStatement defaultCase;
    public CaseStatement nullCase;
    public int blockStart;
    public int caseCount;
    int[] constants;
    int[] constMapping;
    public CaseStatement.ResolvedCase[] otherConstants;
    public int nConstants;
    public int switchBits;
    public boolean containsPatterns;
    public boolean containsRecordPatterns;
    public boolean containsNull;
    boolean nullProcessed = false;
    BranchLabel switchPatternRestartTarget;
    public Pattern totalPattern;
    public static final int CASE = 0;
    public static final int FALLTHROUGH = 1;
    public static final int ESCAPING = 2;
    public static final int BREAKING = 3;
    public static final int LabeledRules = 1;
    public static final int NullCase = 2;
    public static final int TotalPattern = 4;
    public static final int Exhaustive = 8;
    public static final int QualifiedEnum = 16;
    public static final int LabeledBlockStatementGroup = 32;
    private static final char[] SecretStringVariableName = " switchDispatchString".toCharArray();
    static final char[] SecretPatternVariableName = " switchDispatchPattern".toCharArray();
    private static final char[] SecretPatternRestartIndexName = " switchPatternRestartIndex".toCharArray();
    public SyntheticMethodBinding synthetic;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;
    Statement[] duplicateCases = null;
    int duplicateCaseCounter = 0;
    private LocalVariableBinding dispatchStringCopy = null;
    LocalVariableBinding dispatchPatternCopy = null;
    LocalVariableBinding restartIndexLocal = null;
    boolean isNonTraditional = false;
    boolean isPrimitiveSwitch = false;
    List<Pattern> caseLabelElements = new ArrayList<Pattern>(0);
    public List<TypeBinding> caseLabelElementTypes = new ArrayList<TypeBinding>(0);
    int constantIndex = 0;

    protected int getFallThroughState(Statement stmt, BlockScope blockScope) {
        if ((this.switchBits & 1) != 0) {
            if (stmt.isTrulyExpression() || stmt instanceof ThrowStatement) {
                return 3;
            }
            if (!stmt.canCompleteNormally()) {
                return 3;
            }
            if (stmt instanceof Block) {
                int length;
                Block block = (Block)stmt;
                BreakStatement breakStatement = new BreakStatement(null, block.sourceEnd - 1, block.sourceEnd);
                breakStatement.isSynthetic = true;
                int n = length = block.statements == null ? 0 : block.statements.length;
                if (length == 0) {
                    block.statements = new Statement[]{breakStatement};
                    block.scope = this.scope;
                } else {
                    Statement[] newArray = new Statement[length + 1];
                    System.arraycopy(block.statements, 0, newArray, 0, length);
                    newArray[length] = breakStatement;
                    block.statements = newArray;
                }
                return 3;
            }
        }
        return 1;
    }

    protected boolean needToCheckFlowInAbsenceOfDefaultBranch() {
        return !this.isExhaustive();
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            TypeBinding resolvedTypeBinding;
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
            if (this.isNullHostile()) {
                this.expression.checkNPE(currentScope, flowContext, flowInfo, 1);
            }
            this.breakLabel = new BranchLabel();
            SwitchFlowContext switchContext = new SwitchFlowContext(flowContext, this, this.breakLabel, true, true);
            CompilerOptions compilerOptions = currentScope.compilerOptions();
            FlowInfo caseInits = FlowInfo.DEAD_END;
            this.preSwitchInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
            int caseIndex = 0;
            if (this.statements != null) {
                int initialComplaintLevel;
                int complaintLevel = initialComplaintLevel = (flowInfo.reachMode() & 3) != 0 ? 1 : 0;
                int fallThroughState = 0;
                int prevCaseStmtIndex = -100;
                int i = 0;
                int max = this.statements.length;
                while (i < max) {
                    Statement statement = this.statements[i];
                    if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                        this.scope.enclosingCase = this.cases[caseIndex];
                        ++caseIndex;
                        if (prevCaseStmtIndex == i - 1 && this.statements[prevCaseStmtIndex].containsPatternVariable()) {
                            this.scope.problemReporter().illegalFallthroughFromAPattern(this.statements[prevCaseStmtIndex]);
                        }
                        prevCaseStmtIndex = i;
                        if (fallThroughState == 1 && complaintLevel <= 0) {
                            if (statement.containsPatternVariable()) {
                                this.scope.problemReporter().IllegalFallThroughToPattern(this.scope.enclosingCase);
                            } else if ((statement.bits & 0x20000000) == 0) {
                                this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                            }
                        }
                        caseInits = caseInits.mergedWith(flowInfo.unconditionalInits());
                        complaintLevel = initialComplaintLevel;
                        fallThroughState = this.containsPatterns ? 1 : 0;
                    } else if (statement == this.defaultCase) {
                        this.scope.enclosingCase = this.defaultCase;
                        if (fallThroughState == 1 && complaintLevel <= 0 && (statement.bits & 0x20000000) == 0) {
                            this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                        }
                        caseInits = caseInits.mergedWith(flowInfo.unconditionalInits());
                        if ((this.switchBits & 1) != 0 && this.expression.resolvedType instanceof ReferenceBinding) {
                            if (this.expression instanceof NameReference) {
                                NameReference reference = (NameReference)this.expression;
                                if (reference.localVariableBinding() != null) {
                                    caseInits.markAsDefinitelyNonNull(reference.localVariableBinding());
                                } else if (reference.lastFieldBinding() != null && this.scope.compilerOptions().enableSyntacticNullAnalysisForFields) {
                                    switchContext.recordNullCheckedFieldReference(reference, 2);
                                }
                            } else if (this.expression instanceof FieldReference && this.scope.compilerOptions().enableSyntacticNullAnalysisForFields) {
                                switchContext.recordNullCheckedFieldReference((FieldReference)this.expression, 2);
                            }
                        }
                        complaintLevel = initialComplaintLevel;
                        fallThroughState = this.containsPatterns ? 1 : 0;
                    } else {
                        fallThroughState = this.getFallThroughState(statement, currentScope);
                    }
                    complaintLevel = statement.complainIfUnreachable(caseInits, this.scope, complaintLevel, true);
                    if (complaintLevel < 2) {
                        if ((caseInits = statement.analyseCode(this.scope, switchContext, caseInits)) == FlowInfo.DEAD_END) {
                            fallThroughState = 2;
                        }
                        if (compilerOptions.enableSyntacticNullAnalysisForFields) {
                            switchContext.expireNullCheckedFieldInfo();
                        }
                        if (compilerOptions.analyseResourceLeaks) {
                            FakedTrackingVariable.cleanUpUnassigned(this.scope, statement, caseInits, false);
                        }
                    }
                    ++i;
                }
            }
            if ((resolvedTypeBinding = this.expression.resolvedType).isEnum()) {
                SourceTypeBinding sourceTypeBinding = currentScope.classScope().referenceContext.binding;
                this.synthetic = sourceTypeBinding.addSyntheticMethodForSwitchEnum(resolvedTypeBinding, this);
            }
            if (this.defaultCase == null && this.needToCheckFlowInAbsenceOfDefaultBranch()) {
                flowInfo.addPotentialInitializationsFrom(caseInits.mergedWith(switchContext.initsOnBreak));
                this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
                FlowInfo flowInfo2 = flowInfo;
                return flowInfo2;
            }
            UnconditionalFlowInfo mergedInfo = caseInits.mergedWith(switchContext.initsOnBreak);
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
            UnconditionalFlowInfo unconditionalFlowInfo = mergedInfo;
            return unconditionalFlowInfo;
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private boolean isNullHostile() {
        if (this.containsNull) {
            return false;
        }
        if ((this.expression.implicitConversion & 0x400) != 0) {
            return true;
        }
        if (this.expression.resolvedType != null && (this.expression.resolvedType.id == 11 || this.expression.resolvedType.isEnum())) {
            return true;
        }
        return (this.switchBits & 3) == 1 && this.totalPattern == null;
    }

    public void generateCodeForStringSwitch(BlockScope currentScope, CodeStream codeStream) {
        try {
            if ((this.bits & Integer.MIN_VALUE) == 0) {
                return;
            }
            int pc = codeStream.position;
            boolean hasCases = this.caseCount != 0;
            int constSize = hasCases ? this.otherConstants.length : 0;
            BranchLabel[] sourceCaseLabels = this.gatherLabels(codeStream, new BranchLabel[this.nConstants], BranchLabel::new);
            class StringSwitchCase
            implements Comparable {
                int hashCode;
                String string;
                BranchLabel label;

                public StringSwitchCase(int hashCode, String string, BranchLabel label) {
                    this.hashCode = hashCode;
                    this.string = string;
                    this.label = label;
                }

                public int compareTo(Object o) {
                    StringSwitchCase that = (StringSwitchCase)o;
                    if (this.hashCode == that.hashCode) {
                        return 0;
                    }
                    if (this.hashCode > that.hashCode) {
                        return 1;
                    }
                    return -1;
                }

                public String toString() {
                    return "StringSwitchCase :\ncase " + this.hashCode + ":(" + this.string + ")\n";
                }
            }
            Object[] stringCases = new StringSwitchCase[constSize];
            CaseLabel[] hashCodeCaseLabels = new CaseLabel[constSize];
            this.constants = new int[constSize];
            int i = 0;
            while (i < constSize) {
                String literal = this.otherConstants[i].c.stringValue();
                stringCases[i] = new StringSwitchCase(literal.hashCode(), literal, sourceCaseLabels[this.constMapping[i]]);
                hashCodeCaseLabels[i] = new CaseLabel(codeStream);
                hashCodeCaseLabels[i].tagBits |= 2;
                ++i;
            }
            Arrays.sort(stringCases);
            int uniqHashCount = 0;
            int lastHashCode = 0;
            int i2 = 0;
            int length = constSize;
            while (i2 < length) {
                int hashCode = ((StringSwitchCase)stringCases[i2]).hashCode;
                if (i2 == 0 || hashCode != lastHashCode) {
                    int n = uniqHashCount++;
                    int n2 = hashCode;
                    this.constants[n] = n2;
                    lastHashCode = n2;
                }
                ++i2;
            }
            if (uniqHashCount != constSize) {
                this.constants = new int[uniqHashCount];
                System.arraycopy(this.constants, 0, this.constants, 0, uniqHashCount);
                CaseLabel[] caseLabelArray = hashCodeCaseLabels;
                hashCodeCaseLabels = new CaseLabel[uniqHashCount];
                System.arraycopy(caseLabelArray, 0, hashCodeCaseLabels, 0, uniqHashCount);
            }
            int[] sortedIndexes = new int[uniqHashCount];
            int i3 = 0;
            while (i3 < uniqHashCount) {
                sortedIndexes[i3] = i3;
                ++i3;
            }
            CaseLabel defaultCaseLabel = new CaseLabel(codeStream);
            defaultCaseLabel.tagBits |= 2;
            this.breakLabel.initialize(codeStream);
            BranchLabel defaultBranchLabel = new BranchLabel(codeStream);
            if (hasCases) {
                defaultBranchLabel.tagBits |= 2;
            }
            if (this.defaultCase != null) {
                this.defaultCase.targetLabel = defaultBranchLabel;
            }
            this.expression.generateCode(currentScope, codeStream, true);
            codeStream.store(this.dispatchStringCopy, true);
            codeStream.addVariable(this.dispatchStringCopy);
            codeStream.invokeStringHashCode();
            if (hasCases) {
                codeStream.lookupswitch(defaultCaseLabel, this.constants, sortedIndexes, hashCodeCaseLabels);
                int i4 = 0;
                int j = 0;
                int max = constSize;
                while (i4 < max) {
                    int hashCode = ((StringSwitchCase)stringCases[i4]).hashCode;
                    if (i4 == 0 || hashCode != lastHashCode) {
                        lastHashCode = hashCode;
                        if (i4 != 0) {
                            codeStream.goto_(defaultBranchLabel);
                        }
                        hashCodeCaseLabels[j++].place();
                    }
                    codeStream.load(this.dispatchStringCopy);
                    codeStream.ldc(((StringSwitchCase)stringCases[i4]).string);
                    codeStream.invokeStringEquals();
                    codeStream.ifne(((StringSwitchCase)stringCases[i4]).label);
                    ++i4;
                }
                codeStream.goto_(defaultBranchLabel);
            } else {
                codeStream.pop();
            }
            int caseIndex = 0;
            if (this.statements != null) {
                Statement[] statementArray = this.statements;
                int n = this.statements.length;
                int n3 = 0;
                while (n3 < n) {
                    Statement statement = statementArray[n3];
                    if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                        this.scope.enclosingCase = this.cases[caseIndex];
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        }
                        if (statement == this.defaultCase) {
                            defaultCaseLabel.place();
                        }
                        ++caseIndex;
                    } else if (statement == this.defaultCase) {
                        defaultCaseLabel.place();
                        this.scope.enclosingCase = this.defaultCase;
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        }
                    }
                    this.statementGenerateCode(currentScope, codeStream, statement);
                    ++n3;
                }
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            codeStream.removeVariable(this.dispatchStringCopy);
            if (this.scope != currentScope) {
                codeStream.exitUserScope(this.scope);
            }
            this.breakLabel.place();
            if (this.defaultCase == null) {
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd, true);
                defaultCaseLabel.place();
                defaultBranchLabel.place();
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private <T extends BranchLabel> T[] gatherLabels(CodeStream codeStream, T[] caseLabels, Function<CodeStream, T> newLabel) {
        int i = 0;
        int j = 0;
        int max = this.caseCount;
        while (i < max) {
            CaseStatement stmt = this.cases[i];
            Expression[] peeledLabelExpressions = stmt.peeledLabelExpressions();
            int l = peeledLabelExpressions.length;
            BranchLabel[] targetLabels = new BranchLabel[l];
            int count = 0;
            int k = 0;
            while (k < l) {
                Expression e = peeledLabelExpressions[k];
                if (!(e instanceof FakeDefaultLiteral)) {
                    int n = count++;
                    caseLabels[j] = (BranchLabel)newLabel.apply(codeStream);
                    targetLabels[n] = caseLabels[j];
                    if (e == this.totalPattern) {
                        this.defaultCase = stmt;
                    }
                    ((BranchLabel)caseLabels[j++]).tagBits |= 2;
                }
                ++k;
            }
            stmt.targetLabels = new BranchLabel[count];
            System.arraycopy(targetLabels, 0, stmt.targetLabels, 0, count);
            ++i;
        }
        return caseLabels;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if (this.expression.resolvedType.id == 11 && !this.isNonTraditional) {
            this.generateCodeForStringSwitch(currentScope, codeStream);
            return;
        }
        try {
            int min;
            boolean hasCases;
            if ((this.bits & Integer.MIN_VALUE) == 0) {
                return;
            }
            int pc = codeStream.position;
            this.breakLabel.initialize(codeStream);
            int constantCount = this.otherConstants == null ? 0 : this.otherConstants.length;
            CaseLabel[] caseLabels = (CaseLabel[])this.gatherLabels(codeStream, new CaseLabel[this.nConstants], CaseLabel::new);
            CaseLabel defaultLabel = new CaseLabel(codeStream);
            boolean bl = hasCases = this.caseCount != 0;
            if (hasCases) {
                defaultLabel.tagBits |= 2;
            }
            if (this.defaultCase != null) {
                this.defaultCase.targetLabel = defaultLabel;
            }
            TypeBinding resolvedType1 = this.expression.resolvedType;
            boolean valueRequired = false;
            if (this.needPatternDispatchCopy()) {
                this.generateCodeSwitchPatternPrologue(currentScope, codeStream);
                valueRequired = true;
                this.transformConstants();
            } else if (resolvedType1.isEnum()) {
                codeStream.invoke((byte)-72, this.synthetic, null);
                this.expression.generateCode(currentScope, codeStream, true);
                codeStream.invokeEnumOrdinal(resolvedType1.constantPoolName());
                codeStream.iaload();
                if (!hasCases) {
                    codeStream.pop();
                }
                valueRequired = hasCases;
            } else {
                valueRequired = this.expression.constant == Constant.NotAConstant || hasCases;
                this.expression.generateCode(currentScope, codeStream, valueRequired);
                if (resolvedType1.id == 33) {
                    codeStream.generateUnboxingConversion(5);
                }
            }
            if (hasCases) {
                int[] sortedIndexes = new int[constantCount];
                int i = 0;
                while (i < constantCount) {
                    sortedIndexes[i] = i;
                    ++i;
                }
                int[] localKeysCopy = new int[constantCount];
                System.arraycopy(this.constants, 0, localKeysCopy, 0, constantCount);
                CodeStream.sort(localKeysCopy, 0, constantCount - 1, sortedIndexes);
                int max = localKeysCopy[constantCount - 1];
                min = localKeysCopy[0];
                if ((long)((double)constantCount * 2.5) > (long)max - (long)min) {
                    codeStream.tableswitch(defaultLabel, min, max, this.constants, sortedIndexes, this.constMapping, caseLabels);
                } else {
                    codeStream.lookupswitch(defaultLabel, this.constants, sortedIndexes, caseLabels);
                }
                codeStream.recordPositionsFrom(codeStream.position, this.expression.sourceEnd);
            } else if (valueRequired) {
                codeStream.pop();
            }
            int caseIndex = 0;
            int typeSwitchIndex = 0;
            if (this.statements != null) {
                Statement[] statementArray = this.statements;
                int n = this.statements.length;
                min = 0;
                while (min < n) {
                    Statement statement = statementArray[min];
                    CaseStatement caseStatement = null;
                    if (caseIndex < constantCount && statement == this.cases[caseIndex]) {
                        this.scope.enclosingCase = this.cases[caseIndex];
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        }
                        caseStatement = (CaseStatement)statement;
                        ++caseIndex;
                        caseStatement.typeSwitchIndex = typeSwitchIndex;
                        typeSwitchIndex += caseStatement.constantExpressions.length;
                    } else if (statement == this.defaultCase) {
                        this.scope.enclosingCase = this.defaultCase;
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        }
                    }
                    this.statementGenerateCode(currentScope, codeStream, statement);
                    ++min;
                }
            }
            boolean needsThrowingDefault = false;
            if (this.defaultCase == null) {
                needsThrowingDefault = resolvedType1.isEnum() && (this instanceof SwitchExpression || this.containsNull);
                needsThrowingDefault |= this.isExhaustive();
            }
            if (needsThrowingDefault) {
                CompilerOptions compilerOptions;
                if (this.preSwitchInitStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                }
                CompilerOptions compilerOptions2 = compilerOptions = this.scope != null ? this.scope.compilerOptions() : null;
                if (compilerOptions.complianceLevel >= 0x3F0000L) {
                    if (this.statements.length > 0 && this.statements[this.statements.length - 1].canCompleteNormally()) {
                        codeStream.goto_(this.breakLabel);
                    }
                    defaultLabel.place();
                    codeStream.newJavaLangMatchException();
                    codeStream.dup();
                    codeStream.aconst_null();
                    codeStream.aconst_null();
                    codeStream.invokeJavaLangMatchExceptionConstructor();
                    codeStream.athrow();
                } else {
                    defaultLabel.place();
                    codeStream.newJavaLangIncompatibleClassChangeError();
                    codeStream.dup();
                    codeStream.invokeJavaLangIncompatibleClassChangeErrorDefaultConstructor();
                    codeStream.athrow();
                }
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            this.generateCodeSwitchPatternEpilogue(codeStream);
            if (this.scope != currentScope) {
                codeStream.exitUserScope(this.scope);
            }
            this.breakLabel.place();
            if (this.defaultCase == null && !needsThrowingDefault) {
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd, true);
                defaultLabel.place();
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private void transformConstants() {
        int i;
        if (this.nullCase == null) {
            i = 0;
            int l = this.otherConstants.length;
            while (i < l) {
                if (this.otherConstants[i].e == this.totalPattern) {
                    this.otherConstants[i].index = -1;
                    break;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.constants.length) {
            this.constants[i] = this.otherConstants[i].index;
            ++i;
        }
    }

    private void generateCodeSwitchPatternEpilogue(CodeStream codeStream) {
        if (this.needPatternDispatchCopy()) {
            codeStream.removeVariable(this.dispatchPatternCopy);
            codeStream.removeVariable(this.restartIndexLocal);
        }
    }

    private void generateCodeSwitchPatternPrologue(BlockScope currentScope, CodeStream codeStream) {
        this.expression.generateCode(currentScope, codeStream, true);
        if ((this.switchBits & 2) == 0 && !this.expression.resolvedType.isPrimitiveType()) {
            codeStream.dup();
            codeStream.invokeJavaUtilObjectsrequireNonNull();
            codeStream.pop();
        }
        codeStream.store(this.dispatchPatternCopy, false);
        codeStream.addVariable(this.dispatchPatternCopy);
        codeStream.loadInt(0);
        codeStream.store(this.restartIndexLocal, false);
        codeStream.addVariable(this.restartIndexLocal);
        this.switchPatternRestartTarget = new BranchLabel(codeStream);
        this.switchPatternRestartTarget.place();
        codeStream.load(this.dispatchPatternCopy);
        codeStream.load(this.restartIndexLocal);
        int invokeDynamicNumber = codeStream.classFile.recordBootstrapMethod(this);
        if (this.expression.resolvedType.isEnum()) {
            this.generateEnumSwitchPatternPrologue(codeStream, invokeDynamicNumber);
        } else {
            this.generateTypeSwitchPatternPrologue(codeStream, invokeDynamicNumber);
        }
        boolean hasQualifiedEnums = (this.switchBits & 0x10) != 0;
        int i = 0;
        while (i < this.otherConstants.length) {
            CaseStatement.ResolvedCase c = this.otherConstants[i];
            if (hasQualifiedEnums) {
                c.index = i;
            }
            if (c.t.isPrimitiveType()) {
                SingletonBootstrap descriptor = null;
                if (c.isPattern()) {
                    descriptor = PRIMITIVE_CLASS__BOOTSTRAP;
                } else if (c.t.id == 5) {
                    descriptor = GET_STATIC_FINAL__BOOTSTRAP;
                }
                if (descriptor != null) {
                    c.primitivesBootstrapIdx = codeStream.classFile.recordSingletonBootstrapMethod(descriptor);
                }
            } else if (c.isQualifiedEnum()) {
                int classdescIdx = codeStream.classFile.recordBootstrapMethod(c.t);
                c.enumDescIdx = invokeDynamicNumber = codeStream.classFile.recordBootstrapMethod(c);
                c.classDescIdx = classdescIdx;
            }
            ++i;
        }
    }

    private void generateTypeSwitchPatternPrologue(CodeStream codeStream, int invokeDynamicNumber) {
        TypeBinding exprType = this.expression.resolvedType;
        char[] signature = this.typeSwitchSignature(exprType);
        int argsSize = TypeIds.getCategory(exprType.id) + 1;
        codeStream.invokeDynamic(invokeDynamicNumber, argsSize, 1, ConstantPool.TYPESWITCH, signature, TypeBinding.INT);
    }

    char[] typeSwitchSignature(TypeBinding exprType) {
        char[] arg1;
        switch (exprType.id) {
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                arg1 = this.isPrimitiveSwitch ? exprType.signature() : "Ljava/lang/Object;".toCharArray();
                break;
            }
            default: {
                arg1 = exprType.id > 128 && exprType.erasure().isBoxedPrimitiveType() ? exprType.erasure().signature() : (exprType.isPrimitiveType() ? exprType.signature() : "Ljava/lang/Object;".toCharArray());
            }
        }
        return CharOperation.concat("(".toCharArray(), arg1, "I)I".toCharArray());
    }

    private void generateEnumSwitchPatternPrologue(CodeStream codeStream, int invokeDynamicNumber) {
        String genericTypeSignature = new String(this.expression.resolvedType.genericTypeSignature());
        String callingParams = "(" + genericTypeSignature + "I)I";
        codeStream.invokeDynamic(invokeDynamicNumber, 2, 1, "enumSwitch".toCharArray(), callingParams.toCharArray(), TypeBinding.INT);
    }

    protected void statementGenerateCode(BlockScope currentScope, CodeStream codeStream, Statement statement) {
        statement.generateCode(this.scope, codeStream);
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        this.generateCode(currentScope, codeStream);
    }

    @Override
    public StringBuilder printStatement(int indent, StringBuilder output) {
        SwitchStatement.printIndent(indent, output).append("switch (");
        this.expression.printExpression(0, output).append(") {");
        if (this.statements != null) {
            Statement[] statementArray = this.statements;
            int n = this.statements.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray[n2];
                output.append('\n');
                if (statement instanceof CaseStatement) {
                    statement.printStatement(indent, output);
                } else {
                    statement.printStatement(indent + 2, output);
                }
                ++n2;
            }
        }
        output.append("\n");
        return SwitchStatement.printIndent(indent, output).append('}');
    }

    private int getNConstants() {
        int n = 0;
        Statement[] statementArray = this.statements;
        int n2 = this.statements.length;
        int n3 = 0;
        while (n3 < n2) {
            Statement statement = statementArray[n3];
            if (statement instanceof CaseStatement) {
                Expression[] exprs = ((CaseStatement)statement).peeledLabelExpressions();
                int count = 0;
                if (exprs != null) {
                    Expression[] expressionArray = exprs;
                    int n4 = exprs.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Expression e = expressionArray[n5];
                        if (!(e instanceof FakeDefaultLiteral)) {
                            ++count;
                        }
                        ++n5;
                    }
                }
                n += count;
            }
            ++n3;
        }
        return n;
    }

    boolean isAllowedType(TypeBinding type) {
        if (type == null) {
            return false;
        }
        switch (type.id) {
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void resolve(BlockScope upperScope) {
        try {
            CompilerOptions compilerOptions;
            TypeBinding expressionType;
            block49: {
                block51: {
                    block50: {
                        expressionType = this.expression.resolveType(upperScope);
                        compilerOptions = upperScope.compilerOptions();
                        if (expressionType == null) break block49;
                        this.expression.computeConversion(upperScope, expressionType, expressionType);
                        if (expressionType.isValidBinding()) break block50;
                        expressionType = null;
                        break block49;
                    }
                    if (!expressionType.isBaseType()) break block51;
                    if (JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(compilerOptions)) {
                        this.isPrimitiveSwitch = true;
                    }
                    if (this.expression.isConstantValueOfTypeAssignableToType(expressionType, TypeBinding.INT) || expressionType.isCompatibleWith(TypeBinding.INT)) break block49;
                }
                if (expressionType.id != 11 && !expressionType.isEnum() && !upperScope.isBoxingCompatibleWith(expressionType, TypeBinding.INT)) {
                    if (!JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(compilerOptions) || expressionType.isBaseType() && expressionType.id != 12 && expressionType.id != 6) {
                        if (!this.isPrimitiveSwitch) {
                            upperScope.problemReporter().incorrectSwitchType(this.expression, expressionType);
                            expressionType = null;
                        }
                    } else {
                        this.isNonTraditional = true;
                    }
                }
            }
            if (expressionType != null) {
                this.reserveSecretVariablesSlots(upperScope);
            }
            if (this.statements != null) {
                if (this.scope == null) {
                    this.scope = new BlockScope(upperScope);
                }
                int length = this.statements.length;
                this.cases = new CaseStatement[length];
                this.nConstants = this.getNConstants();
                this.constants = new int[this.nConstants];
                this.otherConstants = new CaseStatement.ResolvedCase[this.nConstants];
                this.constMapping = new int[this.nConstants];
                int counter = 0;
                int caseCounter = 0;
                Pattern[] patterns = new Pattern[this.nConstants];
                int[] caseIndex = new int[this.nConstants];
                LocalVariableBinding[] patternVariables = NO_VARIABLES;
                boolean caseNullDefaultFound = false;
                boolean defaultFound = false;
                Pattern aTotalPattern = null;
                int i = 0;
                while (i < length) {
                    Statement statement = this.statements[i];
                    if (statement instanceof CaseStatement) {
                        CaseStatement caseStmt = (CaseStatement)statement;
                        caseNullDefaultFound |= this.isCaseStmtNullDefault(caseStmt);
                        defaultFound |= caseStmt.constantExpressions == Expression.NO_EXPRESSIONS;
                        CaseStatement.ResolvedCase[] constantsList = caseStmt.resolveCase(this.scope, expressionType, this);
                        patternVariables = statement.bindingsWhenTrue();
                        CaseStatement.ResolvedCase[] resolvedCaseArray = constantsList;
                        int n = constantsList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Constant con;
                            CaseStatement.ResolvedCase c = resolvedCaseArray[n2];
                            if (c.e instanceof Pattern && ((Pattern)c.e).isTotalTypeNode && ((Pattern)c.e).isUnguarded) {
                                Pattern p;
                                aTotalPattern = p = (Pattern)c.e;
                            }
                            if ((con = c.c) != Constant.NotAConstant) {
                                int c1;
                                this.otherConstants[counter] = c;
                                this.constants[counter] = c1 = this.containsPatterns ? (c.intValue() == -1 ? -1 : counter) : c.intValue();
                                if (counter == 0 && defaultFound && (c.isPattern() || this.isCaseStmtNullOnly(caseStmt))) {
                                    this.scope.problemReporter().patternDominatedByAnother(c.e);
                                }
                                int j = 0;
                                while (j < counter) {
                                    IntPredicate check = idx -> {
                                        CaseStatement.ResolvedCase otherResolvedCase = this.otherConstants[idx];
                                        Constant c2 = otherResolvedCase.c;
                                        if (con.typeID() == 11) {
                                            return c2.stringValue().equals(con.stringValue());
                                        }
                                        if (c2.typeID() == 11) {
                                            return false;
                                        }
                                        int id = resolvedCase.t.id;
                                        int otherId = otherResolvedCase.t.id;
                                        if (id == 12 || otherId == 12) {
                                            return id == otherId;
                                        }
                                        if (con.equals(c2)) {
                                            return true;
                                        }
                                        if (id == 5) {
                                            this.switchBits |= 8;
                                        }
                                        return this.constants[idx] == c1;
                                    };
                                    TypeBinding type = c.e.resolvedType;
                                    if (type.isValidBinding()) {
                                        if ((caseNullDefaultFound || defaultFound) && (c.isPattern() || this.isCaseStmtNullOnly(caseStmt))) {
                                            this.scope.problemReporter().patternDominatedByAnother(c.e);
                                            break;
                                        }
                                        Pattern p1 = patterns[j];
                                        if (p1 != null) {
                                            if (c.isPattern()) {
                                                if (p1.dominates((Pattern)c.e)) {
                                                    this.scope.problemReporter().patternDominatedByAnother(c.e);
                                                }
                                            } else if (type.id != 12) {
                                                if (type.isBaseType()) {
                                                    type = this.scope.environment().computeBoxingType(type);
                                                }
                                                if (p1.coversType(type, this.scope)) {
                                                    this.scope.problemReporter().patternDominatedByAnother(c.e);
                                                }
                                            }
                                        } else if (!c.isPattern() && check.test(j)) {
                                            if (this.isNonTraditional) {
                                                this.reportDuplicateCase(c.e, this.otherConstants[j].e, length);
                                            } else {
                                                this.reportDuplicateCase(caseStmt, this.cases[caseIndex[j]], length);
                                            }
                                        }
                                    }
                                    ++j;
                                }
                                this.constMapping[counter] = counter;
                                caseIndex[counter] = caseCounter;
                                if (c.e instanceof Pattern) {
                                    patterns[counter] = (Pattern)c.e;
                                }
                                ++counter;
                            }
                            ++n2;
                        }
                        ++caseCounter;
                    } else {
                        statement.resolveWithBindings(patternVariables, this.scope);
                        patternVariables = LocalVariableBinding.merge(patternVariables, statement.bindingsWhenComplete());
                    }
                    ++i;
                }
                if (!defaultFound && aTotalPattern != null) {
                    this.totalPattern = aTotalPattern;
                }
                if (expressionType != null && (expressionType.id == 5 || expressionType.id == 33) && defaultFound && this.isExhaustive()) {
                    upperScope.problemReporter().caseDefaultPlusTrueAndFalse(this);
                }
                if (length != counter) {
                    this.otherConstants = new CaseStatement.ResolvedCase[counter];
                    System.arraycopy(this.otherConstants, 0, this.otherConstants, 0, counter);
                    this.constants = new int[counter];
                    System.arraycopy(this.constants, 0, this.constants, 0, counter);
                    this.constMapping = new int[counter];
                    System.arraycopy(this.constMapping, 0, this.constMapping, 0, counter);
                }
            } else if ((this.bits & 8) != 0) {
                upperScope.problemReporter().undocumentedEmptyBlock(this.blockStart, this.sourceEnd);
            }
            if (expressionType != null) {
                if (!expressionType.isBaseType() && upperScope.isBoxingCompatibleWith(expressionType, TypeBinding.INT)) {
                    if (this.containsPatterns || this.containsNull) {
                        if ((!JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(compilerOptions) || expressionType.isBaseType() && expressionType.id != 12 && expressionType.id != 6) && !this.isPrimitiveSwitch) {
                            upperScope.problemReporter().incorrectSwitchType(this.expression, expressionType);
                            expressionType = null;
                        }
                    } else {
                        this.expression.computeConversion(upperScope, TypeBinding.INT, expressionType);
                    }
                }
                this.releaseUnusedSecretVariables(upperScope);
                this.complainIfNotExhaustiveSwitch(upperScope, expressionType, compilerOptions);
            }
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private void complainIfNotExhaustiveSwitch(BlockScope upperScope, TypeBinding selectorType, CompilerOptions compilerOptions) {
        boolean isEnhanced = this.isEnhancedSwitch(upperScope, selectorType);
        if (selectorType != null && selectorType.isEnum()) {
            Set<FieldBinding> unenumeratedConstants;
            int constantCount;
            if (isEnhanced) {
                this.switchBits |= 8;
            }
            if (this.defaultCase != null && !compilerOptions.reportMissingEnumCaseDespiteDefault) {
                return;
            }
            int n = constantCount = this.otherConstants == null ? 0 : this.otherConstants.length;
            if ((this.switchBits & 4) == 0 && (this.containsPatterns || this.containsNull || constantCount >= this.caseCount && constantCount != ((ReferenceBinding)selectorType).enumConstantCount()) && (unenumeratedConstants = this.unenumeratedConstants((ReferenceBinding)selectorType, constantCount)).size() != 0) {
                this.switchBits &= 0xFFFFFFF7;
                if (this.defaultCase == null || (this.defaultCase.bits & 0x40000000) == 0) {
                    if (isEnhanced) {
                        upperScope.problemReporter().enhancedSwitchMissingDefaultCase(this.expression);
                    } else {
                        for (FieldBinding enumConstant : unenumeratedConstants) {
                            this.reportMissingEnumConstantCase(upperScope, enumConstant);
                        }
                    }
                }
            }
            if (this.defaultCase == null) {
                if (this instanceof SwitchExpression || compilerOptions.getSeverity(0x40008000) == 256) {
                    upperScope.methodScope().hasMissingSwitchDefault = true;
                } else {
                    upperScope.problemReporter().missingDefaultCase(this, true, selectorType);
                }
            }
            return;
        }
        if (this.isExhaustive() || this.defaultCase != null || selectorType == null) {
            if (isEnhanced) {
                this.switchBits |= 8;
            }
            return;
        }
        if (JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(compilerOptions) && selectorType.isSealed() && this.caseElementsCoverSealedType((ReferenceBinding)selectorType, this.caseLabelElementTypes)) {
            this.switchBits |= 8;
            return;
        }
        if (selectorType.isRecordWithComponents() && this.containsRecordPatterns && this.caseElementsCoverRecordType(upperScope, compilerOptions, (ReferenceBinding)selectorType)) {
            this.switchBits |= 8;
            return;
        }
        if (!this.isExhaustive()) {
            if (isEnhanced) {
                upperScope.problemReporter().enhancedSwitchMissingDefaultCase(this.expression);
            } else {
                upperScope.problemReporter().missingDefaultCase(this, false, selectorType);
            }
        }
    }

    private Set<FieldBinding> unenumeratedConstants(ReferenceBinding enumType, int constantCount) {
        FieldBinding[] enumFields = ((ReferenceBinding)enumType.erasure()).fields();
        HashSet<FieldBinding> unenumerated = new HashSet<FieldBinding>(Arrays.asList(enumFields));
        int i = 0;
        int max = enumFields.length;
        while (i < max) {
            FieldBinding enumConstant = enumFields[i];
            if ((enumConstant.modifiers & 0x4000) == 0) {
                unenumerated.remove(enumConstant);
            } else {
                int j = 0;
                while (j < constantCount) {
                    if (TypeBinding.equalsEquals(this.otherConstants[j].e.resolvedType, enumType) && this.otherConstants[j].e instanceof NameReference) {
                        NameReference reference = (NameReference)this.otherConstants[j].e;
                        FieldBinding field = reference.fieldBinding();
                        int intValue = field.original().id + 1;
                        if (enumConstant.id + 1 == intValue) {
                            unenumerated.remove(enumConstant);
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return unenumerated;
    }

    private boolean isCaseStmtNullDefault(CaseStatement caseStmt) {
        return caseStmt != null && caseStmt.constantExpressions.length == 2 && caseStmt.constantExpressions[0] instanceof NullLiteral && caseStmt.constantExpressions[1] instanceof FakeDefaultLiteral;
    }

    private boolean isCaseStmtNullOnly(CaseStatement caseStmt) {
        return caseStmt != null && caseStmt.constantExpressions.length == 1 && caseStmt.constantExpressions[0] instanceof NullLiteral;
    }

    private boolean isExhaustive() {
        return (this.switchBits & 8) != 0;
    }

    private boolean isEnhancedSwitch(BlockScope upperScope, TypeBinding expressionType) {
        if (JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(upperScope.compilerOptions()) && expressionType != null && !(this instanceof SwitchExpression)) {
            boolean acceptableType = !expressionType.isEnum();
            switch (expressionType.id) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    acceptableType = false;
                }
            }
            if (acceptableType || this.containsPatterns || this.containsNull) {
                return true;
            }
        }
        if (expressionType != null && !(this instanceof SwitchExpression) && JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(upperScope.compilerOptions())) {
            switch (expressionType.id) {
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean caseElementsCoverRecordType(BlockScope skope, CompilerOptions compilerOptions, ReferenceBinding recordType) {
        RNode head = new RNode(recordType);
        for (Pattern pattern : this.caseLabelElements) {
            head.addPattern(pattern);
        }
        CoverageCheckerVisitor ccv = new CoverageCheckerVisitor();
        head.traverse(ccv);
        return ccv.covers;
    }

    private boolean caseElementsCoverSealedType(ReferenceBinding sealedType, List<TypeBinding> listedTypes) {
        List<ReferenceBinding> allAllowedTypes = sealedType.getAllEnumerableAvatars();
        Iterator<ReferenceBinding> iterator = allAllowedTypes.iterator();
        block0: while (iterator.hasNext()) {
            int constantCount;
            Set<FieldBinding> unenumeratedConstants;
            ReferenceBinding next = iterator.next();
            if (next.isAbstract() && next.isSealed()) {
                iterator.remove();
                continue;
            }
            if (next.isEnum() && (unenumeratedConstants = this.unenumeratedConstants(next, constantCount = this.otherConstants == null ? 0 : this.otherConstants.length)).size() == 0) {
                iterator.remove();
                continue;
            }
            for (TypeBinding type : listedTypes) {
                if (!next.erasure().isCompatibleWith(type.erasure())) continue;
                iterator.remove();
                continue block0;
            }
        }
        return allAllowedTypes.size() == 0;
    }

    private boolean needPatternDispatchCopy() {
        TypeBinding eType;
        if (this.containsPatterns || (this.switchBits & 0x10) != 0) {
            return true;
        }
        if (this.containsNull) {
            return true;
        }
        TypeBinding typeBinding = eType = this.expression != null ? this.expression.resolvedType : null;
        if (eType == null) {
            return false;
        }
        switch (eType.id) {
            case 30: 
            case 31: 
            case 32: {
                return true;
            }
            case 7: 
            case 8: 
            case 9: {
                if (!this.isPrimitiveSwitch) break;
                return true;
            }
        }
        return !eType.isPrimitiveOrBoxedPrimitiveType() && !eType.isEnum() && eType.id != 11;
    }

    private void reserveSecretVariablesSlots(BlockScope upperScope) {
        if (this.expression.resolvedType.id == 11) {
            this.dispatchStringCopy = new LocalVariableBinding(SecretStringVariableName, (TypeBinding)upperScope.getJavaLangString(), 0, false);
            upperScope.addLocalVariable(this.dispatchStringCopy);
            this.dispatchStringCopy.setConstant(Constant.NotAConstant);
        }
        this.scope = new BlockScope(upperScope);
        this.dispatchPatternCopy = new LocalVariableBinding(SecretPatternVariableName, this.expression.resolvedType, 0, false);
        this.scope.addLocalVariable(this.dispatchPatternCopy);
        this.dispatchPatternCopy.setConstant(Constant.NotAConstant);
        this.restartIndexLocal = new LocalVariableBinding(SecretPatternRestartIndexName, (TypeBinding)TypeBinding.INT, 0, false);
        this.scope.addLocalVariable(this.restartIndexLocal);
        this.restartIndexLocal.setConstant(Constant.NotAConstant);
    }

    private void releaseUnusedSecretVariables(BlockScope upperScope) {
        if (this.expression.resolvedType.id == 11 && !this.isNonTraditional) {
            this.dispatchStringCopy.useFlag = 1;
        }
        if (this.needPatternDispatchCopy()) {
            this.dispatchPatternCopy.useFlag = 1;
            this.restartIndexLocal.useFlag = 1;
        }
    }

    protected void reportMissingEnumConstantCase(BlockScope upperScope, FieldBinding enumConstant) {
        upperScope.problemReporter().missingEnumConstantCase(this, enumConstant);
    }

    @Override
    public boolean isTrulyExpression() {
        return false;
    }

    private void reportDuplicateCase(Statement duplicate, Statement original, int length) {
        if (this.duplicateCases == null) {
            this.scope.problemReporter().duplicateCase(original);
            if (duplicate != original) {
                this.scope.problemReporter().duplicateCase(duplicate);
            }
            this.duplicateCases = new Statement[length];
            this.duplicateCases[this.duplicateCaseCounter++] = original;
            if (duplicate != original) {
                this.duplicateCases[this.duplicateCaseCounter++] = duplicate;
            }
        } else {
            boolean found = false;
            int k = 2;
            while (k < this.duplicateCaseCounter) {
                if (this.duplicateCases[k] == duplicate) {
                    found = true;
                    break;
                }
                ++k;
            }
            if (!found) {
                this.scope.problemReporter().duplicateCase(duplicate);
                this.duplicateCases[this.duplicateCaseCounter++] = duplicate;
            }
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.expression.traverse(visitor, blockScope);
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                int i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public void branchChainTo(BranchLabel label) {
        if (this.breakLabel.forwardReferenceCount() > 0) {
            label.becomeDelegateFor(this.breakLabel);
        }
    }

    @Override
    public boolean doesNotCompleteNormally() {
        if (this.statements == null || this.statements.length == 0) {
            return false;
        }
        Statement[] statementArray = this.statements;
        int n = this.statements.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            if (statement.breaksOut(null)) {
                return false;
            }
            ++n2;
        }
        return this.statements[this.statements.length - 1].doesNotCompleteNormally();
    }

    @Override
    public boolean completesByContinue() {
        if (this.statements == null || this.statements.length == 0) {
            return false;
        }
        Statement[] statementArray = this.statements;
        int n = this.statements.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            if (statement.completesByContinue()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean canCompleteNormally() {
        if (this.statements == null || this.statements.length == 0) {
            return true;
        }
        if ((this.switchBits & 1) == 0) {
            if (this.statements[this.statements.length - 1].canCompleteNormally()) {
                return true;
            }
            if (this.totalPattern == null && this.defaultCase == null) {
                return true;
            }
            Statement[] statementArray = this.statements;
            int n = this.statements.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray[n2];
                if (statement.breaksOut(null)) {
                    return true;
                }
                ++n2;
            }
        } else {
            Statement[] statementArray = this.statements;
            int n = this.statements.length;
            int n3 = 0;
            while (n3 < n) {
                Statement stmt = statementArray[n3];
                if (!(stmt instanceof CaseStatement)) {
                    if (this.totalPattern == null && this.defaultCase == null) {
                        return true;
                    }
                    if (stmt instanceof Expression) {
                        return true;
                    }
                    if (stmt.canCompleteNormally()) {
                        return true;
                    }
                    if (stmt instanceof YieldStatement && ((YieldStatement)stmt).isImplicit) {
                        return true;
                    }
                    if (stmt instanceof Block) {
                        Block block = (Block)stmt;
                        if (block.canCompleteNormally()) {
                            return true;
                        }
                        if (block.breaksOut(null)) {
                            return true;
                        }
                    }
                }
                ++n3;
            }
        }
        return false;
    }

    @Override
    public boolean continueCompletes() {
        if (this.statements == null || this.statements.length == 0) {
            return false;
        }
        Statement[] statementArray = this.statements;
        int n = this.statements.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            if (statement.continueCompletes()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        return this.printStatement(indent, output);
    }

    class CoverageCheckerVisitor
    extends NodeVisitor {
        public boolean covers;

        CoverageCheckerVisitor() {
            this.covers = true;
        }

        @Override
        public boolean visit(TNode node) {
            if (node.hasError) {
                return false;
            }
            ArrayList<TypeBinding> availableTypes = new ArrayList<TypeBinding>();
            if (node.children != null) {
                for (Node node2 : node.children) {
                    if (node.type.isSubtypeOf(node2.type, false)) {
                        this.covers = true;
                    }
                    node2.traverse(this);
                    if (node.type.isSubtypeOf(node2.type, false) && this.covers) {
                        return false;
                    }
                    availableTypes.add(node2.type);
                }
            }
            if (node.type instanceof ReferenceBinding && ((ReferenceBinding)node.type).isSealed()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)node.type;
                this.covers &= SwitchStatement.this.caseElementsCoverSealedType(referenceBinding, availableTypes);
                return this.covers;
            }
            this.covers = false;
            return false;
        }
    }

    class Node {
        TypeBinding type;
        boolean hasError = false;

        Node() {
        }

        public void traverse(NodeVisitor visitor) {
            visitor.visit(this);
            visitor.endVisit(this);
        }
    }

    abstract class NodeVisitor {
        NodeVisitor() {
        }

        public void endVisit(Node node) {
        }

        public void endVisit(PatternNode node) {
        }

        public void endVisit(RecordPatternNode node) {
        }

        public void endVisit(RNode node) {
        }

        public void endVisit(TNode node) {
        }

        public boolean visit(Node node) {
            return true;
        }

        public boolean visit(PatternNode node) {
            return true;
        }

        public boolean visit(RecordPatternNode node) {
            return true;
        }

        public boolean visit(RNode node) {
            return true;
        }

        public boolean visit(TNode node) {
            return true;
        }
    }

    class PatternNode
    extends Node {
        TNode next;

        PatternNode(TypeBinding type) {
            this.type = type;
        }

        public void addPattern(RecordPattern rp, int i) {
            TypeBinding ref = SwitchStatement.this.expression.resolvedType;
            if (!(ref instanceof ReferenceBinding)) {
                return;
            }
            RecordComponentBinding[] comps = ref.components();
            if (comps == null || comps.length <= i) {
                return;
            }
            if (this.next == null) {
                this.next = new TNode(comps[i].type);
            }
            this.next.addPattern(rp, i);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[Pattern node] {\n");
            sb.append("    type:");
            sb.append(this.type != null ? this.type.toString() : "null");
            sb.append("    next:");
            sb.append(this.next != null ? this.next.toString() : "null");
            sb.append("\n}\n");
            return sb.toString();
        }

        @Override
        public void traverse(NodeVisitor visitor) {
            if (visitor.visit(this) && this.next != null) {
                visitor.visit(this.next);
            }
            visitor.endVisit(this);
        }
    }

    class RNode
    extends Node {
        TNode firstComponent;

        RNode(TypeBinding rec) {
            RecordComponentBinding comp;
            int len;
            this.type = rec;
            RecordComponentBinding[] comps = rec.components();
            int n = len = comps != null ? comps.length : 0;
            if (len > 0 && (comp = comps[0]) != null && comp.type != null) {
                this.firstComponent = new TNode(comp.type);
            }
        }

        void addPattern(Pattern p) {
            if (p instanceof RecordPattern) {
                this.addPattern((RecordPattern)p);
            }
        }

        void addPattern(RecordPattern rp) {
            if (!TypeBinding.equalsEquals(this.type, rp.type.resolvedType)) {
                return;
            }
            if (this.firstComponent == null) {
                return;
            }
            this.firstComponent.addPattern(rp, 0);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[RNode] {\n");
            sb.append("    type:");
            sb.append(this.type != null ? this.type.toString() : "null");
            sb.append("    firstComponent:");
            sb.append(this.firstComponent != null ? this.firstComponent.toString() : "null");
            sb.append("\n}\n");
            return sb.toString();
        }

        @Override
        public void traverse(NodeVisitor visitor) {
            if (this.firstComponent != null) {
                visitor.visit(this.firstComponent);
            }
            visitor.endVisit(this);
        }
    }

    class RecordPatternNode
    extends PatternNode {
        RNode rNode;

        RecordPatternNode(TypeBinding type) {
            super(type);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[RecordPattern node] {\n");
            sb.append("    type:");
            sb.append(this.type != null ? this.type.toString() : "null");
            sb.append("    next:");
            sb.append(this.next != null ? this.next.toString() : "null");
            sb.append("    rNode:");
            sb.append(this.rNode != null ? this.rNode.toString() : "null");
            sb.append("\n}\n");
            return sb.toString();
        }

        @Override
        public void traverse(NodeVisitor visitor) {
            if (visitor.visit(this) && visitor.visit(this.rNode) && this.next != null) {
                visitor.visit(this.next);
            }
            visitor.endVisit(this);
        }
    }

    public static final class SingletonBootstrap {
        private final String id;
        private final char[] selector;
        private final char[] signature;

        public SingletonBootstrap(String id, char[] selector, char[] signature) {
            this.id = id;
            this.selector = selector;
            this.signature = signature;
        }

        public String id() {
            return this.id;
        }

        public char[] selector() {
            return this.selector;
        }

        public char[] signature() {
            return this.signature;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SingletonBootstrap that = (SingletonBootstrap)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.selector, that.selector) && Objects.equals(this.signature, that.signature);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.selector, this.signature);
        }

        public String toString() {
            return "SingletonBootstrap[id=" + this.id + ", selector=" + String.valueOf((Object)this.selector) + ", signature=" + String.valueOf((Object)this.signature) + "]";
        }
    }

    class TNode
    extends Node {
        List<PatternNode> children;

        TNode(TypeBinding type) {
            this.type = type;
            this.children = new ArrayList<PatternNode>();
        }

        public void addPattern(RecordPattern rp, int i) {
            if (rp.patterns.length <= i) {
                this.hasError = true;
                return;
            }
            TypeBinding childType = rp.patterns[i].resolvedType;
            PatternNode child = null;
            for (PatternNode c : this.children) {
                if (!TypeBinding.equalsEquals(childType, c.type)) continue;
                child = c;
                break;
            }
            if (child == null) {
                PatternNode patternNode = child = childType.isRecord() ? new RecordPatternNode(childType) : new PatternNode(childType);
                if (this.type.isSubtypeOf(childType, false)) {
                    this.children.add(0, child);
                } else {
                    this.children.add(child);
                }
            }
            if (i + 1 < rp.patterns.length) {
                child.addPattern(rp, i + 1);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[TNode] {\n");
            sb.append("    type:");
            sb.append(this.type != null ? this.type.toString() : "null");
            sb.append("    children:");
            if (this.children == null) {
                sb.append("null");
            } else {
                for (Node node : this.children) {
                    sb.append(node.toString());
                }
            }
            sb.append("\n}\n");
            return sb.toString();
        }

        @Override
        public void traverse(NodeVisitor visitor) {
            if (visitor.visit(this) && this.children != null) {
                for (PatternNode child : this.children) {
                    if (!visitor.visit(child)) break;
                }
            }
            visitor.endVisit(this);
        }
    }
}

