/*
 * Decompiled with CFR 0.152.
 */
package spoon.testing.utils;

import java.io.File;
import spoon.reflect.declaration.CtElement;
import spoon.support.visitor.equals.EqualsVisitor;

public final class Check {
    private Check() {
        throw new AssertionError();
    }

    public static void assertCtElementEquals(CtElement ct1, CtElement ct2) {
        EqualsVisitor ev = new EqualsVisitor();
        ev.checkEquals(ct1, ct2);
        if (!ev.isEqual()) {
            Object notEqual1 = ev.getNotEqualElement();
            Object notEqual2 = ev.getNotEqualOther();
            throw new AssertionError((Object)("elements no equal -- difference:\n" + ev.getNotEqualRole() + "\n" + (notEqual1 instanceof CtElement && ((CtElement)notEqual1).getPosition() != null ? ((CtElement)notEqual1).getPosition().toString() : "<unknown position>") + " \n" + (notEqual1 != null ? notEqual1.toString() : "null") + "\n is not \n" + (notEqual2 != null ? notEqual2.toString() : "null")));
        }
    }

    public static <T> T assertNotNull(String msg, T reference) {
        if (reference == null) {
            throw new AssertionError((Object)msg);
        }
        return reference;
    }

    public static <T> T assertNotNull(T reference) {
        return Check.assertNotNull("Your parameter can't be null.", reference);
    }

    public static <T extends File> T assertExists(T file) {
        if (!file.exists()) {
            throw new AssertionError((Object)"You should specify an existing file.");
        }
        return file;
    }

    public static <A extends CtElement, E extends CtElement> A assertIsSame(A actual, E expected) {
        Check.assertNotNull(actual);
        Check.assertNotNull(expected);
        if (!actual.getClass().equals(expected.getClass())) {
            throw new AssertionError((Object)String.format("Actual value is typed by %1$s and expected is typed by %2$s, these objects should be the same type.", actual.getClass().getName(), expected.getClass().getName()));
        }
        return actual;
    }
}

