/*
 * Decompiled with CFR 0.152.
 */
package spoon.template;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import spoon.SpoonException;
import spoon.pattern.Pattern;
import spoon.pattern.PatternBuilderHelper;
import spoon.pattern.internal.node.ListOfNodes;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.template.Parameters;
import spoon.support.util.ImmutableMapImpl;
import spoon.template.Local;
import spoon.template.Parameter;
import spoon.template.Substitution;
import spoon.template.Template;
import spoon.template.TemplateParameter;

class TemplateBuilder {
    private Template<?> template;
    private PatternBuilder patternBuilder;
    private CtClass<?> templateType;

    public static TemplateBuilder createTemplateBuilder(CtElement templateRoot, Template<?> template) {
        CtClass templateType = Substitution.getTemplateCtClass(templateRoot.getFactory(), template);
        return TemplateBuilder.createTemplateBuilder(templateRoot, templateType, template);
    }

    public static TemplateBuilder createTemplateBuilder(CtElement templateRoot, CtClass<?> templateType, Template<?> template) {
        PatternBuilder pb;
        Factory f = templateRoot.getFactory();
        if (template != null && !templateType.getQualifiedName().equals(template.getClass().getName())) {
            throw new SpoonException("Unexpected template instance " + template.getClass().getName() + ". Expects " + templateType.getQualifiedName());
        }
        CtTypeReference<TemplateParameter> templateParamRef = f.Type().createReference(TemplateParameter.class);
        if (templateType == templateRoot) {
            PatternBuilderHelper tv = new PatternBuilderHelper(templateType);
            tv.keepTypeMembers(typeMember -> {
                if (typeMember.getAnnotation(Parameter.class) != null) {
                    return false;
                }
                if (typeMember.getAnnotation(Local.class) != null) {
                    return false;
                }
                return !(typeMember instanceof CtField) || !((CtField)typeMember).getType().isSubtypeOf(templateParamRef);
            });
            tv.removeSuperClass();
            pb = new PatternBuilder(tv.getPatternElements());
        } else {
            pb = new PatternBuilder(Collections.singletonList(templateRoot));
        }
        Map<String, Object> templateParameters = template == null ? null : Parameters.getTemplateParametersAsMap(f, template);
        pb.setAutoSimplifySubstitutions(template == null ? false : template.withPartialEvaluation());
        pb.configurePatternParameters(pc -> {
            pc.byTemplateParameter(templateParameters);
            pc.byParameterValues(templateParameters);
        });
        return new TemplateBuilder(templateType, pb, template);
    }

    private TemplateBuilder(CtClass<?> templateType, PatternBuilder patternBuilder, Template<?> template) {
        this.template = template;
        this.patternBuilder = patternBuilder;
        this.templateType = templateType;
    }

    public Pattern build() {
        return this.patternBuilder.build();
    }

    Pattern build(Consumer<ListOfNodes> nodes) {
        nodes.accept(this.patternBuilder.getListOfNodes());
        return this.build();
    }

    public TemplateBuilder setAddGeneratedBy(boolean addGeneratedBy) {
        this.patternBuilder.setAddGeneratedBy(addGeneratedBy);
        return this;
    }

    public Map<String, Object> getTemplateParameters() {
        return this.getTemplateParameters(null);
    }

    public Map<String, Object> getTemplateParameters(CtType<?> targetType) {
        Factory f = this.templateType.getFactory();
        Map<String, Object> templateParametersAsMap = Parameters.getTemplateParametersAsMap(f, this.template);
        if (targetType != null) {
            templateParametersAsMap.put("targetType", targetType.getReference());
        }
        return templateParametersAsMap;
    }

    public <T extends CtElement> T substituteSingle(CtType<?> targetType, Class<T> itemType) {
        return (T)((CtElement)this.build().generator().generate(new ImmutableMapImpl(this.getTemplateParameters(targetType))).get(0));
    }

    public <T extends CtElement> List<T> substituteList(Factory factory, CtType<?> targetType, Class<T> itemType) {
        return this.build().generator().generate(this.getTemplateParameters(targetType));
    }

    private static class PatternBuilder
    extends spoon.pattern.PatternBuilder {
        PatternBuilder(List<CtElement> template) {
            super(template);
        }

        ListOfNodes getListOfNodes() {
            return new ListOfNodes(this.patternNodes.getNodes());
        }
    }
}

