/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtSealable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.visitor.java.internal.AbstractRuntimeBuilderContext;

public class TypeRuntimeBuilderContext
extends AbstractRuntimeBuilderContext {
    protected CtType type;
    protected Type rtType;
    private Map<String, CtTypeParameter> mapTypeParameters;

    public TypeRuntimeBuilderContext(Type rtType, CtType type) {
        super(type);
        this.type = type;
        this.rtType = rtType;
        this.mapTypeParameters = new HashMap<String, CtTypeParameter>();
    }

    @Override
    public void addPackage(CtPackage ctPackage) {
        ctPackage.addType(this.type);
    }

    @Override
    public void addType(CtType<?> aType) {
        this.type.addNestedType(aType);
    }

    @Override
    public void addAnnotation(CtAnnotation<Annotation> ctAnnotation) {
        this.type.addAnnotation(ctAnnotation);
    }

    @Override
    public void addMethod(CtMethod<?> ctMethod) {
        this.type.addMethod(ctMethod);
    }

    @Override
    public void addField(CtField<?> ctField) {
        this.type.addField(ctField);
    }

    @Override
    public void addFormalType(CtTypeParameter parameterRef) {
        this.type.addFormalCtTypeParameter(parameterRef);
        this.mapTypeParameters.put(parameterRef.getSimpleName(), parameterRef);
    }

    @Override
    public void addTypeReference(CtRole role, CtTypeReference<?> typeReference) {
        CtType declaringType = typeReference.getFactory().Type().get(typeReference.getQualifiedName());
        boolean finalOrSealed = this.type.isFinal() || this.type.hasModifier(ModifierKind.SEALED);
        switch (role) {
            case INTERFACE: {
                if (declaringType != null && declaringType.isShadow() && !finalOrSealed && declaringType.hasModifier(ModifierKind.SEALED)) {
                    this.type.addModifier(ModifierKind.NON_SEALED);
                }
                this.type.addSuperInterface(typeReference);
                return;
            }
            case SUPER_TYPE: {
                if (declaringType != null && declaringType.isShadow() && !finalOrSealed && declaringType.hasModifier(ModifierKind.SEALED)) {
                    this.type.addModifier(ModifierKind.NON_SEALED);
                }
                if (this.type instanceof CtTypeParameter) {
                    ((CtTypeParameter)this.type).setSuperclass(typeReference);
                } else {
                    this.type.setSuperclass(typeReference);
                }
                return;
            }
            case PERMITTED_TYPE: {
                if (this.type instanceof CtSealable) {
                    this.type.addModifier(ModifierKind.SEALED);
                    ((CtSealable)((Object)this.type)).addPermittedType(typeReference);
                }
                return;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable CtTypeParameter getTypeParameter(GenericDeclaration genericDeclaration, String string) {
        return this.rtType == genericDeclaration ? this.mapTypeParameters.get(string) : null;
    }
}

