/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.support.visitor.java.internal.AbstractRuntimeBuilderContext;

public class TypeReferenceRuntimeBuilderContext
extends AbstractRuntimeBuilderContext {
    private CtTypeReference<?> typeReference;
    private Type type;
    private Map<String, CtTypeParameter> mapTypeParameters;

    public TypeReferenceRuntimeBuilderContext(Type type, CtTypeReference<?> typeReference) {
        super(typeReference);
        this.typeReference = typeReference;
        this.type = type;
        this.mapTypeParameters = new HashMap<String, CtTypeParameter>();
    }

    @Override
    public void addPackage(CtPackage ctPackage) {
        this.typeReference.setPackage(ctPackage.getReference());
    }

    @Override
    public void addTypeReference(CtRole role, CtTypeReference<?> ctTypeReference) {
        switch (role) {
            case DECLARING_TYPE: {
                this.typeReference.setDeclaringType(ctTypeReference);
                return;
            }
            case BOUNDING_TYPE: 
            case SUPER_TYPE: {
                if (this.typeReference instanceof CtWildcardReference) {
                    ((CtWildcardReference)this.typeReference).setBoundingType(ctTypeReference);
                } else {
                    this.getClass();
                }
                return;
            }
            case TYPE_ARGUMENT: {
                this.typeReference.addActualTypeArgument(ctTypeReference);
                return;
            }
        }
        super.addTypeReference(role, ctTypeReference);
    }

    @Override
    public void addAnnotation(CtAnnotation<Annotation> ctAnnotation) {
        this.typeReference.addAnnotation(ctAnnotation);
    }

    @Override
    public void addFormalType(CtTypeParameter parameterRef) {
        this.typeReference.addActualTypeArgument(parameterRef.getReference());
        this.mapTypeParameters.put(parameterRef.getSimpleName(), parameterRef);
    }

    @Override
    public @Nullable CtTypeParameter getTypeParameter(GenericDeclaration genericDeclaration, String string) {
        return this.type == genericDeclaration ? this.mapTypeParameters.get(string) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeReferenceRuntimeBuilderContext that = (TypeReferenceRuntimeBuilderContext)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.typeReference);
    }
}

