/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericDeclaration;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.visitor.java.internal.AbstractRuntimeBuilderContext;

public class ExecutableRuntimeBuilderContext
extends AbstractRuntimeBuilderContext {
    private CtExecutable<?> ctExecutable;
    private Executable executable;
    private Map<String, CtTypeParameter> mapTypeParameters;

    public ExecutableRuntimeBuilderContext(Executable executable, CtMethod<?> ctMethod) {
        super(ctMethod);
        this.ctExecutable = ctMethod;
        this.executable = executable;
        this.mapTypeParameters = new HashMap<String, CtTypeParameter>();
    }

    public ExecutableRuntimeBuilderContext(Executable executable, CtConstructor<?> ctConstructor) {
        super(ctConstructor);
        this.ctExecutable = ctConstructor;
        this.executable = executable;
        this.mapTypeParameters = new HashMap<String, CtTypeParameter>();
    }

    @Override
    public void addAnnotation(CtAnnotation<Annotation> ctAnnotation) {
        this.ctExecutable.addAnnotation(ctAnnotation);
    }

    @Override
    public void addParameter(CtParameter ctParameter) {
        this.ctExecutable.addParameter(ctParameter);
    }

    @Override
    public void addTypeReference(CtRole role, CtTypeReference<?> typeReference) {
        switch (role) {
            case THROWN: {
                this.ctExecutable.addThrownType(typeReference);
                return;
            }
            case TYPE: {
                this.ctExecutable.setType(typeReference);
                return;
            }
        }
        super.addTypeReference(role, typeReference);
    }

    @Override
    public void addFormalType(CtTypeParameter parameterRef) {
        if (this.ctExecutable instanceof CtFormalTypeDeclarer) {
            ((CtFormalTypeDeclarer)((Object)this.ctExecutable)).addFormalCtTypeParameter(parameterRef);
            this.mapTypeParameters.put(parameterRef.getSimpleName(), parameterRef);
            return;
        }
        super.addFormalType(parameterRef);
    }

    @Override
    public @Nullable CtTypeParameter getTypeParameter(GenericDeclaration genericDeclaration, String string) {
        return this.executable == genericDeclaration ? this.mapTypeParameters.get(string) : null;
    }
}

