/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;

class MethodHandleUtils {
    private static Class<?> recordComponent = MethodHandleUtils.lookupRecordComponentClass();
    private static MethodHandle isRecord = MethodHandleUtils.lookupRecord();
    private static MethodHandle lookupRecordComponents = MethodHandleUtils.lookupRecordComponents();
    private static MethodHandle lookupRecordComponentName = MethodHandleUtils.lookupRecordComponentName();
    private static MethodHandle lookupRecordComponentType = MethodHandleUtils.lookupRecordComponentType();
    private static MethodHandle lookupPermittedSubclasses = MethodHandleUtils.lookupPermittedSubclasses();

    private MethodHandleUtils() {
    }

    public static boolean isRecord(Class<?> clazz) {
        try {
            return isRecord.invokeExact(clazz);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static @Nullable Class<?> lookupRecordComponentClass() {
        try {
            return Class.forName("java.lang.reflect.RecordComponent");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static List<AnnotatedElement> getRecordComponents(Class<?> clazz) {
        if (recordComponent == null) {
            return Collections.emptyList();
        }
        AnnotatedElement[] components = null;
        try {
            components = lookupRecordComponents.invoke(clazz);
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
        return Arrays.asList(components);
    }

    public static @Nullable String getRecordComponentName(AnnotatedElement component) {
        try {
            return lookupRecordComponentName.invoke(component);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static @Nullable Type getRecordComponentType(AnnotatedElement component) {
        try {
            return lookupRecordComponentType.invoke(component);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static @Nullable Class<?>[] getPermittedSubclasses(Class<?> clazz) {
        try {
            return lookupPermittedSubclasses.invoke(clazz);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static @Nullable MethodHandle lookupRecord() {
        try {
            return MethodHandles.lookup().findVirtual(Class.class, "isRecord", MethodType.methodType(Boolean.TYPE));
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static @Nullable MethodHandle lookupRecordComponents() {
        try {
            MethodType arrayOfRecordComponentType = MethodType.methodType(Array.newInstance(recordComponent, 0).getClass());
            return MethodHandles.lookup().findVirtual(Class.class, "getRecordComponents", arrayOfRecordComponentType);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static @Nullable MethodHandle lookupRecordComponentType() {
        try {
            return MethodHandles.lookup().findVirtual(recordComponent, "getGenericType", MethodType.methodType(Type.class));
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static @Nullable MethodHandle lookupRecordComponentName() {
        try {
            return MethodHandles.lookup().findVirtual(recordComponent, "getName", MethodType.methodType(String.class));
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static @Nullable MethodHandle lookupPermittedSubclasses() {
        try {
            return MethodHandles.lookup().findVirtual(Class.class, "getPermittedSubclasses", MethodType.methodType(Class[].class));
        }
        catch (Throwable e) {
            return null;
        }
    }
}

