/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import spoon.SpoonException;
import spoon.reflect.path.CtRole;
import spoon.support.visitor.java.JavaReflectionVisitor;
import spoon.support.visitor.java.MethodHandleUtils;
import spoon.support.visitor.java.reflect.RtMethod;
import spoon.support.visitor.java.reflect.RtParameter;

class JavaReflectionVisitorImpl
implements JavaReflectionVisitor {
    private static Class<?> recordClass = JavaReflectionVisitorImpl.getRecordClass();

    JavaReflectionVisitorImpl() {
    }

    @Override
    public void visitPackage(Package aPackage) {
        for (Annotation annotation : aPackage.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
    }

    @Override
    public <T> void visitClass(Class<T> clazz) {
        if (JavaReflectionVisitorImpl.isTopLevelType(clazz)) {
            this.visitPackage(clazz.getPackage());
        }
        try {
            for (Type type : clazz.getTypeParameters()) {
                this.visitTypeParameter((TypeVariable<T>)type);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            if (clazz.getGenericSuperclass() != null && clazz.getGenericSuperclass() != Object.class) {
                this.visitTypeReference(CtRole.SUPER_TYPE, clazz.getGenericSuperclass());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Type type : clazz.getGenericInterfaces()) {
                this.visitTypeReference(CtRole.INTERFACE, type);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                this.visitAnnotation(annotation);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (constructor.isSynthetic()) continue;
                this.visitConstructor(constructor);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (RtMethod method : this.getDeclaredMethods(clazz)) {
                if (method.getMethod().isSynthetic()) continue;
                this.visitMethod(method);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                this.visitField(field);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
                this.visitType(clazz2);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.scanPermittedTypes(clazz);
    }

    protected final <T> void visitType(Class<T> aClass) {
        if (aClass.isAnnotation()) {
            this.visitAnnotationClass(aClass);
        } else if (aClass.isInterface()) {
            this.visitInterface(aClass);
        } else if (aClass.isEnum()) {
            this.visitEnum(aClass);
        } else {
            this.visitClass(aClass);
        }
    }

    @Override
    public <T> void visitInterface(Class<T> clazz) {
        assert (clazz.isInterface());
        if (JavaReflectionVisitorImpl.isTopLevelType(clazz)) {
            this.visitPackage(clazz.getPackage());
        }
        try {
            for (Type anInterface : clazz.getGenericInterfaces()) {
                this.visitTypeReference(CtRole.INTERFACE, anInterface);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                this.visitAnnotation(annotation);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (RtMethod method : this.getDeclaredMethods(clazz)) {
                if (method.getMethod().isSynthetic()) continue;
                this.visitMethod(method);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                this.visitField(field);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Class<?> aClass : clazz.getDeclaredClasses()) {
                this.visitType(aClass);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (TypeVariable<Class<T>> generic : clazz.getTypeParameters()) {
                this.visitTypeParameter(generic);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.scanPermittedTypes(clazz);
    }

    @Override
    public <T> void visitEnum(Class<T> clazz) {
        assert (clazz.isEnum());
        if (JavaReflectionVisitorImpl.isTopLevelType(clazz)) {
            this.visitPackage(clazz.getPackage());
        }
        try {
            for (Type anInterface : clazz.getGenericInterfaces()) {
                this.visitTypeReference(CtRole.INTERFACE, anInterface);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                this.visitAnnotation(annotation);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                Class<?>[] paramTypes;
                if (Modifier.isPrivate(constructor.getModifiers()) && (paramTypes = constructor.getParameterTypes()).length == 2 && paramTypes[0] == String.class && paramTypes[1] == Integer.TYPE || constructor.isSynthetic()) continue;
                this.visitConstructor(constructor);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (RtMethod method : this.getDeclaredMethods(clazz)) {
                if ("valueOf".equals(method.getName()) && method.getParameterTypes().length == 1 && String.class.equals(method.getParameterTypes()[0]) || "values".equals(method.getName()) || method.getMethod().isSynthetic()) continue;
                this.visitMethod(method);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                if (field.isEnumConstant()) {
                    this.visitEnumValue(field);
                    continue;
                }
                this.visitField(field);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Class<?> aClass : clazz.getDeclaredClasses()) {
                this.visitType(aClass);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.scanPermittedTypes(clazz);
    }

    @Override
    public <T extends Annotation> void visitAnnotationClass(Class<T> clazz) {
        assert (clazz.isAnnotation());
        if (JavaReflectionVisitorImpl.isTopLevelType(clazz)) {
            this.visitPackage(clazz.getPackage());
        }
        try {
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                this.visitAnnotation(annotation);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (RtMethod method : this.getDeclaredMethods(clazz)) {
                if (method.getMethod().isSynthetic()) continue;
                this.visitMethod(method);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                this.visitField(field);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
                this.visitType(clazz2);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public void visitAnnotation(Annotation annotation) {
        if (annotation.annotationType() != null) {
            this.visitTypeReference(CtRole.ANNOTATION_TYPE, annotation.annotationType());
            List<RtMethod> methods = this.getDeclaredMethods(annotation.annotationType());
            for (RtMethod method : methods) {
                this.visitMethod(method, annotation);
            }
        }
    }

    @Override
    public <T> void visitConstructor(Constructor<T> constructor) {
        for (Annotation annotation : constructor.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        RtParameter[] parametersOf = RtParameter.parametersOf(constructor);
        Parameter[] parameters = constructor.getParameters();
        for (int i = 0; i < parametersOf.length; ++i) {
            RtParameter rtParameter = parametersOf[i];
            if (this.isImplicitParameter(parameters[i], constructor, i == 0)) continue;
            this.visitParameter(rtParameter);
        }
        for (TypeVariable<Constructor<T>> typeVariable : constructor.getTypeParameters()) {
            this.visitTypeParameter(typeVariable);
        }
        for (Type type : constructor.getExceptionTypes()) {
            this.visitTypeReference(CtRole.THROWN, (Class<T>)type);
        }
    }

    private boolean isImplicitParameter(Parameter parameter, Constructor<?> constructor, boolean isFirstParameter) {
        if (parameter.isImplicit()) {
            return true;
        }
        if (Modifier.isStatic(constructor.getDeclaringClass().getModifiers())) {
            return false;
        }
        return isFirstParameter && parameter.getType() == constructor.getDeclaringClass().getEnclosingClass();
    }

    @Override
    public final void visitMethod(RtMethod method) {
        this.visitMethod(method, null);
    }

    protected void visitMethod(RtMethod method, Annotation parent) {
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            if (parent != null && annotation.annotationType().equals(parent.annotationType())) continue;
            this.visitAnnotation(annotation);
        }
        for (TypeVariable<Method> aTypeParameter : method.getTypeParameters()) {
            this.visitTypeParameter(aTypeParameter);
        }
        for (RtParameter parameter : RtParameter.parametersOf(method)) {
            this.visitParameter(parameter);
        }
        if (method.getReturnType() != null) {
            this.visitTypeReference(CtRole.TYPE, method.getGenericReturnType());
        }
        for (Class<?> exceptionType : method.getExceptionTypes()) {
            this.visitTypeReference(CtRole.THROWN, exceptionType);
        }
    }

    @Override
    public void visitField(Field field) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        if (field.getGenericType() != null) {
            this.visitTypeReference(CtRole.TYPE, field.getGenericType());
        }
    }

    @Override
    public void visitEnumValue(Field field) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        if (field.getType() != null) {
            this.visitTypeReference(CtRole.TYPE, field.getType());
        }
    }

    @Override
    public void visitParameter(RtParameter parameter) {
        for (Annotation annotation : parameter.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        if (parameter.getGenericType() != null) {
            this.visitTypeReference(CtRole.TYPE, parameter.getGenericType());
        }
    }

    @Override
    public <T extends GenericDeclaration> void visitTypeParameter(TypeVariable<T> parameter) {
        for (Type type : parameter.getBounds()) {
            if (type == Object.class) continue;
            this.visitTypeReference(CtRole.SUPER_TYPE, type);
        }
    }

    @Override
    public <T extends GenericDeclaration> void visitTypeParameterReference(CtRole role, TypeVariable<T> parameter) {
        for (Type type : parameter.getBounds()) {
            if (type == Object.class) continue;
            this.visitTypeReference(CtRole.SUPER_TYPE, type);
        }
    }

    @Override
    public final void visitTypeReference(CtRole role, Type type) {
        if (type instanceof TypeVariable) {
            this.visitTypeParameterReference(role, (TypeVariable)type);
            return;
        }
        if (type instanceof ParameterizedType) {
            this.visitTypeReference(role, (ParameterizedType)type);
            return;
        }
        if (type instanceof WildcardType) {
            this.visitTypeReference(role, (WildcardType)type);
            return;
        }
        if (type instanceof GenericArrayType) {
            this.visitArrayReference(role, ((GenericArrayType)type).getGenericComponentType());
            return;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                this.visitArrayReference(role, clazz.getComponentType());
                return;
            }
            this.visitTypeReference(role, clazz);
            return;
        }
        throw new SpoonException("Unexpected java reflection type: " + type.getClass().getName());
    }

    @Override
    public void visitTypeReference(CtRole role, ParameterizedType type) {
        Type rawType = type.getRawType();
        if (!(rawType instanceof Class)) {
            throw new UnsupportedOperationException("Rawtype of the parameterized type should be a class.");
        }
        Class classRaw = (Class)rawType;
        if (classRaw.getPackage() != null) {
            this.visitPackage(classRaw.getPackage());
        }
        if (classRaw.getEnclosingClass() != null) {
            this.visitTypeReference(CtRole.DECLARING_TYPE, classRaw.getEnclosingClass());
        }
        for (Type generic : type.getActualTypeArguments()) {
            this.visitTypeReference(CtRole.TYPE_ARGUMENT, generic);
        }
    }

    @Override
    public void visitTypeReference(CtRole role, WildcardType type) {
        if (!type.getUpperBounds()[0].equals(Object.class)) {
            for (Type upper : type.getUpperBounds()) {
                this.visitTypeReference(CtRole.BOUNDING_TYPE, upper);
            }
        }
        for (Type lower : type.getLowerBounds()) {
            this.visitTypeReference(CtRole.BOUNDING_TYPE, lower);
        }
    }

    @Override
    public <T> void visitArrayReference(CtRole role, Type typeArray) {
        this.visitTypeReference(role, typeArray);
    }

    @Override
    public <T> void visitTypeReference(CtRole role, Class<T> clazz) {
        if (JavaReflectionVisitorImpl.isTopLevelType(clazz)) {
            this.visitPackage(clazz.getPackage());
        }
        if (clazz.getEnclosingClass() != null) {
            this.visitTypeReference(CtRole.DECLARING_TYPE, clazz.getEnclosingClass());
        }
    }

    private <T> List<RtMethod> getDeclaredMethods(Class<T> clazz) {
        Method[] javaMethods = clazz.getDeclaredMethods();
        ArrayList<RtMethod> rtMethods = new ArrayList<RtMethod>();
        for (Method method : javaMethods) {
            if (method.isSynthetic()) continue;
            rtMethods.add(RtMethod.create(method));
        }
        return rtMethods;
    }

    @Override
    public <T> void visitRecord(Class<T> clazz) {
        if (recordClass == null) {
            return;
        }
        try {
            for (Type type : clazz.getTypeParameters()) {
                this.visitTypeParameter((TypeVariable<T>)type);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            if (clazz.getGenericSuperclass() != null && clazz.getGenericSuperclass() != Object.class) {
                this.visitTypeReference(CtRole.SUPER_TYPE, clazz.getGenericSuperclass());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Type type : clazz.getGenericInterfaces()) {
                this.visitTypeReference(CtRole.INTERFACE, type);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                this.visitAnnotation(annotation);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (constructor.isSynthetic()) continue;
                this.visitConstructor(constructor);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (RtMethod method : this.getDeclaredMethods(clazz)) {
                if (method.getMethod().isSynthetic()) continue;
                this.visitMethod(method);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                this.visitField(field);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
                this.visitType(clazz2);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        for (AnnotatedElement element : MethodHandleUtils.getRecordComponents(clazz)) {
            this.visitRecordComponent(element);
        }
    }

    private static boolean isTopLevelType(Class<?> clazz) {
        return clazz.getEnclosingClass() == null && clazz.getPackage() != null;
    }

    private static @Nullable Class<?> getRecordClass() {
        try {
            return Class.forName("java.lang.Record");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void visitRecordComponent(AnnotatedElement recordComponent) {
    }

    private void scanPermittedTypes(Class<?> clazz) {
        Class<?>[] permittedSubclasses = MethodHandleUtils.getPermittedSubclasses(clazz);
        if (permittedSubclasses == null) {
            return;
        }
        for (Class<?> subclass : permittedSubclasses) {
            try {
                this.visitTypeReference(CtRole.PERMITTED_TYPE, subclass);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }
}

