/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import spoon.Launcher;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtRecord;
import spoon.reflect.declaration.CtRecordComponent;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.support.util.RtHelper;
import spoon.support.visitor.java.JavaReflectionVisitorImpl;
import spoon.support.visitor.java.MethodHandleUtils;
import spoon.support.visitor.java.internal.AnnotationRuntimeBuilderContext;
import spoon.support.visitor.java.internal.ExecutableRuntimeBuilderContext;
import spoon.support.visitor.java.internal.PackageRuntimeBuilderContext;
import spoon.support.visitor.java.internal.RecordComponentRuntimeBuilderContext;
import spoon.support.visitor.java.internal.RuntimeBuilderContext;
import spoon.support.visitor.java.internal.TypeReferenceRuntimeBuilderContext;
import spoon.support.visitor.java.internal.TypeRuntimeBuilderContext;
import spoon.support.visitor.java.internal.VariableRuntimeBuilderContext;
import spoon.support.visitor.java.reflect.RtMethod;
import spoon.support.visitor.java.reflect.RtParameter;

public class JavaReflectionTreeBuilder
extends JavaReflectionVisitorImpl {
    private final Deque<RuntimeBuilderContext> contexts;
    protected final Factory factory;

    public JavaReflectionTreeBuilder(Factory factory) {
        this.factory = factory;
        this.contexts = new ArrayDeque<RuntimeBuilderContext>();
    }

    private void enter(RuntimeBuilderContext context) {
        this.contexts.push(context);
    }

    private RuntimeBuilderContext exit() {
        return this.contexts.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R extends CtType<T>> R scan(Class<T> clazz) {
        Factory factory = this.factory;
        synchronized (factory) {
            if (clazz.getEnclosingClass() != null && !clazz.isAnonymousClass()) {
                CtType ctEnclosingClass = this.factory.Type().get(clazz.getEnclosingClass());
                return (R)ctEnclosingClass.getNestedType(clazz.getSimpleName());
            }
            CtPackage ctPackage = this.getCtPackage(clazz);
            if (this.contexts.isEmpty()) {
                this.enter(new PackageRuntimeBuilderContext(ctPackage));
            }
            boolean visited = false;
            if (clazz.isAnnotation()) {
                visited = true;
                this.visitAnnotationClass(clazz);
            }
            if (clazz.isInterface() && !visited) {
                visited = true;
                this.visitInterface(clazz);
            }
            if (clazz.isEnum() && !visited) {
                visited = true;
                this.visitEnum(clazz);
            }
            if (MethodHandleUtils.isRecord(clazz) && !visited) {
                visited = true;
                this.visitRecord(clazz);
            }
            if (!visited) {
                this.visitClass(clazz);
            }
            this.exit();
            Object type = ctPackage.getType(clazz.getSimpleName());
            if (clazz.isPrimitive() && type.getParent() instanceof CtPackage) {
                type.setParent(null);
            }
            return (R)type;
        }
    }

    private <T> CtPackage getCtPackage(Class<T> clazz) {
        Package javaPackage = clazz.getPackage();
        if (javaPackage == null && clazz.isArray()) {
            javaPackage = JavaReflectionTreeBuilder.getArrayType(clazz).getPackage();
        }
        if (javaPackage == null) {
            return this.factory.Package().getRootPackage();
        }
        return this.factory.Package().getOrCreate(javaPackage.getName());
    }

    private static Class<?> getArrayType(Class<?> array) {
        if (array.isArray()) {
            return JavaReflectionTreeBuilder.getArrayType(array.getComponentType());
        }
        return array;
    }

    @Override
    public void visitPackage(Package aPackage) {
        CtPackage ctPackage = this.factory.Package().get(aPackage.getName());
        if (ctPackage == null || this.shouldVisitPackage(ctPackage)) {
            ctPackage = this.factory.Package().getOrCreate(aPackage.getName());
            this.enter(new PackageRuntimeBuilderContext(ctPackage));
            super.visitPackage(aPackage);
            this.exit();
        }
        this.contexts.peek().addPackage(ctPackage);
    }

    private boolean shouldVisitPackage(CtPackage ctPackage) {
        Iterator<RuntimeBuilderContext> iterator = this.contexts.iterator();
        while (iterator.hasNext()) {
            RuntimeBuilderContext next = iterator.next();
            if (!iterator.hasNext() || !(next instanceof PackageRuntimeBuilderContext) || ((PackageRuntimeBuilderContext)next).getPackage() != ctPackage) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> void visitClass(Class<T> clazz) {
        final CtClass ctClass = this.factory.Core().createClass();
        ctClass.setSimpleName(clazz.getSimpleName());
        this.setModifier(ctClass, clazz.getModifiers() & Modifier.classModifiers());
        this.enter(new TypeRuntimeBuilderContext(clazz, ctClass){

            @Override
            public void addConstructor(CtConstructor<?> ctConstructor) {
                ctClass.addConstructor(ctConstructor);
            }

            @Override
            public void addTypeReference(CtRole role, CtTypeReference<?> typeReference) {
                switch (role) {
                    case SUPER_TYPE: {
                        ctClass.setSuperclass(typeReference);
                        return;
                    }
                }
                super.addTypeReference(role, typeReference);
            }
        });
        super.visitClass(clazz);
        this.exit();
        this.contexts.peek().addType(ctClass);
    }

    @Override
    public <T> void visitInterface(Class<T> clazz) {
        CtInterface ctInterface = this.factory.Core().createInterface();
        ctInterface.setSimpleName(clazz.getSimpleName());
        this.setModifier(ctInterface, clazz.getModifiers() & Modifier.classModifiers());
        this.enter(new TypeRuntimeBuilderContext(clazz, ctInterface));
        super.visitInterface(clazz);
        this.exit();
        this.contexts.peek().addType(ctInterface);
    }

    @Override
    public <T> void visitEnum(Class<T> clazz) {
        final CtEnum ctEnum = this.factory.Core().createEnum();
        ctEnum.setSimpleName(clazz.getSimpleName());
        this.setModifier(ctEnum, clazz.getModifiers() & Modifier.classModifiers());
        this.enter(new TypeRuntimeBuilderContext(clazz, ctEnum){

            @Override
            public void addConstructor(CtConstructor<?> ctConstructor) {
                ctEnum.addConstructor(ctConstructor);
            }

            @Override
            public void addEnumValue(CtEnumValue<?> ctEnumValue) {
                ctEnum.addEnumValue(ctEnumValue);
            }
        });
        super.visitEnum(clazz);
        this.exit();
        this.contexts.peek().addType(ctEnum);
    }

    @Override
    public <T extends Annotation> void visitAnnotationClass(Class<T> clazz) {
        final CtAnnotationType ctAnnotationType = this.factory.Core().createAnnotationType();
        ctAnnotationType.setSimpleName(clazz.getSimpleName());
        this.setModifier(ctAnnotationType, clazz.getModifiers() & Modifier.classModifiers());
        this.enter(new TypeRuntimeBuilderContext(clazz, ctAnnotationType){

            public void addMethod(CtMethod ctMethod) {
                CtAnnotationMethod field = JavaReflectionTreeBuilder.this.factory.Core().createAnnotationMethod();
                field.setSimpleName(ctMethod.getSimpleName());
                field.setModifiers(ctMethod.getModifiers());
                field.setType(ctMethod.getType());
                field.setShadow(true);
                ctAnnotationType.addMethod(field);
            }
        });
        super.visitAnnotationClass(clazz);
        this.exit();
        this.contexts.peek().addType(ctAnnotationType);
    }

    @Override
    public void visitAnnotation(final Annotation annotation) {
        final CtAnnotation<Annotation> ctAnnotation = this.factory.Core().createAnnotation();
        this.enter(new AnnotationRuntimeBuilderContext(ctAnnotation){

            @Override
            public void addMethod(CtMethod ctMethod) {
                try {
                    Object[] values;
                    Object value = annotation.annotationType().getMethod(ctMethod.getSimpleName(), new Class[0]).invoke((Object)annotation, new Object[0]);
                    if (value instanceof Object[] && (values = (Object[])value).length == 1) {
                        value = values[0];
                    }
                    ctAnnotation.addValue(ctMethod.getSimpleName(), value);
                }
                catch (Exception ignore) {
                    ctAnnotation.addValue(ctMethod.getSimpleName(), "");
                }
            }
        });
        super.visitAnnotation(annotation);
        this.exit();
        this.contexts.peek().addAnnotation(ctAnnotation);
    }

    @Override
    public <T> void visitConstructor(Constructor<T> constructor) {
        CtConstructor ctConstructor = this.factory.Core().createConstructor();
        ctConstructor.setBody(this.factory.Core().createBlock());
        this.setModifier(ctConstructor, constructor.getModifiers() & Modifier.constructorModifiers());
        this.enter(new ExecutableRuntimeBuilderContext(constructor, ctConstructor));
        super.visitConstructor(constructor);
        this.exit();
        this.contexts.peek().addConstructor(ctConstructor);
    }

    @Override
    public void visitMethod(RtMethod method, Annotation parent) {
        CtMethod ctMethod = this.factory.Core().createMethod();
        ctMethod.setSimpleName(method.getName());
        if (!Modifier.isAbstract(method.getModifiers())) {
            ctMethod.setBody(this.factory.Core().createBlock());
        }
        this.setModifier(ctMethod, method.getModifiers() & Modifier.methodModifiers());
        ctMethod.setDefaultMethod(method.isDefault());
        this.enter(new ExecutableRuntimeBuilderContext((Executable)method.getMethod(), ctMethod));
        super.visitMethod(method, parent);
        this.exit();
        this.contexts.peek().addMethod(ctMethod);
    }

    @Override
    public void visitField(Field field) {
        CtField<Object> ctField = this.factory.Core().createField();
        ctField.setSimpleName(field.getName());
        this.setModifier(ctField, field.getModifiers() & Modifier.fieldModifiers());
        Set<ModifierKind> modifiers = RtHelper.getModifiers(field.getModifiers());
        if (modifiers.contains((Object)ModifierKind.STATIC) && modifiers.contains((Object)ModifierKind.PUBLIC) && (field.getType().isPrimitive() || String.class.isAssignableFrom(field.getType()))) {
            Pair<Boolean, Object> constantValue = this.getConstantValue(field);
            if (((Boolean)constantValue.getLeft()).booleanValue()) {
                CtExpression<Object> defaultExpression = this.buildExpressionForValue(constantValue.getRight());
                ctField.setDefaultExpression(defaultExpression);
            } else {
                ctField.setDefaultExpression(null);
            }
        }
        this.enter(new VariableRuntimeBuilderContext(ctField));
        super.visitField(field);
        this.exit();
        this.contexts.peek().addField(ctField);
    }

    private CtExpression<Object> buildExpressionForValue(Object value) {
        if (value instanceof Double) {
            double d = (Double)value;
            if (Double.isNaN(d)) {
                return this.buildDivision(0.0, 0.0);
            }
            if (Double.POSITIVE_INFINITY == d) {
                return this.buildDivision(1.0, 0.0);
            }
            if (Double.NEGATIVE_INFINITY == d) {
                return this.buildDivision(-1.0, 0.0);
            }
        } else if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            if (Float.isNaN(f)) {
                return this.buildDivision(Float.valueOf(0.0f), Float.valueOf(0.0f));
            }
            if (Float.POSITIVE_INFINITY == f) {
                return this.buildDivision(Float.valueOf(1.0f), Float.valueOf(0.0f));
            }
            if (Float.NEGATIVE_INFINITY == f) {
                return this.buildDivision(Float.valueOf(-1.0f), Float.valueOf(0.0f));
            }
        }
        return this.factory.createLiteral(value);
    }

    private CtBinaryOperator<Object> buildDivision(Object first, Object second) {
        return this.factory.createBinaryOperator(this.factory.createLiteral(first), this.factory.createLiteral(second), BinaryOperatorKind.DIV);
    }

    protected Pair<Boolean, Object> getConstantValue(Field field) {
        try {
            return Pair.of((Object)true, (Object)field.get(null));
        }
        catch (NoClassDefFoundError e) {
            throw e;
        }
        catch (SecurityException e) {
            if (!e.getClass().getName().equals("com.pvsstudio.security.PvsStudioSecurityException")) {
                throw e;
            }
        }
        catch (Throwable e) {
            Launcher.LOGGER.warn("An exception occurred while initializing primitive public fields of a shadow class: ", e);
        }
        return Pair.of((Object)false, null);
    }

    @Override
    public void visitEnumValue(Field field) {
        CtEnumValue ctEnumValue = this.factory.Core().createEnumValue();
        ctEnumValue.setSimpleName(field.getName());
        this.setModifier(ctEnumValue, field.getModifiers() & Modifier.fieldModifiers());
        this.enter(new VariableRuntimeBuilderContext(ctEnumValue));
        super.visitEnumValue(field);
        this.exit();
        this.contexts.peek().addEnumValue(ctEnumValue);
    }

    @Override
    public void visitParameter(RtParameter parameter) {
        CtParameter ctParameter = this.factory.Core().createParameter();
        ctParameter.setSimpleName(parameter.getName());
        ctParameter.setVarArgs(parameter.isVarArgs());
        this.enter(new VariableRuntimeBuilderContext(ctParameter));
        super.visitParameter(parameter);
        this.exit();
        this.contexts.peek().addParameter(ctParameter);
    }

    @Override
    public <T extends GenericDeclaration> void visitTypeParameter(TypeVariable<T> parameter) {
        T genericDeclaration = parameter.getGenericDeclaration();
        for (RuntimeBuilderContext context : this.contexts) {
            CtTypeParameter typeParameter = context.getTypeParameter((GenericDeclaration)genericDeclaration, parameter.getName());
            if (typeParameter == null) continue;
            this.contexts.peek().addFormalType(typeParameter.clone());
            return;
        }
        final CtTypeParameter typeParameter = this.factory.Core().createTypeParameter();
        typeParameter.setSimpleName(parameter.getName());
        this.enter(new TypeRuntimeBuilderContext(parameter, typeParameter){

            @Override
            public void addTypeReference(CtRole role, CtTypeReference<?> typeReference) {
                switch (role) {
                    case SUPER_TYPE: {
                        if (typeParameter.getSuperclass() != null) {
                            typeParameter.setSuperclass(typeParameter.getFactory().createIntersectionTypeReferenceWithBounds(Arrays.asList(typeParameter.getSuperclass(), typeReference)));
                        } else {
                            typeParameter.setSuperclass(typeReference);
                        }
                        return;
                    }
                }
                super.addTypeReference(role, typeReference);
            }
        });
        super.visitTypeParameter(parameter);
        this.exit();
        this.contexts.peek().addFormalType(typeParameter);
    }

    @Override
    public <T extends GenericDeclaration> void visitTypeParameterReference(CtRole role, TypeVariable<T> parameter) {
        CtTypeParameterReference typeParameterReference = this.factory.Core().createTypeParameterReference();
        typeParameterReference.setSimpleName(parameter.getName());
        TypeReferenceRuntimeBuilderContext runtimeBuilderContext = new TypeReferenceRuntimeBuilderContext(parameter, typeParameterReference);
        T genericDeclaration = parameter.getGenericDeclaration();
        for (RuntimeBuilderContext context : this.contexts) {
            CtTypeParameter typeParameter = context.getTypeParameter((GenericDeclaration)genericDeclaration, parameter.getName());
            if (typeParameter == null) continue;
            this.contexts.peek().addTypeReference(role, typeParameter.getReference());
            return;
        }
        this.enter(runtimeBuilderContext);
        super.visitTypeParameterReference(role, parameter);
        this.exit();
        this.contexts.peek().addTypeReference(role, typeParameterReference);
    }

    @Override
    public void visitTypeReference(CtRole role, ParameterizedType type) {
        Type[] typeArguments = type.getActualTypeArguments();
        if (role == CtRole.SUPER_TYPE && typeArguments.length > 0 && this.hasProcessedRecursiveBound(typeArguments)) {
            return;
        }
        CtTypeReference ctTypeReference = this.factory.Core().createTypeReference();
        ctTypeReference.setSimpleName(((Class)type.getRawType()).getSimpleName());
        TypeReferenceRuntimeBuilderContext context = new TypeReferenceRuntimeBuilderContext(type, ctTypeReference){

            @Override
            public void addType(CtType<?> aType) {
                this.getClass();
            }
        };
        this.enter(context);
        super.visitTypeReference(role, type);
        this.exit();
        this.contexts.peek().addTypeReference(role, ctTypeReference);
    }

    @Override
    public void visitTypeReference(CtRole role, WildcardType type) {
        CtWildcardReference wildcard = this.factory.Core().createWildcardReference();
        wildcard.setUpper(type.getLowerBounds().length <= 0);
        if (!type.getUpperBounds()[0].equals(Object.class) && this.hasProcessedRecursiveBound(type.getUpperBounds())) {
            return;
        }
        if (this.hasProcessedRecursiveBound(type.getLowerBounds())) {
            return;
        }
        this.enter(new TypeReferenceRuntimeBuilderContext(type, wildcard));
        super.visitTypeReference(role, type);
        this.exit();
        this.contexts.peek().addTypeReference(role, wildcard);
    }

    private boolean hasProcessedRecursiveBound(Type[] types) {
        for (Type type : types) {
            if (!(type instanceof TypeVariable)) continue;
            TypeVariable t = (TypeVariable)type;
            CtTypeParameterReference typeParameterReference = this.factory.Core().createTypeParameterReference();
            typeParameterReference.setSimpleName(t.getName());
            TypeReferenceRuntimeBuilderContext runtimeBuilderContext = new TypeReferenceRuntimeBuilderContext(t, typeParameterReference);
            if (!this.contexts.contains(runtimeBuilderContext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> void visitArrayReference(CtRole role, Type typeArray) {
        final CtArrayTypeReference arrayTypeReference = this.factory.Core().createArrayTypeReference();
        this.enter(new TypeReferenceRuntimeBuilderContext(typeArray, arrayTypeReference){

            @Override
            public void addTypeReference(CtRole role, CtTypeReference<?> typeReference) {
                switch (role) {
                    case DECLARING_TYPE: {
                        arrayTypeReference.setDeclaringType(typeReference);
                        return;
                    }
                }
                arrayTypeReference.setComponentType(typeReference);
            }
        });
        super.visitArrayReference(role, typeArray);
        this.exit();
        this.contexts.peek().addTypeReference(role, arrayTypeReference);
    }

    @Override
    public <T> void visitTypeReference(CtRole role, Class<T> clazz) {
        CtTypeReference typeReference = this.factory.Core().createTypeReference();
        typeReference.setSimpleName(clazz.getSimpleName());
        this.enter(new TypeReferenceRuntimeBuilderContext(clazz, typeReference));
        super.visitTypeReference(role, clazz);
        this.exit();
        this.contexts.peek().addTypeReference(role, typeReference);
    }

    private void setModifier(CtModifiable ctModifiable, int modifiers) {
        if (Modifier.isAbstract(modifiers)) {
            ctModifiable.addModifier(ModifierKind.ABSTRACT);
        }
        if (Modifier.isFinal(modifiers)) {
            ctModifiable.addModifier(ModifierKind.FINAL);
        }
        if (Modifier.isNative(modifiers)) {
            ctModifiable.addModifier(ModifierKind.NATIVE);
        }
        if (Modifier.isPrivate(modifiers)) {
            ctModifiable.addModifier(ModifierKind.PRIVATE);
        }
        if (Modifier.isProtected(modifiers)) {
            ctModifiable.addModifier(ModifierKind.PROTECTED);
        }
        if (Modifier.isPublic(modifiers)) {
            ctModifiable.addModifier(ModifierKind.PUBLIC);
        }
        if (Modifier.isStatic(modifiers)) {
            ctModifiable.addModifier(ModifierKind.STATIC);
        }
        if (Modifier.isStrict(modifiers)) {
            ctModifiable.addModifier(ModifierKind.STRICTFP);
        }
        if (Modifier.isSynchronized(modifiers)) {
            ctModifiable.addModifier(ModifierKind.SYNCHRONIZED);
        }
        if (Modifier.isTransient(modifiers)) {
            ctModifiable.addModifier(ModifierKind.TRANSIENT);
        }
        if (Modifier.isVolatile(modifiers)) {
            ctModifiable.addModifier(ModifierKind.VOLATILE);
        }
    }

    @Override
    public <T> void visitRecord(Class<T> clazz) {
        final CtRecord ctRecord = this.factory.Core().createRecord();
        ctRecord.setSimpleName(clazz.getSimpleName());
        this.setModifier(ctRecord, clazz.getModifiers() & Modifier.classModifiers());
        this.enter(new TypeRuntimeBuilderContext(clazz, ctRecord){

            @Override
            public void addConstructor(CtConstructor<?> ctConstructor) {
                ctRecord.addConstructor(ctConstructor);
            }

            @Override
            public void addRecordComponent(CtRecordComponent ctRecordComponent) {
                ctRecord.addRecordComponent(ctRecordComponent);
            }
        });
        super.visitRecord(clazz);
        this.exit();
        this.contexts.peek().addType(ctRecord);
    }

    @Override
    public void visitRecordComponent(AnnotatedElement recordComponent) {
        CtRecordComponent ctRecordComponent = this.factory.Core().createRecordComponent();
        ctRecordComponent.setSimpleName(MethodHandleUtils.getRecordComponentName(recordComponent));
        this.enter(new RecordComponentRuntimeBuilderContext(ctRecordComponent));
        this.visitTypeReference(CtRole.TYPE, MethodHandleUtils.getRecordComponentType(recordComponent));
        Arrays.stream(recordComponent.getAnnotations()).forEach(this::visitAnnotation);
        this.exit();
        this.contexts.peek().addRecordComponent(ctRecordComponent);
    }
}

