/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.factory.Factory;
import spoon.support.visitor.java.JavaReflectionTreeBuilder;

public class AsmTreeBuilder
extends JavaReflectionTreeBuilder {
    private static final Logger log = LoggerFactory.getLogger(AsmTreeBuilder.class);

    public AsmTreeBuilder(Factory factory) {
        super(factory);
    }

    @Override
    public Pair<Boolean, Object> getConstantValue(Field field) {
        Pair pair;
        block9: {
            Class<?> fieldType = field.getType();
            String declaringClassName = field.getDeclaringClass().getTypeName().replaceAll("\\.", "/") + ".class";
            String fieldName = field.getName();
            String fieldDescriptor = Type.getDescriptor(fieldType);
            ClassLoader inputClassLoader = this.factory.getEnvironment().getInputClassLoader();
            InputStream classFile = inputClassLoader.getResourceAsStream(declaringClassName);
            try {
                if (classFile == null) {
                    throw new IOException();
                }
                ClassReader classReader = new ClassReader(classFile);
                ConstantValueVisitor visitor = new ConstantValueVisitor(fieldName, fieldDescriptor);
                classReader.accept((ClassVisitor)visitor, 7);
                Object constantValue = visitor.getConstantValue();
                pair = Pair.of((Object)true, (Object)this.typeMap(fieldType, constantValue));
                if (classFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (classFile != null) {
                        try {
                            classFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Could not read the class file: {}", (Object)declaringClassName, (Object)e);
                    return Pair.of((Object)false, null);
                }
            }
            classFile.close();
        }
        return pair;
    }

    private Object typeMap(Class<?> fieldType, Object obj) {
        if (obj == null) {
            return null;
        }
        if (fieldType == Integer.TYPE) {
            return obj;
        }
        if (fieldType == Long.TYPE) {
            return obj;
        }
        if (fieldType == Float.TYPE) {
            return obj;
        }
        if (fieldType == Double.TYPE) {
            return obj;
        }
        if (fieldType == Boolean.TYPE) {
            return (Integer)obj != 0;
        }
        if (fieldType == Byte.TYPE) {
            return ((Integer)obj).byteValue();
        }
        if (fieldType == Short.TYPE) {
            return ((Integer)obj).shortValue();
        }
        if (fieldType == Character.TYPE) {
            return Character.valueOf((char)((Integer)obj).intValue());
        }
        if (fieldType == String.class) {
            return obj.toString();
        }
        return null;
    }

    private static class ConstantValueVisitor
    extends ClassVisitor {
        private final String fieldName;
        private final String fieldDescriptor;
        private Object constantValue;

        public ConstantValueVisitor(String fieldName, String fieldDescriptor) {
            super(589824);
            this.fieldName = fieldName;
            this.fieldDescriptor = fieldDescriptor;
            this.constantValue = null;
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if (name.equals(this.fieldName) && descriptor.equals(this.fieldDescriptor) && (access & 0x10) != 0 && (access & 8) != 0) {
                this.constantValue = value;
            }
            return null;
        }

        public Object getConstantValue() {
            return this.constantValue;
        }
    }
}

