/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.equals;

import java.util.Collection;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.CtBiScannerDefault;
import spoon.support.visitor.equals.EqualsChecker;
import spoon.support.visitor.equals.NotEqualException;

public class EqualsVisitor
extends CtBiScannerDefault {
    protected final EqualsChecker checker;
    private CtRole lastRole = null;
    protected boolean isNotEqual = false;
    protected CtRole notEqualRole;
    protected Object notEqualElement;
    protected Object notEqualOther;

    public static boolean equals(CtElement element, CtElement other) {
        return new EqualsVisitor().checkEquals(element, other);
    }

    public EqualsVisitor() {
        this(new EqualsChecker());
    }

    public EqualsVisitor(EqualsChecker checker) {
        this.checker = checker;
    }

    @Override
    protected void enter(CtElement e) {
        super.enter(e);
        CtElement other = (CtElement)this.stack.peek();
        this.checker.setOther(other);
        try {
            this.checker.scan(e);
        }
        catch (NotEqualException ex) {
            this.fail(this.checker.getNotEqualRole() == null ? this.lastRole : this.checker.getNotEqualRole(), e, other);
        }
    }

    @Override
    protected void biScan(CtRole role, Collection<? extends CtElement> elements, Collection<? extends CtElement> others) {
        if (this.isNotEqual) {
            return;
        }
        if (elements == null) {
            if (others != null) {
                this.fail(role, elements, others);
            }
            return;
        }
        if (others == null) {
            this.fail(role, elements, others);
            return;
        }
        if (elements.size() != others.size()) {
            this.fail(role, elements, others);
            return;
        }
        super.biScan(role, elements, others);
    }

    @Override
    public void biScan(CtElement element, CtElement other) {
        this.biScan(null, element, other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void biScan(CtRole role, CtElement element, CtElement other) {
        if (this.isNotEqual) {
            return;
        }
        if (element == null) {
            if (other != null) {
                this.fail(role, element, other);
                return;
            }
            return;
        }
        if (other == null) {
            this.fail(role, element, other);
            return;
        }
        if (element == other) {
            return;
        }
        try {
            this.lastRole = role;
            super.biScan(element, other);
        }
        catch (ClassCastException e) {
            this.fail(role, element, other);
        }
        finally {
            this.lastRole = null;
        }
    }

    protected boolean fail(CtRole role, Object element, Object other) {
        this.isNotEqual = true;
        this.notEqualRole = role;
        this.notEqualElement = element;
        this.notEqualOther = other;
        return true;
    }

    public boolean checkEquals(CtElement element, CtElement other) {
        this.biScan(element, other);
        return !this.isNotEqual;
    }

    public boolean isEqual() {
        return !this.isNotEqual;
    }

    public CtRole getNotEqualRole() {
        return this.notEqualRole;
    }

    public Object getNotEqualElement() {
        return this.notEqualElement;
    }

    public Object getNotEqualOther() {
        return this.notEqualOther;
    }
}

