/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.equals;

import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTextBlock;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.declaration.CtCodeSnippet;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.visitor.CtInheritanceScanner;
import spoon.support.visitor.equals.NotEqualException;

public class EqualsChecker
extends CtInheritanceScanner {
    protected CtElement other;
    private boolean isNotEqual;
    private CtRole notEqualRole;

    public void setOther(CtElement other) {
        this.other = other;
        this.isNotEqual = false;
    }

    public boolean isNotEqual() {
        return this.isNotEqual;
    }

    public CtRole getNotEqualRole() {
        return this.notEqualRole;
    }

    protected void setNotEqual(CtRole role) {
        this.notEqualRole = role;
        this.isNotEqual = true;
        throw NotEqualException.INSTANCE;
    }

    @Override
    public void scanCtNamedElement(CtNamedElement e) {
        CtNamedElement peek = (CtNamedElement)this.other;
        if (!e.getSimpleName().equals(peek.getSimpleName())) {
            this.setNotEqual(CtRole.NAME);
        }
        super.scanCtNamedElement(e);
    }

    @Override
    public void scanCtReference(CtReference reference) {
        CtReference peek = (CtReference)this.other;
        if (!reference.getSimpleName().equals(peek.getSimpleName())) {
            this.setNotEqual(CtRole.NAME);
        }
        super.scanCtReference(reference);
    }

    @Override
    public void scanCtStatement(CtStatement s) {
        CtStatement peek = (CtStatement)this.other;
        String leftLabel = s.getLabel();
        String rightLabel = peek.getLabel();
        if (leftLabel == null && rightLabel == null) {
            super.scanCtStatement(s);
            return;
        }
        if (leftLabel == null || !leftLabel.equals(rightLabel)) {
            this.setNotEqual(CtRole.LABEL);
        }
        super.scanCtStatement(s);
    }

    @Override
    public void scanCtModifiable(CtModifiable m) {
        CtModifiable peek = (CtModifiable)this.other;
        if (m.getVisibility() == null) {
            if (peek.getVisibility() != null) {
                this.setNotEqual(CtRole.MODIFIER);
            }
        } else if (peek.getVisibility() == null) {
            this.setNotEqual(CtRole.MODIFIER);
        } else if (!m.getVisibility().equals((Object)peek.getVisibility())) {
            this.setNotEqual(CtRole.MODIFIER);
        }
        if (m.getModifiers().size() != peek.getModifiers().size()) {
            this.setNotEqual(CtRole.MODIFIER);
        }
        if (!m.getModifiers().containsAll(peek.getModifiers())) {
            this.setNotEqual(CtRole.MODIFIER);
        }
        super.scanCtModifiable(m);
    }

    @Override
    public void scanCtCodeSnippet(CtCodeSnippet snippet) {
        CtCodeSnippet peek = (CtCodeSnippet)((Object)this.other);
        if (!snippet.getValue().equals(peek.getValue())) {
            this.setNotEqual(CtRole.SNIPPET);
        }
        super.scanCtCodeSnippet(snippet);
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
        if (!(assignment instanceof CtOperatorAssignment) && this.other instanceof CtOperatorAssignment) {
            this.setNotEqual(null);
        }
        super.visitCtAssignment(assignment);
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        CtOperatorAssignment peek = (CtOperatorAssignment)this.other;
        if (assignment.getKind() == null) {
            if (peek.getKind() != null) {
                this.setNotEqual(CtRole.OPERATOR_KIND);
            }
        } else if (peek.getKind() == null) {
            this.setNotEqual(CtRole.OPERATOR_KIND);
        } else if (!assignment.getKind().equals((Object)peek.getKind())) {
            this.setNotEqual(CtRole.OPERATOR_KIND);
        }
        super.visitCtOperatorAssignment(assignment);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> e) {
        CtBinaryOperator peek = (CtBinaryOperator)this.other;
        if (e.getKind() == null) {
            if (peek.getKind() != null) {
                this.setNotEqual(CtRole.OPERATOR_KIND);
            }
        } else if (peek.getKind() == null) {
            this.setNotEqual(CtRole.OPERATOR_KIND);
        } else if (!e.getKind().equals((Object)peek.getKind())) {
            this.setNotEqual(CtRole.OPERATOR_KIND);
        }
        super.visitCtBinaryOperator(e);
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> e) {
        CtUnaryOperator peek = (CtUnaryOperator)this.other;
        if (e.getKind() == null) {
            if (peek.getKind() != null) {
                this.setNotEqual(CtRole.OPERATOR_KIND);
            }
        } else if (peek.getKind() == null) {
            this.setNotEqual(CtRole.OPERATOR_KIND);
        } else if (!e.getKind().equals((Object)peek.getKind())) {
            this.setNotEqual(CtRole.OPERATOR_KIND);
        }
        super.visitCtUnaryOperator(e);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> e) {
        CtArrayTypeReference peek = (CtArrayTypeReference)this.other;
        if (e.getDimensionCount() != peek.getDimensionCount()) {
            this.setNotEqual(CtRole.TYPE);
        }
        super.visitCtArrayTypeReference(e);
    }

    @Override
    public void visitCtBreak(CtBreak e) {
        CtBreak peek = (CtBreak)this.other;
        if (e.getTargetLabel() == null) {
            if (peek.getTargetLabel() != null) {
                this.setNotEqual(CtRole.TARGET_LABEL);
            }
        } else if (peek.getTargetLabel() == null) {
            this.setNotEqual(CtRole.TARGET_LABEL);
        } else if (!e.getTargetLabel().equals(peek.getTargetLabel())) {
            this.setNotEqual(CtRole.TARGET_LABEL);
        }
        super.visitCtBreak(e);
    }

    @Override
    public void visitCtContinue(CtContinue e) {
        CtContinue peek = (CtContinue)this.other;
        if (e.getTargetLabel() == null) {
            if (peek.getTargetLabel() != null) {
                this.setNotEqual(CtRole.TARGET_LABEL);
            }
        } else if (peek.getTargetLabel() == null) {
            this.setNotEqual(CtRole.TARGET_LABEL);
        } else if (!e.getTargetLabel().equals(peek.getTargetLabel())) {
            this.setNotEqual(CtRole.TARGET_LABEL);
        }
        super.visitCtContinue(e);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> e) {
        CtExecutableReference peek = (CtExecutableReference)this.other;
        if (e.isConstructor() != peek.isConstructor()) {
            this.setNotEqual(null);
        }
        super.visitCtExecutableReference(e);
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> e) {
        CtMethod peek = (CtMethod)this.other;
        if (e.isDefaultMethod() != peek.isDefaultMethod()) {
            this.setNotEqual(CtRole.MODIFIER);
        }
        super.visitCtMethod(e);
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> e) {
        CtParameter peek = (CtParameter)this.other;
        if (e.isVarArgs() != peek.isVarArgs()) {
            this.setNotEqual(CtRole.MODIFIER);
        }
        super.visitCtParameter(e);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> e) {
        CtLiteral peek = (CtLiteral)this.other;
        if (e.getValue() == null) {
            if (peek.getValue() != null) {
                this.setNotEqual(CtRole.VALUE);
            }
        } else if (peek.getValue() == null) {
            this.setNotEqual(CtRole.VALUE);
        } else if (!e.getValue().equals(peek.getValue())) {
            this.setNotEqual(CtRole.VALUE);
        }
        super.visitCtLiteral(e);
    }

    @Override
    public void visitCtTextBlock(CtTextBlock e) {
        CtTextBlock peek = (CtTextBlock)this.other;
        if (e.getValue() == null) {
            if (peek.getValue() != null) {
                this.setNotEqual(CtRole.VALUE);
            }
        } else if (peek.getValue() == null) {
            this.setNotEqual(CtRole.VALUE);
        } else if (!((String)e.getValue()).equals(peek.getValue())) {
            this.setNotEqual(CtRole.VALUE);
        }
        super.visitCtTextBlock(e);
    }

    @Override
    public void visitCtImport(CtImport ctImport) {
        CtImport peek = (CtImport)this.other;
        if (ctImport.getImportKind() == null) {
            if (peek.getImportKind() != null) {
                this.setNotEqual(null);
            }
        } else if (peek.getImportKind() == null) {
            this.setNotEqual(null);
        } else if (!ctImport.getImportKind().equals((Object)peek.getImportKind())) {
            this.setNotEqual(null);
        }
        super.visitCtImport(ctImport);
    }
}

