/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.equals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.support.util.EmptyClearableList;
import spoon.support.util.EmptyClearableSet;
import spoon.support.visitor.clone.CloneVisitor;

public class CloneHelper {
    public static final CloneHelper INSTANCE = new CloneHelper();

    public <T extends CtElement> T clone(T element) {
        CloneVisitor cloneVisitor = new CloneVisitor(this);
        cloneVisitor.scan(element);
        return cloneVisitor.getClone();
    }

    public <T extends CtElement> Collection<T> clone(Collection<T> elements) {
        if (elements == null || elements.isEmpty()) {
            return new ArrayList();
        }
        ArrayList others = new ArrayList();
        for (CtElement element : elements) {
            this.addClone(others, element);
        }
        return others;
    }

    public <T extends CtElement> List<T> clone(List<T> elements) {
        if (elements instanceof EmptyClearableList) {
            return elements;
        }
        if (elements == null || elements.isEmpty()) {
            return new ArrayList();
        }
        ArrayList others = new ArrayList();
        for (CtElement element : elements) {
            this.addClone(others, element);
        }
        return others;
    }

    public <T extends CtElement> Set<T> clone(Set<T> elements) {
        if (elements instanceof EmptyClearableSet) {
            return elements;
        }
        if (elements == null || elements.isEmpty()) {
            return EmptyClearableSet.instance();
        }
        LinkedHashSet others = new LinkedHashSet(elements.size());
        for (CtElement element : elements) {
            this.addClone(others, element);
        }
        return others;
    }

    public <T extends CtElement> Map<String, T> clone(Map<String, T> elements) {
        if (elements == null || elements.isEmpty()) {
            return new HashMap();
        }
        HashMap others = new HashMap();
        for (Map.Entry<String, T> tEntry : elements.entrySet()) {
            this.addClone(others, tEntry.getKey(), (CtElement)tEntry.getValue());
        }
        return others;
    }

    protected <T extends CtElement> void addClone(Collection<T> targetCollection, T element) {
        targetCollection.add(this.clone(element));
    }

    protected <T extends CtElement> void addClone(Map<String, T> targetMap, String key, T value) {
        targetMap.put(key, this.clone(value));
    }

    public void tailor(CtElement topLevelElement, CtElement topLevelClone) {
        new CtScanner(){

            @Override
            public <T> void visitCtExecutableReference(CtExecutableReference<T> clone) {
                super.visitCtExecutableReference(clone);
            }
        }.scan(topLevelClone);
    }
}

