/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.CtScannerListener;
import spoon.reflect.visitor.chain.ScanningMode;
import spoon.reflect.visitor.filter.CtScannerFunction;
import spoon.reflect.visitor.filter.SuperInheritanceHierarchyFunction;
import spoon.reflect.visitor.filter.TypeFilter;

public class SubInheritanceHierarchyResolver {
    private CtPackage inputPackage;
    private boolean includingInterfaces = true;
    private Set<String> targetSuperTypes = new HashSet<String>();
    private boolean hasSuperInterface = false;
    private boolean failOnClassNotFound = false;
    private static final Filter<CtType<?>> typeFilter = new Filter<CtType<?>>(){

        @Override
        public boolean matches(CtType<?> type) {
            return !(type instanceof CtTypeParameter);
        }
    };
    private static final Filter<CtClass<?>> classFilter = new TypeFilter<CtClass>(CtClass.class);

    public SubInheritanceHierarchyResolver(CtPackage input) {
        this.inputPackage = input;
    }

    public SubInheritanceHierarchyResolver addSuperType(CtTypeInformation superType) {
        this.targetSuperTypes.add(superType.getQualifiedName());
        if (!this.hasSuperInterface) {
            this.hasSuperInterface = superType.isInterface();
        }
        return this;
    }

    public SubInheritanceHierarchyResolver includingInterfaces(boolean includingInterfaces) {
        this.includingInterfaces = includingInterfaces;
        return this;
    }

    public SubInheritanceHierarchyResolver failOnClassNotFound(boolean failOnClassNotFound) {
        this.failOnClassNotFound = failOnClassNotFound;
        return this;
    }

    public <T extends CtType<?>> void forEachSubTypeInPackage(final CtConsumer<T> outputConsumer) {
        final HashSet allVisitedTypeNames = new HashSet();
        final ArrayDeque currentSubTypes = new ArrayDeque();
        CtQuery q = this.inputPackage.map(new CtScannerFunction());
        if (this.includingInterfaces) {
            q.select(typeFilter);
        } else {
            q.select(classFilter);
        }
        q.map(new SuperInheritanceHierarchyFunction().includingInterfaces(this.hasSuperInterface).failOnClassNotFound(this.failOnClassNotFound).setListener(new CtScannerListener(){

            @Override
            public ScanningMode enter(CtElement element) {
                CtTypeReference typeRef = (CtTypeReference)element;
                String qName = typeRef.getQualifiedName();
                if (SubInheritanceHierarchyResolver.this.targetSuperTypes.contains(qName)) {
                    while (!currentSubTypes.isEmpty()) {
                        CtTypeReference currentTypeRef = (CtTypeReference)currentSubTypes.pop();
                        String currentQName = currentTypeRef.getQualifiedName();
                        if (SubInheritanceHierarchyResolver.this.targetSuperTypes.contains(currentQName)) continue;
                        SubInheritanceHierarchyResolver.this.targetSuperTypes.add(currentQName);
                        outputConsumer.accept(currentTypeRef.getTypeDeclaration());
                    }
                    return ScanningMode.SKIP_ALL;
                }
                if (!allVisitedTypeNames.add(qName)) {
                    return ScanningMode.SKIP_ALL;
                }
                currentSubTypes.push(typeRef);
                return ScanningMode.NORMAL;
            }

            @Override
            public void exit(CtElement element) {
                CtTypeInformation stackType;
                CtTypeInformation type = (CtTypeInformation)((Object)element);
                if (!currentSubTypes.isEmpty() && (stackType = (CtTypeInformation)currentSubTypes.pop()) != type) {
                    throw new SpoonException("CtScannerListener#exit was not called after enter.");
                }
            }
        })).forEach(new CtConsumer<CtType<?>>(){

            @Override
            public void accept(CtType<?> type) {
            }
        });
    }
}

