/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import spoon.processing.Processor;
import spoon.processing.TraversalStrategy;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.Factory;
import spoon.reflect.visitor.CtScanner;

public class ProcessingVisitor
extends CtScanner {
    Factory factory;
    Processor<?> processor;

    public ProcessingVisitor(Factory factory) {
        this.factory = factory;
    }

    private boolean canBeProcessed(CtElement e) {
        if (!this.factory.getEnvironment().isProcessingStopped() && this.processor.getProcessedElementTypes() != null) {
            for (Class<CtElement> o : this.processor.getProcessedElementTypes()) {
                if (o.isAssignableFrom(e.getClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Processor<?> getProcessor() {
        return this.processor;
    }

    @Override
    public void scan(CtElement e) {
        if (e == null) {
            return;
        }
        Processor<?> p = this.processor;
        if (p.getTraversalStrategy() == TraversalStrategy.PRE_ORDER && this.canBeProcessed(e) && p.isToBeProcessed(e)) {
            p.process(e);
        }
        super.scan(e);
        if (p.getTraversalStrategy() == TraversalStrategy.POST_ORDER && this.canBeProcessed(e) && p.isToBeProcessed(e)) {
            p.process(e);
        }
    }

    public void setProcessor(Processor<?> processor) {
        this.processor = processor;
    }
}

