/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import spoon.SpoonException;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.ScanningMode;
import spoon.reflect.visitor.filter.SuperInheritanceHierarchyFunction;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.visitor.AbstractTypingContext;
import spoon.support.visitor.MethodTypingContext;

public class ClassTypingContext
extends AbstractTypingContext {
    private final CtType<?> scopeType;
    private ClassTypingContext enclosingClassTypingContext;
    private Map<String, List<CtTypeReference<?>>> typeToArguments = new HashMap();
    private CtTypeInformation lastResolvedSuperclass;
    private Set<String> visitedSet;

    public ClassTypingContext(CtTypeReference<?> typeReference) {
        this.scopeType = typeReference.getTypeDeclaration();
        this.lastResolvedSuperclass = typeReference;
        CtTypeReference<?> enclosing = this.getEnclosingType(typeReference);
        if (enclosing != null) {
            this.enclosingClassTypingContext = this.createEnclosingHierarchy(enclosing);
        }
        this.typeToArguments.put(typeReference.getQualifiedName(), typeReference.getActualTypeArguments());
    }

    public ClassTypingContext(CtType<?> type) {
        this.scopeType = type;
        this.lastResolvedSuperclass = type;
        CtType<?> enclosing = this.getEnclosingType(type);
        if (enclosing != null) {
            this.enclosingClassTypingContext = this.createEnclosingHierarchy(enclosing);
        }
        this.typeToArguments.put(type.getQualifiedName(), ClassTypingContext.getTypeReferences(type.getFormalCtTypeParameters()));
    }

    @Override
    public CtType<?> getAdaptationScope() {
        return this.scopeType;
    }

    public boolean isSubtypeOf(CtTypeReference<?> superTypeRef) {
        List<CtTypeReference<?>> adaptedArgs = this.resolveActualTypeArgumentsOf(superTypeRef);
        if (adaptedArgs == null) {
            return false;
        }
        if (!this.isSubTypeByActualTypeArguments(superTypeRef, adaptedArgs)) {
            return false;
        }
        CtTypeReference<?> enclosingTypeRef = this.getEnclosingType(superTypeRef);
        if (enclosingTypeRef != null) {
            if (this.enclosingClassTypingContext == null) {
                return false;
            }
            return this.enclosingClassTypingContext.isSubtypeOf(enclosingTypeRef);
        }
        return true;
    }

    public @Nullable List<CtTypeReference<?>> resolveActualTypeArgumentsOf(CtTypeReference<?> typeRef) {
        final String typeQualifiedName = typeRef.getQualifiedName();
        List<CtTypeReference<?>> args = this.typeToArguments.get(typeQualifiedName);
        if (args != null) {
            return args;
        }
        CtTypeReference<?> enclosingTypeRef = this.getEnclosingType(typeRef);
        if (enclosingTypeRef != null) {
            if (this.enclosingClassTypingContext == null) {
                return null;
            }
            if (this.enclosingClassTypingContext.resolveActualTypeArgumentsOf(enclosingTypeRef) == null) {
                return null;
            }
        }
        if (this.lastResolvedSuperclass == null) {
            return null;
        }
        final HierarchyListener listener = new HierarchyListener(this.getVisitedSet());
        this.getVisitedSet().remove(this.lastResolvedSuperclass.getQualifiedName());
        ((CtElement)((Object)this.lastResolvedSuperclass)).map(new SuperInheritanceHierarchyFunction().interfacesExtendObject(true).includingSelf(false).returnTypeReferences(true).setListener(listener)).forEach(new CtConsumer<CtTypeReference<?>>(){

            @Override
            public void accept(CtTypeReference<?> typeRef) {
                String superTypeQualifiedName = typeRef.getQualifiedName();
                List<CtTypeReference<?>> actualTypeArguments = typeRef.getActualTypeArguments();
                if (actualTypeArguments.isEmpty()) {
                    List<CtTypeParameter> typeParams;
                    CtType<?> type = typeRef.getTypeDeclaration();
                    if (type != null) {
                        typeParams = type.getFormalCtTypeParameters();
                    } else if (typeRef.getFactory().getEnvironment().getNoClasspath()) {
                        typeParams = Collections.emptyList();
                    } else {
                        throw new SpoonClassNotFoundException(typeRef.getQualifiedName() + " cannot be found in the sourcepath or classpath");
                    }
                    if (!typeParams.isEmpty()) {
                        actualTypeArguments = new ArrayList(typeParams.size());
                        for (CtTypeParameter typeParam : typeParams) {
                            actualTypeArguments.add(typeParam.getTypeErasure());
                        }
                    }
                }
                List<CtTypeReference<?>> superTypeActualTypeArgumentsResolvedFromSubType = ClassTypingContext.this.resolveTypeParameters(actualTypeArguments);
                ClassTypingContext.this.typeToArguments.put(superTypeQualifiedName, superTypeActualTypeArgumentsResolvedFromSubType);
                if (typeQualifiedName.equals(superTypeQualifiedName)) {
                    listener.foundArguments = superTypeActualTypeArgumentsResolvedFromSubType;
                }
            }
        });
        if (listener.foundArguments == null) {
            this.lastResolvedSuperclass = null;
        }
        return listener.foundArguments;
    }

    public boolean isOverriding(CtMethod<?> thisMethod, CtMethod<?> thatMethod) {
        CtFormalTypeDeclarer thisDeclType;
        if (thisMethod == thatMethod) {
            return true;
        }
        CtType<?> thatDeclType = thatMethod.getDeclaringType();
        if (thatDeclType != (thisDeclType = this.getAdaptationScope()) && !this.isSubtypeOf((CtTypeReference<?>)thatDeclType.getReference())) {
            return false;
        }
        return this.isSubSignature(thisMethod, thatMethod);
    }

    public boolean isSubSignature(CtMethod<?> thisMethod, CtMethod<?> thatMethod) {
        return this.isSameSignature(thisMethod, thatMethod, true);
    }

    public boolean isSameSignature(CtExecutable<?> thisExecutable, CtMethod<?> thatExecutable) {
        if (thatExecutable instanceof CtConstructor) {
            return false;
        }
        return this.isSameSignature(thisExecutable, thatExecutable, false);
    }

    @Override
    public ClassTypingContext getEnclosingGenericTypeAdapter() {
        return this.enclosingClassTypingContext;
    }

    protected ClassTypingContext createEnclosingHierarchy(CtType<?> enclosingType) {
        return new ClassTypingContext(enclosingType);
    }

    protected ClassTypingContext createEnclosingHierarchy(CtTypeReference<?> enclosingTypeRef) {
        return new ClassTypingContext(enclosingTypeRef);
    }

    static List<CtTypeReference<?>> getTypeReferences(List<? extends CtType<?>> types) {
        ArrayList refs = new ArrayList(types.size());
        for (CtType<?> type : types) {
            refs.add((CtTypeReference<?>)type.getReference());
        }
        return refs;
    }

    private @Nullable CtType<?> getEnclosingType(CtType<?> type) {
        if (type.hasModifier(ModifierKind.STATIC)) {
            return null;
        }
        CtType<?> declType = type.getDeclaringType();
        if (declType == null) {
            return null;
        }
        if (declType.isInterface()) {
            return null;
        }
        return declType;
    }

    private @Nullable CtTypeReference<?> getEnclosingType(CtTypeReference<?> typeRef) {
        CtType<?> type = typeRef.getTypeDeclaration();
        if (type != null) {
            if (type.hasModifier(ModifierKind.STATIC)) {
                return null;
            }
            CtType<?> declType = type.getDeclaringType();
            if (declType == null) {
                return null;
            }
            if (type.isInterface()) {
                return null;
            }
            if (declType.isInterface()) {
                return null;
            }
        }
        return typeRef.getDeclaringType();
    }

    @Override
    protected @Nullable CtTypeReference<?> adaptTypeParameter(CtTypeParameter typeParam) {
        if (typeParam == null) {
            throw new SpoonException("You cannot adapt a null type parameter.");
        }
        CtFormalTypeDeclarer declarer = typeParam.getTypeParameterDeclarer();
        if (!(declarer instanceof CtType)) {
            return null;
        }
        List<CtTypeReference<?>> actualTypeArguments = this.resolveActualTypeArgumentsOf((CtTypeReference<?>)((CtType)declarer).getReference());
        if (actualTypeArguments == null) {
            if (this.enclosingClassTypingContext != null) {
                return this.enclosingClassTypingContext.adaptType(typeParam);
            }
            return null;
        }
        return ClassTypingContext.getValue(actualTypeArguments, typeParam, declarer);
    }

    private Set<String> getVisitedSet() {
        if (this.visitedSet == null) {
            this.visitedSet = new HashSet<String>();
        }
        return this.visitedSet;
    }

    private List<CtTypeReference<?>> resolveTypeParameters(List<CtTypeReference<?>> typeRefs) {
        ArrayList result = new ArrayList(typeRefs.size());
        for (CtTypeReference<?> typeRef : typeRefs) {
            if (typeRef instanceof CtTypeParameterReference) {
                CtTypeParameterReference typeParamRef = (CtTypeParameterReference)typeRef;
                CtTypeParameter typeParam = typeParamRef.getDeclaration();
                if (typeParam == null) {
                    throw new SpoonException("The typeParam " + typeRef.getQualifiedName() + " declaration cannot be resolved");
                }
                CtFormalTypeDeclarer declarer = typeParam.getTypeParameterDeclarer();
                typeRef = this.resolveTypeParameter(declarer, typeParamRef, typeParam, typeRef);
            }
            result.add(typeRef);
        }
        return result;
    }

    private CtTypeReference<?> resolveTypeParameter(CtFormalTypeDeclarer declarer, CtTypeParameterReference typeParamRef, CtTypeParameter typeParam, CtTypeReference<?> typeRef) {
        if (!(declarer instanceof CtType)) {
            return typeRef;
        }
        CtType typeDeclarer = (CtType)declarer;
        List<CtTypeReference<?>> actualTypeArguments = this.getActualTypeArguments(typeDeclarer.getQualifiedName());
        if (actualTypeArguments == null) {
            return typeRef;
        }
        if (actualTypeArguments.size() != typeDeclarer.getFormalCtTypeParameters().size()) {
            if (!actualTypeArguments.isEmpty()) {
                throw new SpoonException("Unexpected actual type arguments " + actualTypeArguments + " on " + typeDeclarer);
            }
            actualTypeArguments = ClassTypingContext.getTypeReferences(typeDeclarer.getFormalCtTypeParameters());
            this.typeToArguments.put(typeDeclarer.getQualifiedName(), actualTypeArguments);
        }
        return ClassTypingContext.getValue(actualTypeArguments, typeParam, declarer);
    }

    private @Nullable List<CtTypeReference<?>> getActualTypeArguments(String qualifiedName) {
        List<CtTypeReference<?>> actualTypeArguments = this.typeToArguments.get(qualifiedName);
        if (actualTypeArguments != null) {
            return actualTypeArguments;
        }
        if (this.enclosingClassTypingContext != null) {
            return this.enclosingClassTypingContext.getActualTypeArguments(qualifiedName);
        }
        return null;
    }

    private static CtTypeReference<?> getValue(List<CtTypeReference<?>> arguments, CtTypeParameter typeParam, CtFormalTypeDeclarer declarer) {
        if (declarer.getFormalCtTypeParameters().size() != arguments.size()) {
            throw new SpoonException("Unexpected count of actual type arguments");
        }
        int typeParamIdx = declarer.getFormalCtTypeParameters().indexOf(typeParam);
        return arguments.get(typeParamIdx);
    }

    static <T, U extends List<T>> T substituteBy(CtTypeParameter typeParameter, CtFormalTypeDeclarer declarer, U values) {
        List<CtTypeParameter> typeParams = declarer.getFormalCtTypeParameters();
        int position = typeParams.indexOf(typeParameter);
        if (position == -1) {
            throw new SpoonException("Type parameter <" + typeParameter.getSimpleName() + " not found in scope " + declarer.getShortRepresentation());
        }
        if (values.size() != typeParams.size()) {
            throw new SpoonException("Unexpected count of parameters");
        }
        return values.get(position);
    }

    private boolean isSubTypeByActualTypeArguments(CtTypeReference<?> superTypeRef, List<CtTypeReference<?>> expectedSuperTypeArguments) {
        List<CtTypeReference<?>> superTypeArgs = superTypeRef.getActualTypeArguments();
        if (superTypeArgs.isEmpty()) {
            return true;
        }
        List<CtTypeReference<?>> subTypeArgs = expectedSuperTypeArguments;
        if (subTypeArgs.isEmpty()) {
            return true;
        }
        if (subTypeArgs.size() != superTypeArgs.size()) {
            return false;
        }
        for (int i = 0; i < subTypeArgs.size(); ++i) {
            CtTypeReference<?> superArg = superTypeArgs.get(i);
            CtTypeReference<?> subArg = subTypeArgs.get(i);
            if (this.isSubTypeArg(subArg, superArg)) continue;
            return false;
        }
        return true;
    }

    private boolean isSubTypeArg(CtTypeReference<?> subArg, CtTypeReference<?> superArg) {
        if (superArg instanceof CtWildcardReference) {
            CtWildcardReference wr = (CtWildcardReference)superArg;
            CtTypeReference<?> superBound = wr.getBoundingType();
            if (superBound.equals(wr.getFactory().Type().objectType())) {
                return wr.isUpper();
            }
            if (subArg instanceof CtWildcardReference) {
                CtWildcardReference subWr = (CtWildcardReference)subArg;
                CtTypeReference<?> subBound = subWr.getBoundingType();
                if (subBound.equals(wr.getFactory().Type().objectType())) {
                    return false;
                }
                if (wr.isUpper() != subWr.isUpper()) {
                    return false;
                }
                if (wr.isUpper()) {
                    return subBound.isSubtypeOf(superBound);
                }
                return superBound.isSubtypeOf(subBound);
            }
            if (wr.isUpper()) {
                return subArg.isSubtypeOf(superBound);
            }
            return superBound.isSubtypeOf(subArg);
        }
        return subArg.equals(superArg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSameSignature(CtExecutable<?> thisMethod, CtExecutable<?> thatMethod, boolean canTypeErasure) {
        if (thisMethod == thatMethod) {
            return true;
        }
        ExecutableContext mtc = new ExecutableContext();
        mtc.setClassTypingContext(this);
        if (thisMethod instanceof CtMethod) {
            if (!(thatMethod instanceof CtMethod)) return false;
            mtc.setMethod((CtMethod)thisMethod);
            return mtc.isSameSignatureLikeScopeMethod(thatMethod, canTypeErasure);
        } else {
            if (!(thisMethod instanceof CtConstructor)) return false;
            if (!(thatMethod instanceof CtConstructor)) return false;
            mtc.setConstructor((CtConstructor)thisMethod);
        }
        return mtc.isSameSignatureLikeScopeMethod(thatMethod, canTypeErasure);
    }

    private static class ExecutableContext
    extends MethodTypingContext {
        private ExecutableContext() {
        }

        private boolean isSameSignatureLikeScopeMethod(CtExecutable<?> thatExecutable, boolean canTypeErasure) {
            CtFormalTypeDeclarer thatDeclarer = (CtFormalTypeDeclarer)((Object)thatExecutable);
            CtFormalTypeDeclarer thisDeclarer = this.getAdaptationScope();
            CtExecutable thisExecutable = (CtExecutable)((Object)thisDeclarer);
            if (!thatExecutable.getSimpleName().equals(thisExecutable.getSimpleName())) {
                return false;
            }
            if (thisExecutable.getParameters().size() != thatExecutable.getParameters().size()) {
                return false;
            }
            List<CtTypeParameter> thisTypeParameters = thisDeclarer.getFormalCtTypeParameters();
            List<CtTypeParameter> thatTypeParameters = thatDeclarer.getFormalCtTypeParameters();
            boolean useTypeErasure = false;
            if (thisTypeParameters.size() == thatTypeParameters.size()) {
                if (!this.hasSameMethodFormalTypeParameters((CtFormalTypeDeclarer)((Object)thatExecutable))) {
                    return false;
                }
            } else {
                if (!canTypeErasure) {
                    return false;
                }
                if (!thisTypeParameters.isEmpty()) {
                    return false;
                }
                useTypeErasure = true;
            }
            List<CtTypeReference<?>> thisParameterTypes = ExecutableContext.getParameterTypes(thisExecutable.getParameters());
            List<CtTypeReference<?>> thatParameterTypes = ExecutableContext.getParameterTypes(thatExecutable.getParameters());
            for (int i = 0; i < thisParameterTypes.size(); ++i) {
                CtWildcardReference wildcardReference;
                CtTypeReference<?> actualTA;
                CtTypeReference<?> thisType = thisParameterTypes.get(i);
                CtTypeReference<?> thatType = thatParameterTypes.get(i);
                if (useTypeErasure) {
                    if (thatType instanceof CtTypeParameterReference) {
                        thatType = ((CtTypeParameterReference)thatType).getTypeErasure();
                    }
                } else {
                    thatType = this.adaptType(thatType);
                }
                if (thatType == null) {
                    return false;
                }
                if (thisType.getActualTypeArguments().isEmpty() && thatType.getActualTypeArguments().size() == 1 && (actualTA = thatType.getActualTypeArguments().get(0)) instanceof CtWildcardReference && (wildcardReference = (CtWildcardReference)actualTA).isDefaultBoundingType()) {
                    thatType.setActualTypeArguments(Collections.emptyList());
                }
                if (thisType.equals(thatType)) continue;
                return false;
            }
            return true;
        }

        private static List<CtTypeReference<?>> getParameterTypes(List<CtParameter<?>> params) {
            ArrayList types = new ArrayList(params.size());
            for (CtParameter<?> param : params) {
                types.add(param.getType());
            }
            return types;
        }
    }

    private class HierarchyListener
    extends SuperInheritanceHierarchyFunction.DistinctTypeListener {
        List<CtTypeReference<?>> foundArguments;

        HierarchyListener(Set<String> visitedSet) {
            super(visitedSet);
        }

        @Override
        public ScanningMode enter(CtTypeReference<?> typeRef, boolean isClass) {
            ScanningMode mode;
            if (isClass) {
                if (this.foundArguments != null) {
                    return ScanningMode.SKIP_ALL;
                }
                ClassTypingContext.this.lastResolvedSuperclass = typeRef;
            }
            if ((mode = super.enter(typeRef)) == ScanningMode.SKIP_ALL) {
                return mode;
            }
            return ScanningMode.NORMAL;
        }
    }
}

