/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import java.util.ArrayList;
import org.jspecify.annotations.Nullable;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.support.visitor.GenericTypeAdapter;

abstract class AbstractTypingContext
implements GenericTypeAdapter {
    protected AbstractTypingContext() {
    }

    @Override
    public CtTypeReference<?> adaptType(CtTypeInformation type) {
        CtReference result;
        boolean isCopy = false;
        if (type instanceof CtTypeReference) {
            if (type instanceof CtTypeParameterReference) {
                return this.adaptTypeParameterReference((CtTypeParameterReference)type);
            }
            result = (CtTypeReference)type;
        } else {
            if (type instanceof CtTypeParameter) {
                return this.adaptTypeParameter((CtTypeParameter)type);
            }
            CtType t = (CtType)type;
            result = t.getFactory().Type().createReference(t, true);
            isCopy = true;
        }
        if (!result.getActualTypeArguments().isEmpty() && !isCopy) {
            CtElement parent = result.isParentInitialized() ? result.getParent() : null;
            result = result.clone();
            if (parent != null) {
                result.setParent(parent);
            }
            ArrayList actTypeArgs = new ArrayList(result.getActualTypeArguments());
            for (int i = 0; i < actTypeArgs.size(); ++i) {
                CtTypeReference<?> adaptedTypeArgs = this.adaptType((CtTypeInformation)actTypeArgs.get(i));
                if (adaptedTypeArgs == null) continue;
                actTypeArgs.set(i, (CtTypeReference<?>)adaptedTypeArgs.clone());
            }
            result.setActualTypeArguments(actTypeArgs);
        }
        return result;
    }

    private CtTypeReference<?> adaptTypeParameterReference(CtTypeParameterReference typeParamRef) {
        if (typeParamRef instanceof CtWildcardReference) {
            return this.adaptTypeParameterReferenceBoundingType((CtWildcardReference)typeParamRef, typeParamRef.getBoundingType());
        }
        return this.adaptTypeParameter(typeParamRef.getDeclaration());
    }

    private CtTypeReference<?> adaptTypeParameterReferenceBoundingType(CtWildcardReference typeParamRef, CtTypeReference<?> boundingType) {
        CtWildcardReference typeParamRefAdapted = typeParamRef.clone();
        if (typeParamRef.isParentInitialized()) {
            typeParamRefAdapted.setParent(typeParamRef.getParent());
        }
        typeParamRefAdapted.setBoundingType(boundingType.equals(boundingType.getFactory().Type().getDefaultBoundingType()) ? boundingType.getFactory().Type().getDefaultBoundingType() : this.adaptType(boundingType));
        return typeParamRefAdapted;
    }

    protected abstract @Nullable CtTypeReference<?> adaptTypeParameter(CtTypeParameter var1);
}

