/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.util.internal;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.support.modelobs.FineModelChangeListener;
import spoon.support.util.internal.ModelCollectionUtils;

public abstract class ElementNameMap<T extends CtElement>
extends AbstractMap<String, T>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final ConcurrentHashMap<String, InsertOrderWrapper<T>> map = new ConcurrentHashMap();
    private final AtomicInteger insertionNumber = new AtomicInteger();

    protected ElementNameMap() {
    }

    protected abstract CtElement getOwner();

    protected abstract CtRole getRole();

    @Override
    public @Nullable T put(String key, T e) {
        if (e == null) {
            return null;
        }
        CtElement owner = this.getOwner();
        ModelCollectionUtils.linkToParent(owner, e);
        this.getModelChangeListener().onMapAdd(owner, this.getRole(), this.map, key, (CtElement)e);
        long currentInsertNumber = this.insertionNumber.incrementAndGet();
        InsertOrderWrapper<T> wrapper = new InsertOrderWrapper<T>(e, currentInsertNumber);
        return this.valueOrNull(this.map.put(key, wrapper));
    }

    private @Nullable T valueOrNull(InsertOrderWrapper<T> wrapper) {
        return (T)(wrapper != null ? (CtElement)wrapper.value : null);
    }

    @Override
    public @Nullable T remove(Object key) {
        T removed = this.valueOrNull(this.map.remove(key));
        if (removed == null) {
            return null;
        }
        this.getModelChangeListener().onMapDelete(this.getOwner(), this.getRole(), this.map, (String)key, (CtElement)removed);
        return removed;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        if (this.map.isEmpty()) {
            return;
        }
        LinkedHashMap<String, T> old = this.toInsertionOrderedMap();
        this.map.clear();
        LinkedHashMap<String, T> current = this.toInsertionOrderedMap();
        this.getModelChangeListener().onMapDeleteAll(this.getOwner(), this.getRole(), current, old);
    }

    private LinkedHashMap<String, T> toInsertionOrderedMap() {
        BinaryOperator mergeFunction = (lhs, rhs) -> rhs;
        return this.entriesByInsertionOrder().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction, LinkedHashMap::new));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public @Nullable T get(Object key) {
        InsertOrderWrapper<T> wrapper = this.map.get(key);
        if (wrapper == null) {
            return null;
        }
        return (T)((CtElement)wrapper.value);
    }

    public void updateKey(String oldKey, String newKey) {
        InsertOrderWrapper<T> wrapper = this.map.remove(oldKey);
        if (wrapper != null) {
            this.map.put(newKey, wrapper);
        }
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.entriesByInsertionOrder().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Stream<Map.Entry<String, T>> entriesByInsertionOrder() {
        return this.map.entrySet().stream().sorted(Comparator.comparing(entry -> ((InsertOrderWrapper)entry.getValue()).insertionNumber)).map(entry -> new AbstractMap.SimpleEntry<String, CtElement>((String)entry.getKey(), (CtElement)((InsertOrderWrapper)entry.getValue()).value));
    }

    private FineModelChangeListener getModelChangeListener() {
        return this.getOwner().getFactory().getEnvironment().getModelChangeListener();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementNameMap that = (ElementNameMap)o;
        return Objects.equals(this.map, that.map);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.map);
    }

    private static class InsertOrderWrapper<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final long insertionNumber;
        final T value;

        InsertOrderWrapper(T value, long insertionNumber) {
            this.value = value;
            this.insertionNumber = insertionNumber;
        }
    }
}

