/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;

public class SortedList<E>
extends LinkedList<E> {
    private static final long serialVersionUID = 1L;
    Comparator<? super E> comparator;

    public SortedList(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean add(E o) {
        ListIterator<E> iterator = this.listIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.comparator.compare(o, e) >= 0) continue;
            iterator.previous();
            iterator.add(o);
            return true;
        }
        return super.add(o);
    }

    @Override
    public void add(int index, E element) {
        throw new IllegalArgumentException("cannot force a position with a sorted list that has its own ordering");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ret = false;
        for (E e : c) {
            ret |= this.add(e);
        }
        return ret;
    }

    public Comparator<? super E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }
}

