/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import spoon.support.Internal;
import spoon.support.util.ImmutableMap;

@Internal
public class ImmutableMapImpl
implements ImmutableMap {
    protected final ImmutableMap parent;
    protected final Map<String, Object> map;

    public ImmutableMapImpl(Map<String, Object> map) {
        this(null, map);
    }

    private ImmutableMapImpl(ImmutableMap parent, Map<String, Object> map) {
        this.parent = parent;
        this.map = Collections.unmodifiableMap(map);
    }

    public ImmutableMapImpl(Map<String, Object> map, String parameterName, Object value) {
        this(null, map, parameterName, value);
    }

    private ImmutableMapImpl(ImmutableMap parent, Map<String, Object> map, String parameterName, Object value) {
        this.parent = null;
        HashMap<String, Object> copy = new HashMap<String, Object>(map.size() + 1);
        copy.putAll(map);
        copy.put(parameterName, value);
        this.map = Collections.unmodifiableMap(copy);
    }

    public ImmutableMapImpl() {
        this.parent = null;
        this.map = Collections.emptyMap();
    }

    @Override
    public ImmutableMapImpl checkpoint() {
        return new ImmutableMapImpl(this, Collections.emptyMap());
    }

    @Override
    public boolean hasValue(String parameterName) {
        if (this.map.containsKey(parameterName)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasValue(parameterName);
        }
        return false;
    }

    @Override
    public Object getValue(String parameterName) {
        Object v = this.map.get(parameterName);
        if (v == null && this.parent != null) {
            v = this.parent.getValue(parameterName);
        }
        return v;
    }

    @Override
    public ImmutableMap putValue(String parameterName, Object value) {
        return new ImmutableMapImpl(this.parent, this.map, parameterName, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ImmutableMapImpl.appendMap(sb, this.map);
        if (this.parent != null) {
            sb.append("\nparent:\n");
            sb.append(this.parent);
        }
        return sb.toString();
    }

    private static void appendMap(StringBuilder sb, Map<String, Object> map) {
        ArrayList<String> paramNames = new ArrayList<String>(map.keySet());
        paramNames.sort((a, b) -> a.compareTo((String)b));
        for (String name : paramNames) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(name).append('=').append(map.get(name));
        }
    }

    @Override
    public Map<String, Object> asMap() {
        if (this.parent != null) {
            HashMap<String, Object> merged = new HashMap<String, Object>();
            merged.putAll(this.parent.asMap());
            merged.putAll(this.map);
            return Collections.unmodifiableMap(merged);
        }
        return this.map;
    }

    @Override
    public Map<String, Object> getModifiedValues() {
        return this.map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutableMap) {
            obj = ((ImmutableMap)((Object)obj)).asMap();
        }
        if (obj instanceof Map) {
            Map<String, Object> map = obj;
            return this.asMap().equals(map);
        }
        return false;
    }
}

