/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.sniper.internal;

import spoon.reflect.code.CtComment;
import spoon.reflect.visitor.PrinterHelper;
import spoon.reflect.visitor.TokenWriter;
import spoon.support.sniper.internal.TokenType;

public class TokenWriterProxy
implements TokenWriter {
    private final Listener listener;
    private final TokenWriter delegate;

    public TokenWriterProxy(Listener listener, TokenWriter delegate) {
        this.listener = listener;
        this.delegate = delegate;
    }

    @Override
    public TokenWriter writeSeparator(String token) {
        this.listener.onTokenWriterWrite(TokenType.SEPARATOR, token, null, () -> this.delegate.writeSeparator(token));
        return this;
    }

    @Override
    public TokenWriter writeOperator(String token) {
        this.listener.onTokenWriterWrite(TokenType.OPERATOR, token, null, () -> this.delegate.writeOperator(token));
        return this;
    }

    @Override
    public TokenWriter writeLiteral(String token) {
        this.listener.onTokenWriterWrite(TokenType.LITERAL, token, null, () -> this.delegate.writeLiteral(token));
        return this;
    }

    @Override
    public TokenWriter writeKeyword(String token) {
        this.listener.onTokenWriterWrite(TokenType.KEYWORD, token, null, () -> this.delegate.writeKeyword(token));
        return this;
    }

    @Override
    public TokenWriter writeIdentifier(String token) {
        this.listener.onTokenWriterWrite(TokenType.IDENTIFIER, token, null, () -> this.delegate.writeIdentifier(token));
        return this;
    }

    @Override
    public TokenWriter writeCodeSnippet(String token) {
        this.listener.onTokenWriterWrite(TokenType.CODE_SNIPPET, token, null, () -> this.delegate.writeCodeSnippet(token));
        return this;
    }

    @Override
    public TokenWriter writeComment(CtComment comment) {
        this.listener.onTokenWriterWrite(TokenType.COMMENT, null, comment, () -> this.delegate.writeComment(comment));
        return this;
    }

    @Override
    public TokenWriter writeln() {
        this.listener.onTokenWriterWrite(TokenType.NEW_LINE, "\n", null, () -> this.delegate.writeln());
        return this;
    }

    @Override
    public TokenWriter incTab() {
        this.listener.onTokenWriterWrite(TokenType.INC_TAB, null, null, () -> this.delegate.incTab());
        return this;
    }

    @Override
    public TokenWriter decTab() {
        this.listener.onTokenWriterWrite(TokenType.DEC_TAB, null, null, () -> this.delegate.decTab());
        return this;
    }

    @Override
    public PrinterHelper getPrinterHelper() {
        return this.delegate.getPrinterHelper();
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public TokenWriter writeSpace() {
        this.listener.onTokenWriterWrite(TokenType.SPACE, " ", null, () -> this.delegate.writeSpace());
        return this;
    }

    public static interface Listener {
        public void onTokenWriterWrite(TokenType var1, String var2, CtComment var3, Runnable var4);
    }
}

