/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.sniper.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import spoon.reflect.code.CtComment;
import spoon.reflect.cu.SourcePositionHolder;
import spoon.reflect.path.CtRole;
import spoon.support.sniper.internal.PrinterEvent;
import spoon.support.sniper.internal.TokenType;

public abstract class TokenPrinterEvent
implements PrinterEvent {
    private final TokenType type;
    private final String token;
    private final CtComment comment;
    private static final Set<String> modifierKeywords = new HashSet<String>(Arrays.asList("public", "protected", "private", "static", "default", "final"));

    public TokenPrinterEvent(TokenType type, String token, CtComment comment) {
        this.type = type;
        this.token = token;
        this.comment = comment;
    }

    @Override
    public CtRole getRole() {
        if (this.type == TokenType.COMMENT) {
            return CtRole.COMMENT;
        }
        if (TokenPrinterEvent.isModifierKeyword(this.type, this.token)) {
            return CtRole.MODIFIER;
        }
        return null;
    }

    @Override
    public @Nullable SourcePositionHolder getElement() {
        return this.comment;
    }

    public @Nullable String getToken() {
        return this.token;
    }

    static boolean isModifierKeyword(TokenType tokenType, String token) {
        return tokenType == TokenType.KEYWORD && modifierKeywords.contains(token);
    }

    public boolean isWhitespace() {
        return this.type.isWhiteSpace();
    }

    public TokenType getType() {
        return this.type;
    }

    public String toString() {
        return this.type.name() + ": '" + this.token + "'";
    }

    public TokenType getTokenType() {
        return this.type;
    }
}

