/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.sniper.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.path.CtRole;
import spoon.support.sniper.internal.CollectionSourceFragment;
import spoon.support.sniper.internal.ElementSourceFragment;
import spoon.support.sniper.internal.SourceFragment;
import spoon.support.sniper.internal.TokenSourceFragment;
import spoon.support.sniper.internal.TokenType;

public class IndentationDetector {
    private IndentationDetector() {
    }

    public static Pair<Integer, Boolean> detectIndentation(CtCompilationUnit cu) {
        List<ElementSourceFragment> typeFragments = cu.getOriginalSourceFragment().getGroupedChildrenFragments().stream().filter(fragment -> fragment instanceof CollectionSourceFragment).flatMap(fragment -> IndentationDetector.extractTypeFragments((CollectionSourceFragment)fragment).stream()).collect(Collectors.toList());
        return IndentationDetector.detectIndentation(typeFragments);
    }

    private static Pair<Integer, Boolean> detectIndentation(List<ElementSourceFragment> topLevelTypeFragments) {
        ArrayList<String> wsPrecedingTypeMembers = new ArrayList<String>();
        for (ElementSourceFragment typeSource : topLevelTypeFragments) {
            assert (typeSource.getRoleInParent() == CtRole.DECLARED_TYPE);
            List<SourceFragment> children = typeSource.getChildrenFragments();
            for (int i = 0; i < children.size() - 1; ++i) {
                if (!(children.get(i) instanceof TokenSourceFragment) || !(children.get(i + 1) instanceof ElementSourceFragment)) continue;
                TokenSourceFragment cur = (TokenSourceFragment)children.get(i);
                ElementSourceFragment next = (ElementSourceFragment)children.get(i + 1);
                if (cur.getType() != TokenType.SPACE || next.getRoleInParent() != CtRole.TYPE_MEMBER) continue;
                wsPrecedingTypeMembers.add(cur.getSourceCode().replace("\n", ""));
            }
        }
        return IndentationDetector.guessIndentationStyle(wsPrecedingTypeMembers);
    }

    private static Pair<Integer, Boolean> guessIndentationStyle(List<String> wsPrecedingTypeMembers) {
        double avgIndent = wsPrecedingTypeMembers.stream().map(String::length).map(Double::valueOf).reduce((acc, next) -> (acc + next) / 2.0).orElse(1.0);
        double diff1 = Math.abs(1.0 - avgIndent);
        double diff2 = Math.abs(2.0 - avgIndent);
        double diff4 = Math.abs(4.0 - avgIndent);
        int indentationSize = diff1 > diff2 ? (diff2 > diff4 ? 4 : 2) : 1;
        boolean usesTabs = (double)wsPrecedingTypeMembers.stream().filter(s -> s.contains("\t")).count() >= (double)wsPrecedingTypeMembers.size() / 2.0;
        return Pair.of((Object)indentationSize, (Object)usesTabs);
    }

    private static List<ElementSourceFragment> extractTypeFragments(CollectionSourceFragment collection) {
        return collection.getItems().stream().filter(fragment -> fragment instanceof ElementSourceFragment).map(fragment -> (ElementSourceFragment)fragment).filter(fragment -> fragment.getRoleInParent() == CtRole.DECLARED_TYPE).collect(Collectors.toList());
    }
}

