/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.DerivedProperty;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.adaption.TypeAdaptor;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.reference.CtReferenceImpl;

public class CtTypeReferenceImpl<T>
extends CtReferenceImpl
implements CtTypeReference<T> {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<Map<String, Class<?>>> classByQName = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<ClassLoader> lastClassLoader = new ThreadLocal();
    @MetamodelPropertyField(role={CtRole.TYPE_ARGUMENT})
    List<CtTypeReference<?>> actualTypeArguments = CtElementImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.DECLARING_TYPE})
    CtTypeReference<?> declaringType;
    @MetamodelPropertyField(role={CtRole.PACKAGE_REF})
    private CtPackageReference pack;
    @MetamodelPropertyField(role={CtRole.IS_SHADOW})
    boolean isShadow;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtTypeReference(this);
    }

    @Override
    public CtTypeReference<?> box() {
        if (!this.isPrimitive()) {
            return this;
        }
        if ("int".equals(this.getSimpleName())) {
            return this.getFactory().Type().createReference(Integer.class);
        }
        if ("float".equals(this.getSimpleName())) {
            return this.getFactory().Type().createReference(Float.class);
        }
        if ("long".equals(this.getSimpleName())) {
            return this.getFactory().Type().createReference(Long.class);
        }
        if ("char".equals(this.getSimpleName())) {
            return this.getFactory().Type().createReference(Character.class);
        }
        if ("double".equals(this.getSimpleName())) {
            return this.getFactory().Type().createReference(Double.class);
        }
        if ("boolean".equals(this.getSimpleName())) {
            return this.getFactory().Type().createReference(Boolean.class);
        }
        if ("short".equals(this.getSimpleName())) {
            return this.getFactory().Type().createReference(Short.class);
        }
        if ("byte".equals(this.getSimpleName())) {
            return this.getFactory().Type().createReference(Byte.class);
        }
        if ("void".equals(this.getSimpleName())) {
            return this.getFactory().Type().createReference(Void.class);
        }
        return this;
    }

    @Override
    public Class<T> getActualClass() {
        return this.getPrimitiveType(this).orElseGet(this::findClass);
    }

    private Optional<Class<T>> getPrimitiveType(CtTypeReference<?> typeReference) {
        switch (typeReference.getSimpleName()) {
            case "boolean": {
                return Optional.of(Boolean.TYPE);
            }
            case "byte": {
                return Optional.of(Byte.TYPE);
            }
            case "double": {
                return Optional.of(Double.TYPE);
            }
            case "int": {
                return Optional.of(Integer.TYPE);
            }
            case "short": {
                return Optional.of(Short.TYPE);
            }
            case "char": {
                return Optional.of(Character.TYPE);
            }
            case "long": {
                return Optional.of(Long.TYPE);
            }
            case "float": {
                return Optional.of(Float.TYPE);
            }
            case "void": {
                return Optional.of(Void.TYPE);
            }
        }
        return Optional.empty();
    }

    protected Class<T> findClass() {
        CtTypeReference<T> typeReference = this;
        if (this.isArray()) {
            CtTypeReference componentTypeReference = this.convertToComponentType();
            if (componentTypeReference.isPrimitive()) {
                return this.getPrimitiveType(componentTypeReference).map(this::asArrayTypeWithOurDimensions).orElseThrow(() -> new SpoonException("Cant find primitive type: " + componentTypeReference));
            }
            typeReference = componentTypeReference;
        }
        Class<T> actualClass = this.getClassFromThreadLocalCacheOrLoad(typeReference);
        return this.isArray() ? this.asArrayTypeWithOurDimensions(actualClass) : actualClass;
    }

    private Class<T> getClassFromThreadLocalCacheOrLoad(CtTypeReference<?> typeReference) {
        ClassLoader classLoader = this.getFactory().getEnvironment().getInputClassLoader();
        this.checkCacheIntegrity(classLoader);
        String qualifiedName = typeReference.getQualifiedName();
        return classByQName.get().computeIfAbsent(qualifiedName, key -> this.loadClassWithQName(classLoader, qualifiedName));
    }

    private CtTypeReference<T> convertToComponentType() {
        if (!this.getQualifiedName().contains("[")) {
            return this;
        }
        return this.getFactory().createReference(this.getQualifiedName().substring(0, this.getQualifiedName().indexOf("[")));
    }

    private Class<?> loadClassWithQName(ClassLoader classLoader, String qualifiedName) {
        try {
            return classLoader.loadClass(qualifiedName);
        }
        catch (Throwable e) {
            throw new SpoonClassNotFoundException("cannot load class: " + qualifiedName, e);
        }
    }

    private void checkCacheIntegrity(ClassLoader classLoader) {
        if (classLoader != lastClassLoader.get()) {
            classByQName.get().clear();
            lastClassLoader.set(classLoader);
        }
    }

    private <R> Class<R> asArrayTypeWithOurDimensions(Class<R> clazz) {
        String simpleName = this.getSimpleName();
        int dimensionCount = (simpleName.length() - simpleName.indexOf(91)) / 2;
        int[] dimensions = new int[dimensionCount];
        return Array.newInstance(clazz, dimensions).getClass();
    }

    @Override
    public List<CtTypeReference<?>> getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    protected AnnotatedElement getActualAnnotatedElement() {
        return this.getActualClass();
    }

    @Override
    public CtType<T> getDeclaration() {
        return this.getFactory().Type().get(this.getQualifiedName());
    }

    @Override
    public CtType<T> getTypeDeclaration() {
        CtType t = this.getFactory().Type().get(this.getQualifiedName());
        if (t != null) {
            return t;
        }
        try {
            return this.getFactory().Type().get(this.getActualClass());
        }
        catch (SpoonClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public CtPackageReference getPackage() {
        return this.pack;
    }

    @Override
    public String getQualifiedName() {
        if (this.getDeclaringType() != null) {
            return this.getDeclaringType().getQualifiedName() + "$" + this.getSimpleName();
        }
        if (this.getPackage() != null && !this.getPackage().isUnnamedPackage()) {
            return this.getPackage().getSimpleName() + "." + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    @Override
    public boolean isPrimitive() {
        return this.getPrimitiveType(this).isPresent();
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        if (type instanceof CtTypeParameterReference) {
            return false;
        }
        if ("<nulltype>".equals(this.getSimpleName()) || "<nulltype>".equals(type.getSimpleName())) {
            return false;
        }
        if (this.isPrimitive() || type.isPrimitive()) {
            return this.equals(type);
        }
        if (this instanceof CtArrayTypeReference) {
            if (type instanceof CtArrayTypeReference) {
                return ((CtArrayTypeReference)((Object)this)).getComponentType().isSubtypeOf(((CtArrayTypeReference)type).getComponentType());
            }
            if (Array.class.getName().equals(type.getQualifiedName())) {
                return true;
            }
        }
        if (Object.class.getName().equals(type.getQualifiedName())) {
            return true;
        }
        return new TypeAdaptor(this).isSubtypeOf(type);
    }

    private boolean isImplementationOf(CtTypeReference<?> type) {
        for (CtTypeReference<Object> impl = this; impl != null; impl = impl.getDeclaringType()) {
            if (!impl.isSubtypeOf(type)) continue;
            return true;
        }
        return false;
    }

    public <C extends CtActualTypeContainer> C setActualTypeArguments(List<? extends CtTypeReference<?>> actualTypeArguments) {
        if (actualTypeArguments == null || actualTypeArguments.isEmpty()) {
            this.actualTypeArguments = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.actualTypeArguments == CtElementImpl.emptyList()) {
            this.actualTypeArguments = new ArrayList(2);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.TYPE_ARGUMENT, this.actualTypeArguments, new ArrayList(this.actualTypeArguments));
        this.actualTypeArguments.clear();
        for (CtTypeReference<?> actualTypeArgument : actualTypeArguments) {
            this.addActualTypeArgument(actualTypeArgument);
        }
        return (C)this;
    }

    @Override
    public <C extends CtTypeReference<T>> C setDeclaringType(CtTypeReference<?> declaringType) {
        if (declaringType != null) {
            declaringType.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.DECLARING_TYPE, declaringType, this.declaringType);
        this.declaringType = declaringType;
        return (C)this;
    }

    @Override
    public <C extends CtTypeReference<T>> C setPackage(CtPackageReference pack) {
        if (pack != null) {
            pack.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.PACKAGE_REF, pack, this.pack);
        this.pack = pack;
        return (C)this;
    }

    @Override
    public CtIntersectionTypeReference<T> asCtIntersectionTypeReference() {
        return (CtIntersectionTypeReference)((Object)this);
    }

    @Override
    public CtTypeReference<?> unbox() {
        Class<T> actualClass;
        if (this.isPrimitive()) {
            return this;
        }
        try {
            actualClass = this.getActualClass();
        }
        catch (SpoonClassNotFoundException e) {
            return this;
        }
        if (actualClass == Integer.class) {
            return this.getFactory().Type().createReference(Integer.TYPE);
        }
        if (actualClass == Float.class) {
            return this.getFactory().Type().createReference(Float.TYPE);
        }
        if (actualClass == Long.class) {
            return this.getFactory().Type().createReference(Long.TYPE);
        }
        if (actualClass == Character.class) {
            return this.getFactory().Type().createReference(Character.TYPE);
        }
        if (actualClass == Double.class) {
            return this.getFactory().Type().createReference(Double.TYPE);
        }
        if (actualClass == Boolean.class) {
            return this.getFactory().Type().createReference(Boolean.TYPE);
        }
        if (actualClass == Short.class) {
            return this.getFactory().Type().createReference(Short.TYPE);
        }
        if (actualClass == Byte.class) {
            return this.getFactory().Type().createReference(Byte.TYPE);
        }
        if (actualClass == Void.class) {
            return this.getFactory().Type().createReference(Void.TYPE);
        }
        return this;
    }

    @Override
    public Collection<CtFieldReference<?>> getDeclaredFields() {
        CtType<T> t = this.getTypeDeclaration();
        if (t != null) {
            return t.getDeclaredFields();
        }
        return Collections.emptyList();
    }

    private void handleParentNotFound(SpoonClassNotFoundException cnfe) {
        String msg = "cannot load class: " + this.getQualifiedName() + " with class loader " + Thread.currentThread().getContextClassLoader();
        if (!this.getFactory().getEnvironment().getNoClasspath()) {
            throw cnfe;
        }
        Launcher.LOGGER.warn(msg);
    }

    @Override
    public CtFieldReference<?> getDeclaredField(String name) {
        if (name == null) {
            return null;
        }
        CtType<T> t = this.getTypeDeclaration();
        if (t != null) {
            return t.getDeclaredField(name);
        }
        return null;
    }

    @Override
    public CtFieldReference<?> getDeclaredOrInheritedField(String fieldName) {
        CtType<T> t = this.getTypeDeclaration();
        if (t != null) {
            return t.getDeclaredOrInheritedField(fieldName);
        }
        return null;
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        CtType<T> t = this.getTypeDeclaration();
        if (t == null) {
            if (this.getFactory().getEnvironment().getNoClasspath()) {
                return Collections.emptyList();
            }
            throw new SpoonException("Type not found " + this.getQualifiedName());
        }
        return t.getDeclaredExecutables();
    }

    @Override
    public Collection<CtFieldReference<?>> getAllFields() {
        CtType<T> t = this.getTypeDeclaration();
        if (t != null) {
            return t.getAllFields();
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<CtExecutableReference<?>> getAllExecutables() {
        ArrayList l = new ArrayList();
        CtType<T> t = this.getTypeDeclaration();
        if (t != null) {
            l.addAll(t.getAllExecutables());
        }
        return l;
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        CtType<T> t = this.getTypeDeclaration();
        if (t != null) {
            return t.getModifiers();
        }
        if (this.getFactory().getEnvironment().getNoClasspath()) {
            return Collections.emptySet();
        }
        throw new SpoonClassNotFoundException(this.getQualifiedName() + " cannot be found");
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        CtType<T> t = this.getTypeDeclaration();
        if (t != null) {
            return t.getSuperclass();
        }
        return null;
    }

    @Override
    public Set<CtTypeReference<?>> getSuperInterfaces() {
        CtType<T> t = this.getTypeDeclaration();
        if (t != null) {
            return Collections.unmodifiableSet(t.getSuperInterfaces());
        }
        if (this.getFactory().getEnvironment().getNoClasspath()) {
            return Collections.emptySet();
        }
        throw new SpoonClassNotFoundException(this.getQualifiedName() + " cannot be found");
    }

    @Override
    public boolean isAnonymous() {
        try {
            Integer.parseInt(this.getSimpleName());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isLocalType() {
        CtElement declaration = this.getDeclaration();
        if (declaration != null) {
            return declaration.isLocalType();
        }
        String name = this.getSimpleName();
        if (name.isEmpty() || !Character.isDigit(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isDigit(name.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public <C extends CtActualTypeContainer> C addActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        if (actualTypeArgument == null) {
            return (C)this;
        }
        if (this.actualTypeArguments == CtElementImpl.emptyList()) {
            this.actualTypeArguments = new ArrayList(2);
        }
        actualTypeArgument.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.TYPE_ARGUMENT, this.actualTypeArguments, actualTypeArgument);
        this.actualTypeArguments.add(actualTypeArgument);
        return (C)this;
    }

    @Override
    public boolean removeActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        if (this.actualTypeArguments == CtElementImpl.emptyList()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.TYPE_ARGUMENT, this.actualTypeArguments, this.actualTypeArguments.indexOf(actualTypeArgument), actualTypeArgument);
        return this.actualTypeArguments.remove(actualTypeArgument);
    }

    @Override
    public boolean isClass() {
        CtType<T> t = this.getTypeDeclaration();
        if (t == null) {
            if (this.getFactory().getEnvironment().getNoClasspath()) {
                return false;
            }
            throw new SpoonClassNotFoundException(this.getQualifiedName() + " cannot be found");
        }
        return t.isClass();
    }

    @Override
    public boolean isInterface() {
        CtType<T> t = this.getTypeDeclaration();
        if (t == null) {
            if (this.getFactory().getEnvironment().getNoClasspath()) {
                return false;
            }
            throw new SpoonClassNotFoundException(this.getQualifiedName() + " cannot be found");
        }
        return t.isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        CtType<T> t = this.getTypeDeclaration();
        if (t == null) {
            if (this.getFactory().getEnvironment().getNoClasspath()) {
                return false;
            }
            throw new SpoonClassNotFoundException(this.getQualifiedName() + " cannot be found");
        }
        return t.isAnnotationType();
    }

    @Override
    public boolean isEnum() {
        CtType<T> t = this.getTypeDeclaration();
        if (t == null) {
            if (this.getFactory().getEnvironment().getNoClasspath()) {
                return false;
            }
            throw new SpoonClassNotFoundException(this.getQualifiedName() + " cannot be found");
        }
        return t.isEnum();
    }

    @Override
    public boolean canAccess(CtTypeReference<?> type) {
        try {
            if (type == null) {
                return true;
            }
            if (type.getTypeDeclaration() == null) {
                return true;
            }
            Set<ModifierKind> modifiers = type.getModifiers();
            if (modifiers.contains((Object)ModifierKind.PUBLIC)) {
                return true;
            }
            if (modifiers.contains((Object)ModifierKind.PROTECTED)) {
                CtTypeReference<?> declaringType = type.getDeclaringType();
                if (declaringType == null) {
                    throw new SpoonException("The protected class " + type.getQualifiedName() + " has no declaring class.");
                }
                if (this.isImplementationOf(declaringType)) {
                    return true;
                }
                return this.isInSamePackage(type);
            }
            if (modifiers.contains((Object)ModifierKind.PRIVATE)) {
                return type.getTopLevelType().getQualifiedName().equals(this.getTopLevelType().getQualifiedName());
            }
            CtTypeReference<?> declaringTypeRef = type.getDeclaringType();
            if (declaringTypeRef != null && declaringTypeRef.isInterface()) {
                return true;
            }
            return this.isInSamePackage(type);
        }
        catch (SpoonClassNotFoundException e) {
            this.handleParentNotFound(e);
            return true;
        }
    }

    @Override
    public boolean canAccess(CtTypeMember typeMember) {
        CtType<?> declaringType = typeMember.getDeclaringType();
        if (declaringType == null) {
            return true;
        }
        CtReference declaringTypeRef = declaringType.getReference();
        if (!this.canAccess((CtTypeReference<?>)declaringTypeRef)) {
            return false;
        }
        Set<ModifierKind> modifiers = typeMember.getModifiers();
        if (modifiers.contains((Object)ModifierKind.PUBLIC)) {
            return true;
        }
        if (modifiers.contains((Object)ModifierKind.PROTECTED)) {
            if (this.isImplementationOf((CtTypeReference<?>)declaringTypeRef)) {
                return true;
            }
            return this.isInSamePackage((CtTypeReference<?>)declaringTypeRef);
        }
        if (modifiers.contains((Object)ModifierKind.PRIVATE)) {
            return declaringType.getTopLevelType().getQualifiedName().equals(this.getTopLevelType().getQualifiedName());
        }
        CtType<?> declaringTypeDeclaringType = declaringType.getDeclaringType();
        if (declaringTypeDeclaringType != null && declaringTypeDeclaringType.isInterface()) {
            return true;
        }
        return this.isInSamePackage((CtTypeReference<?>)declaringTypeRef);
    }

    private boolean isInSamePackage(CtTypeReference<?> type) {
        CtPackageReference thisPackage = this.getTopLevelType().getPackage();
        CtPackageReference otherPackage = type.getTopLevelType().getPackage();
        if (thisPackage == null || otherPackage == null) {
            return true;
        }
        return thisPackage.getQualifiedName().equals(otherPackage.getQualifiedName());
    }

    @Override
    public CtTypeReference<?> getTopLevelType() {
        CtTypeReference<Object> type = this;
        CtTypeReference<?> parentType;
        while ((parentType = type.getDeclaringType()) != null) {
            type = parentType;
        }
        return type;
    }

    @Override
    public CtTypeReference<?> getAccessType() {
        CtTypeReference<?> declType = this.getDeclaringType();
        if (declType == null) {
            throw new SpoonException("The declaring type is expected, but " + this.getQualifiedName() + " is top level type");
        }
        CtType contextType = this.getParent(CtType.class);
        if (contextType == null) {
            return declType;
        }
        CtTypeReference<?> contextTypeRef = contextType.getReference();
        if (contextTypeRef != null && !contextTypeRef.canAccess(declType)) {
            CtTypeReference<?> visibleDeclType = null;
            for (CtTypeReference<?> type = contextTypeRef; visibleDeclType == null && type != null; type = type.getDeclaringType()) {
                visibleDeclType = CtTypeReferenceImpl.getLastVisibleSuperClassExtendingFrom(type, declType);
                if (visibleDeclType == null) continue;
                CtTypeReferenceImpl.applyActualTypeArguments(visibleDeclType, declType);
                break;
            }
            declType = visibleDeclType;
        }
        if (declType == null) {
            throw new SpoonException("Cannot compute access path to type: " + this.getQualifiedName() + " in context of type: " + contextType.getQualifiedName());
        }
        return declType;
    }

    private static void applyActualTypeArguments(CtTypeReference<?> targetTypeRef, CtTypeReference<?> sourceTypeRef) {
        CtTypeReference<?> targetDeclType = targetTypeRef.getDeclaringType();
        CtTypeReference<?> sourceDeclType = sourceTypeRef.getDeclaringType();
        if (targetDeclType != null && sourceDeclType != null && targetDeclType.isSubtypeOf(sourceDeclType)) {
            CtTypeReferenceImpl.applyActualTypeArguments(targetDeclType, sourceDeclType);
        }
        if (!targetTypeRef.isSubtypeOf(sourceTypeRef)) {
            throw new SpoonException("Invalid arguments. targetTypeRef " + targetTypeRef.getQualifiedName() + " must be a sub type of sourceTypeRef " + sourceTypeRef.getQualifiedName());
        }
        ArrayList<CtReference> newTypeArgs = new ArrayList<CtReference>();
        for (CtTypeReference<?> l_tr : sourceTypeRef.getActualTypeArguments()) {
            newTypeArgs.add(l_tr.clone());
        }
        targetTypeRef.setActualTypeArguments(newTypeArgs);
    }

    private static CtTypeReference<?> getLastVisibleSuperClassExtendingFrom(CtTypeReference<?> sourceType, CtTypeReference<?> targetType) {
        String targetQN = targetType.getQualifiedName();
        CtTypeReference<?> adept = sourceType;
        CtTypeReference<?> type = sourceType;
        while (!targetQN.equals(type.getQualifiedName())) {
            if ((type = type.getSuperclass()) == null) {
                return null;
            }
            if (!sourceType.canAccess(type)) continue;
            adept = type;
        }
        return adept;
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_SHADOW, isShadow, this.isShadow);
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtTypeReference<T> clone() {
        return (CtTypeReference)super.clone();
    }

    @Override
    public CtTypeParameter getTypeParameterDeclaration() {
        CtNamedElement exec;
        CtElement parent = this.getParent();
        if (parent instanceof CtTypeReference) {
            CtType t = ((CtTypeReference)parent).getTypeDeclaration();
            return this.findTypeParamDeclarationByPosition(t, ((CtTypeReference)parent).getActualTypeArguments().indexOf(this));
        }
        if (parent instanceof CtExecutableReference && ((exec = ((CtExecutableReference)parent).getExecutableDeclaration()) instanceof CtMethod || exec instanceof CtConstructor)) {
            int idx = ((CtExecutableReference)parent).getActualTypeArguments().indexOf(this);
            return idx >= 0 ? this.findTypeParamDeclarationByPosition((CtFormalTypeDeclarer)exec, idx) : null;
        }
        if (parent instanceof CtFormalTypeDeclarer && ((exec = (CtFormalTypeDeclarer)parent) instanceof CtMethod || exec instanceof CtConstructor)) {
            for (CtTypeParameter typeParam : exec.getFormalCtTypeParameters()) {
                if (!typeParam.getSimpleName().equals(this.getSimpleName())) continue;
                return typeParam;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isGenerics() {
        if (this.getDeclaration() instanceof CtTypeParameter) {
            return true;
        }
        for (CtTypeReference<?> ref : this.getActualTypeArguments()) {
            if (!ref.isGenerics()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isParameterized() {
        return !this.getActualTypeArguments().isEmpty();
    }

    private CtTypeParameter findTypeParamDeclarationByPosition(CtFormalTypeDeclarer type, int position) {
        return type.getFormalCtTypeParameters().get(position);
    }

    @Override
    public CtTypeReference<?> getTypeErasure() {
        if (this.getActualTypeArguments().isEmpty()) {
            return this;
        }
        CtReference erasedRef = this.clone();
        erasedRef.getActualTypeArguments().clear();
        return erasedRef;
    }

    @Override
    @DerivedProperty
    public boolean isSimplyQualified() {
        if (this.pack != null) {
            return this.pack.isImplicit();
        }
        if (this.declaringType != null) {
            return this.declaringType.isImplicit();
        }
        return false;
    }

    @Override
    @DerivedProperty
    public CtTypeReferenceImpl<T> setSimplyQualified(boolean isSimplyQualified) {
        if (this.pack != null) {
            this.pack.setImplicit(isSimplyQualified);
        } else if (this.declaringType != null) {
            this.declaringType.setImplicit(isSimplyQualified);
        }
        return this;
    }

    @Override
    public boolean isArray() {
        return this.getSimpleName().contains("[");
    }
}

