/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spoon.JLSViolation;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtComment;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.FactoryImpl;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtReference;
import spoon.support.UnsettableProperty;
import spoon.support.reflect.declaration.CtElementImpl;

public abstract class CtReferenceImpl
extends CtElementImpl
implements CtReference {
    private static final long serialVersionUID = 1L;
    private static final Collection<String> baseKeywords = CtReferenceImpl.fillWithBaseKeywords();
    private static final Collection<String> java2Keywords = Collections.singleton("strictfp");
    private static final Collection<String> java4Keywords = Collections.singleton("assert");
    private static final Collection<String> java5Keywords = Collections.singleton("enum");
    private static final Collection<String> java9Keywords = Collections.singleton("_");
    @MetamodelPropertyField(role={CtRole.NAME})
    protected String simplename = "";

    protected abstract AnnotatedElement getActualAnnotatedElement();

    @Override
    public String getSimpleName() {
        return this.simplename;
    }

    @Override
    public <T extends CtReference> T setSimpleName(String simplename) {
        Factory factory = this.getFactory();
        this.checkIdentifierForJLSCorrectness(simplename);
        if (factory == null) {
            this.simplename = simplename;
            return (T)this;
        }
        if (factory instanceof FactoryImpl) {
            simplename = ((FactoryImpl)factory).dedup(simplename);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.NAME, simplename, this.simplename);
        this.simplename = simplename;
        return (T)this;
    }

    @Override
    @UnsettableProperty
    public <E extends CtElement> E setComments(List<CtComment> comments) {
        return (E)this;
    }

    @Override
    public CtReference clone() {
        return (CtReference)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CtReference) {
            CtReference ref = (CtReference)o;
            if (!Objects.equals(this.getSimpleName(), ref.getSimpleName())) {
                return false;
            }
            return super.equals(o);
        }
        return false;
    }

    private void checkIdentifierForJLSCorrectness(String simplename) {
        if (CtReferenceImpl.isSpecialType(simplename)) {
            return;
        }
        if (!this.checkAll(simplename)) {
            JLSViolation.throwIfSyntaxErrorsAreNotIgnored(this, "Not allowed javaletter or keyword in identifier found. See JLS for correct identifier. Identifier: " + simplename);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkAll(String name) {
        for (i = 0; i < name.length() && Character.isDigit(name.charAt(i)); ++i) {
        }
        start = i;
        anything = false;
        expectNext = '\u0000';
        while (i < name.length()) {
            if (expectNext == '\u0000') ** GOTO lbl-1000
            if (name.charAt(i) != expectNext) {
                return false;
            }
            if (name.charAt(i) == expectNext) {
                expectNext = '\u0000';
            } else lbl-1000:
            // 2 sources

            {
                switch (name.charAt(i)) {
                    case '.': 
                    case '<': 
                    case '>': {
                        if (this.isKeyword(name.substring(start, i))) {
                            return false;
                        }
                        start = i + 1;
                        break;
                    }
                    case '[': {
                        expectNext = ']';
                        break;
                    }
                    default: {
                        if ((start != i || Character.isJavaIdentifierStart(name.charAt(i))) && Character.isJavaIdentifierPart(name.charAt(i))) break;
                        return false;
                    }
                }
            }
            ++i;
        }
        if (expectNext != '\u0000') {
            return false;
        }
        if (start < name.length()) {
            return this.isKeyword(name.substring(start)) == false;
        }
        return true;
    }

    private static boolean isSpecialType(String identifier) {
        return identifier.isEmpty() || "?".equals(identifier) || identifier.startsWith("<") && identifier.endsWith(">");
    }

    private boolean isKeyword(String simplename) {
        int complianceLevel = this.getFactory().getEnvironment().getComplianceLevel();
        return baseKeywords.contains(simplename) || complianceLevel >= 2 && java2Keywords.contains(simplename) || complianceLevel >= 4 && java4Keywords.contains(simplename) || complianceLevel >= 5 && java5Keywords.contains(simplename) || complianceLevel >= 9 && java9Keywords.contains(simplename);
    }

    private static Collection<String> fillWithBaseKeywords() {
        return Stream.of("abstract", "continue", "for", "new", "switch", "default", "if", "package", "synchronized", "do", "goto", "private", "this", "break", "implements", "protected", "throw", "else", "import", "public", "throws", "case", "instanceof", "return", "transient", "catch", "extends", "try", "final", "interface", "static", "finally", "volatile", "const", "native", "super", "while").collect(Collectors.toCollection(HashSet::new));
    }
}

