/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.reference.CtTypeReferenceImpl;

public class CtIntersectionTypeReferenceImpl<T>
extends CtTypeReferenceImpl<T>
implements CtIntersectionTypeReference<T> {
    @MetamodelPropertyField(role={CtRole.BOUND})
    List<CtTypeReference<?>> bounds = CtElementImpl.emptyList();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtIntersectionTypeReference(this);
    }

    @Override
    public List<CtTypeReference<?>> getBounds() {
        return Collections.unmodifiableList(this.bounds);
    }

    @Override
    public <C extends CtIntersectionTypeReference> C setBounds(List<CtTypeReference<?>> bounds) {
        if (bounds == null || bounds.isEmpty()) {
            this.bounds = CtElementImpl.emptyList();
            return (C)this;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.BOUND, this.bounds, new ArrayList(this.bounds));
        this.bounds.clear();
        for (CtTypeReference<?> bound : bounds) {
            this.addBound(bound);
        }
        return (C)this;
    }

    @Override
    public <C extends CtIntersectionTypeReference> C addBound(CtTypeReference<?> bound) {
        if (bound == null) {
            return (C)this;
        }
        if (this.bounds == CtElementImpl.emptyList()) {
            this.bounds = new ArrayList();
        }
        if (!this.bounds.contains(bound)) {
            bound.setParent(this);
            this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.BOUND, this.bounds, bound);
            this.bounds.add(bound);
        }
        return (C)this;
    }

    @Override
    public boolean removeBound(CtTypeReference<?> bound) {
        if (this.bounds == CtElementImpl.emptyList()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.BOUND, this.bounds, this.bounds.indexOf(bound), bound);
        return this.bounds.remove(bound);
    }

    @Override
    public CtTypeReference<?> getTypeErasure() {
        if (this.bounds == null || this.bounds.isEmpty()) {
            return this.getFactory().Type().objectType();
        }
        return this.bounds.get(0).getTypeErasure();
    }

    @Override
    public CtIntersectionTypeReference<T> clone() {
        return (CtIntersectionTypeReference)super.clone();
    }

    @Override
    public boolean isSimplyQualified() {
        if (this.bounds != null && this.bounds.size() > 0) {
            return this.bounds.get(0).isSimplyQualified();
        }
        return false;
    }

    @Override
    public CtIntersectionTypeReferenceImpl<T> setSimplyQualified(boolean isSimplyQualified) {
        if (this.bounds != null && this.bounds.size() > 0) {
            this.bounds.get(0).setSimplyQualified(isSimplyQualified);
        }
        return this;
    }
}

