/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.eval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import spoon.SpoonException;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.eval.PartialEvaluator;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.OperatorHelper;
import spoon.support.util.RtHelper;

public class VisitorPartialEvaluator
extends CtScanner
implements PartialEvaluator {
    boolean flowEnded = false;
    CtElement result;

    static Number convert(CtTypeReference<?> type, Number n) {
        if (type.getActualClass() == Integer.TYPE || type.getActualClass() == Integer.class) {
            return n.intValue();
        }
        if (type.getActualClass() == Byte.TYPE || type.getActualClass() == Byte.class) {
            return n.byteValue();
        }
        if (type.getActualClass() == Long.TYPE || type.getActualClass() == Long.class) {
            return n.longValue();
        }
        if (type.getActualClass() == Float.TYPE || type.getActualClass() == Float.class) {
            return Float.valueOf(n.floatValue());
        }
        if (type.getActualClass() == Short.TYPE || type.getActualClass() == Short.class) {
            return n.shortValue();
        }
        if (type.getActualClass() == Double.TYPE || type.getActualClass() == Double.class) {
            return n.doubleValue();
        }
        return n;
    }

    @Override
    protected void exit(CtElement e) {
        this.result = null;
    }

    @Override
    public <R extends CtElement> R evaluate(R element) {
        if (element == null) {
            return null;
        }
        element.accept(this);
        if (this.result != null) {
            CtElement r = this.result;
            this.result = null;
            if (element.isParentInitialized()) {
                r.setParent(element.getParent());
            }
            return (R)r;
        }
        return (R)element.clone();
    }

    void setResult(CtElement element) {
        this.result = element;
    }

    private static <T, R> CtLiteral<R> promoteLiteral(CtTypeReference<R> type, CtLiteral<T> literal) {
        CtExpression result = literal.clone();
        result.setType((CtTypeReference)type.clone());
        if (literal.getType().unbox().equals(type.unbox())) {
            result.setValue(literal.getValue());
            return result;
        }
        if (type.equals(type.getFactory().Type().createReference(String.class)) && literal.getType().isPrimitive()) {
            result.setValue(literal.getValue().toString());
            return result;
        }
        if (type.unbox().isPrimitive()) {
            if (literal.getValue() instanceof Number) {
                result.setValue(VisitorPartialEvaluator.convert(type, (Number)literal.getValue()));
            } else if (literal.getValue() instanceof Character) {
                result.setValue(VisitorPartialEvaluator.convert(type, (int)((Character)literal.getValue()).charValue()));
            }
        } else {
            result.setValue(type.getActualClass().cast(literal.getValue()));
        }
        return result;
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        CtExpression<?> left = this.evaluate(operator.getLeftHandOperand());
        CtExpression<?> right = this.evaluate(operator.getRightHandOperand());
        if (left instanceof CtLiteral && right instanceof CtLiteral) {
            Object value;
            CtLiteral leftLiteral = (CtLiteral)left;
            CtLiteral rightLiteral = (CtLiteral)right;
            CtTypeReference promotedType = OperatorHelper.getPromotedType(operator.getKind(), leftLiteral, rightLiteral).orElse(null);
            if (promotedType == null) {
                return;
            }
            leftLiteral = VisitorPartialEvaluator.promoteLiteral(promotedType, leftLiteral);
            rightLiteral = VisitorPartialEvaluator.promoteLiteral(promotedType, rightLiteral);
            Object leftObject = leftLiteral.getValue();
            Object rightObject = rightLiteral.getValue();
            switch (operator.getKind()) {
                case AND: {
                    value = (Boolean)leftObject != false && (Boolean)rightObject != false;
                    break;
                }
                case OR: {
                    value = (Boolean)leftObject != false || (Boolean)rightObject != false;
                    break;
                }
                case EQ: {
                    if (leftObject == null) {
                        value = leftObject == rightObject;
                        break;
                    }
                    value = leftObject.equals(rightObject);
                    break;
                }
                case NE: {
                    if (leftObject == null) {
                        value = leftObject != rightObject;
                        break;
                    }
                    value = !leftObject.equals(rightObject);
                    break;
                }
                case GE: {
                    value = ((Number)leftObject).doubleValue() >= ((Number)rightObject).doubleValue();
                    break;
                }
                case LE: {
                    value = ((Number)leftObject).doubleValue() <= ((Number)rightObject).doubleValue();
                    break;
                }
                case GT: {
                    value = ((Number)leftObject).doubleValue() > ((Number)rightObject).doubleValue();
                    break;
                }
                case LT: {
                    value = ((Number)leftObject).doubleValue() < ((Number)rightObject).doubleValue();
                    break;
                }
                case MINUS: {
                    value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)leftObject).doubleValue() - ((Number)rightObject).doubleValue());
                    break;
                }
                case MUL: {
                    value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)leftObject).doubleValue() * ((Number)rightObject).doubleValue());
                    break;
                }
                case DIV: {
                    try {
                        if (this.isFloatingType(operator.getType())) {
                            value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)leftObject).doubleValue() / ((Number)rightObject).doubleValue());
                            break;
                        }
                        value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)leftObject).longValue() / ((Number)rightObject).longValue());
                        break;
                    }
                    catch (ArithmeticException exception) {
                        throw new SpoonException(String.format("Expression '%s' evaluates to '%s %s %s' which can not be evaluated", operator, leftObject, OperatorHelper.getOperatorText(operator.getKind()), rightObject), exception);
                    }
                }
                case PLUS: {
                    if (leftObject instanceof String || rightObject instanceof String) {
                        value = "" + leftObject + rightObject;
                        break;
                    }
                    value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)leftObject).doubleValue() + ((Number)rightObject).doubleValue());
                    break;
                }
                case MOD: {
                    value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)leftObject).doubleValue() % ((Number)rightObject).doubleValue());
                    break;
                }
                case BITAND: {
                    if (leftObject instanceof Boolean) {
                        value = (Boolean)leftObject != false && (Boolean)rightObject != false;
                        break;
                    }
                    value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)leftObject).longValue() & ((Number)rightObject).longValue());
                    break;
                }
                case BITOR: {
                    if (leftObject instanceof Boolean) {
                        value = (Boolean)leftObject != false || (Boolean)rightObject != false;
                        break;
                    }
                    value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)leftObject).longValue() | ((Number)rightObject).longValue());
                    break;
                }
                case BITXOR: {
                    if (leftObject instanceof Boolean) {
                        value = (Boolean)leftObject ^ (Boolean)rightObject;
                        break;
                    }
                    value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)leftObject).longValue() ^ ((Number)rightObject).longValue());
                    break;
                }
                case SL: {
                    long rightObjectValue;
                    if (this.isIntegralType(leftObject) && this.isIntegralType(rightObject)) {
                        rightObjectValue = ((Number)rightObject).longValue();
                        if (leftObject instanceof Long) {
                            value = (Long)leftObject << (int)rightObjectValue;
                            break;
                        }
                        value = ((Number)leftObject).intValue() << (int)rightObjectValue;
                        break;
                    }
                    throw new RuntimeException(operator.getKind() + " is only supported for integral types on both sides");
                }
                case SR: {
                    long rightObjectValue;
                    if (this.isIntegralType(leftObject) && this.isIntegralType(rightObject)) {
                        rightObjectValue = ((Number)rightObject).longValue();
                        if (leftObject instanceof Long) {
                            value = (Long)leftObject >> (int)rightObjectValue;
                            break;
                        }
                        value = ((Number)leftObject).intValue() >> (int)rightObjectValue;
                        break;
                    }
                    throw new RuntimeException(operator.getKind() + " is only supported for integral types on both sides");
                }
                case USR: {
                    long rightObjectValue;
                    if (this.isIntegralType(leftObject) && this.isIntegralType(rightObject)) {
                        rightObjectValue = ((Number)rightObject).longValue();
                        if (leftObject instanceof Long) {
                            value = (Long)leftObject >>> (int)rightObjectValue;
                            break;
                        }
                        value = ((Number)leftObject).intValue() >>> (int)rightObjectValue;
                        break;
                    }
                    throw new RuntimeException(operator.getKind() + " is only supported for integral types on both sides");
                }
                default: {
                    throw new RuntimeException("unsupported operator " + operator.getKind());
                }
            }
            CtLiteral<Object> res = operator.getFactory().createLiteral(value);
            res.setType((CtTypeReference)operator.getType().clone());
            this.setResult(res);
        } else if (left instanceof CtLiteral || right instanceof CtLiteral) {
            CtExpression<?> expr;
            CtLiteral literal;
            if (left instanceof CtLiteral) {
                literal = (CtLiteral)left;
                expr = right;
            } else {
                literal = (CtLiteral)right;
                expr = left;
            }
            Object o = literal.getValue();
            switch (operator.getKind()) {
                case AND: {
                    if (((Boolean)o).booleanValue()) {
                        this.setResult(expr);
                    } else {
                        this.setResult(operator.getFactory().createLiteral(false));
                    }
                    return;
                }
                case OR: {
                    if (((Boolean)o).booleanValue()) {
                        this.setResult(operator.getFactory().createLiteral(true));
                    } else {
                        this.setResult(expr);
                    }
                    return;
                }
                case BITOR: {
                    if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                        this.setResult(operator.getFactory().createLiteral(true));
                    }
                    return;
                }
            }
        }
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        CtBlock b = block.getFactory().Core().createBlock();
        for (CtStatement s : block.getStatements()) {
            CtStatement res = this.evaluate(s);
            if (res != null) {
                if (res instanceof CtStatement) {
                    b.addStatement(res);
                } else {
                    b.addStatement(s.clone());
                }
            }
            if (!this.flowEnded) continue;
            break;
        }
        this.setResult(b);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        CtDo w = doLoop.clone();
        w.setLoopingExpression(this.evaluate(doLoop.getLoopingExpression()));
        w.setBody(this.evaluate(doLoop.getBody()));
        this.setResult(w);
    }

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.visitFieldAccess(fieldRead);
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.visitFieldAccess(fieldWrite);
    }

    private <T> void visitFieldAccess(CtFieldAccess<T> fieldAccess) {
        Object target;
        Class<?> actualClass;
        if ("class".equals(fieldAccess.getVariable().getSimpleName()) && (actualClass = fieldAccess.getVariable().getDeclaringType().getActualClass()) != null) {
            CtLiteral<Class<?>> literal = fieldAccess.getFactory().createLiteral(actualClass);
            this.setResult(literal);
            return;
        }
        if ("length".equals(fieldAccess.getVariable().getSimpleName()) && (target = fieldAccess.getTarget()) instanceof CtNewArray) {
            CtNewArray newArr = (CtNewArray)target;
            CtLiteral<Integer> literal = fieldAccess.getFactory().createLiteral(newArr.getElements().size());
            this.setResult(literal);
            return;
        }
        String fieldName = fieldAccess.getVariable().getSimpleName();
        CtType<?> typeDeclaration = fieldAccess.getVariable().getDeclaringType().getTypeDeclaration();
        CtField<Object> f = typeDeclaration != null ? typeDeclaration.getField(fieldName) : fieldAccess.getVariable().getFieldDeclaration();
        if (f != null && f.getModifiers().contains((Object)ModifierKind.FINAL) && !fieldAccess.getVariable().getDeclaringType().isSubtypeOf(fieldAccess.getFactory().Type().createReference(Enum.class))) {
            this.setResult(this.evaluate(f.getDefaultExpression()));
            return;
        }
        this.setResult(fieldAccess.clone());
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        CtVariable f = annotationFieldAccess.getVariable().getDeclaration();
        this.setResult(this.evaluate(f.getDefaultExpression()));
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        CtStatement evaluateStatement;
        List<CtStatement> lst = forLoop.getForInit();
        for (CtStatement s : new ArrayList<CtStatement>(lst)) {
            evaluateStatement = this.evaluate(s);
            if (evaluateStatement == null) continue;
            forLoop.addForInit(evaluateStatement);
        }
        forLoop.setExpression(this.evaluate(forLoop.getExpression()));
        lst = forLoop.getForUpdate();
        for (CtStatement s : new ArrayList<CtStatement>(lst)) {
            evaluateStatement = this.evaluate(s);
            if (evaluateStatement == null) continue;
            forLoop.addForUpdate(evaluateStatement);
        }
        this.setResult(forLoop.clone());
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        CtExpression<Boolean> r = this.evaluate(ifElement.getCondition());
        if (r instanceof CtLiteral) {
            CtLiteral l = (CtLiteral)r;
            if (((Boolean)l.getValue()).booleanValue()) {
                this.setResult((CtElement)this.evaluate((CtElement)ifElement.getThenStatement()));
            } else if (ifElement.getElseStatement() != null) {
                this.setResult((CtElement)this.evaluate((CtElement)ifElement.getElseStatement()));
            } else {
                this.setResult(ifElement.getFactory().Code().createComment("if removed", CtComment.CommentType.INLINE));
            }
        } else {
            CtIf ifRes = ifElement.getFactory().Core().createIf();
            ifRes.setCondition(r);
            boolean thenEnded = false;
            boolean elseEnded = false;
            ifRes.setThenStatement((CtStatement)this.evaluate((CtElement)ifElement.getThenStatement()));
            if (this.flowEnded) {
                thenEnded = true;
                this.flowEnded = false;
            }
            if (ifElement.getElseStatement() != null) {
                ifRes.setElseStatement((CtStatement)this.evaluate((CtElement)ifElement.getElseStatement()));
            }
            if (this.flowEnded) {
                elseEnded = true;
                this.flowEnded = false;
            }
            this.setResult(ifRes);
            if (thenEnded && elseEnded) {
                this.flowEnded = true;
            }
        }
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        CtInvocation i = invocation.getFactory().Core().createInvocation();
        i.setExecutable(invocation.getExecutable());
        i.setTypeCasts(invocation.getTypeCasts());
        boolean constant = true;
        i.setTarget((CtExpression)this.evaluate((CtElement)invocation.getTarget()));
        if (i.getTarget() != null && !(i.getTarget() instanceof CtLiteral)) {
            constant = false;
        }
        for (CtExpression<?> e : invocation.getArguments()) {
            CtExpression<?> re = this.evaluate(e);
            if (!(re instanceof CtLiteral)) {
                constant = false;
            }
            i.addArgument(re);
        }
        if (i.getExecutable().getSimpleName().equals("<init>")) {
            this.setResult(i);
            return;
        }
        if (constant) {
            CtElement executable = invocation.getExecutable().getDeclaration();
            CtType aType = invocation.getParent(CtType.class);
            CtTypeReference<?> execDeclaringType = invocation.getExecutable().getDeclaringType();
            if (executable != null && aType != null && invocation.getType() != null && execDeclaringType != null && execDeclaringType.isSubtypeOf((CtTypeReference<?>)aType.getReference())) {
                CtBlock b = (CtBlock)this.evaluate(executable.getBody());
                this.flowEnded = false;
                CtStatement last = b.getStatements().get(b.getStatements().size() - 1);
                if (last instanceof CtReturn && ((CtReturn)last).getReturnedExpression() instanceof CtLiteral) {
                    this.setResult(((CtReturn)last).getReturnedExpression());
                    return;
                }
            } else {
                try {
                    Object r = RtHelper.invoke(i);
                    if (this.isLiteralType(r)) {
                        CtLiteral l = invocation.getFactory().createLiteral(r);
                        this.setResult(l);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.setResult(i);
    }

    private boolean isIntegralType(Object object) {
        return object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Character;
    }

    private boolean isLiteralType(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return true;
        }
        if (object instanceof Number) {
            return true;
        }
        if (object instanceof Character) {
            return true;
        }
        if (object instanceof Boolean) {
            return true;
        }
        return object instanceof Class;
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        CtNamedElement r = f.clone();
        r.setDefaultExpression(this.evaluate(f.getDefaultExpression()));
        this.setResult(r);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> ctLiteral) {
        CtLiteral result = ctLiteral.clone();
        ArrayList casts = new ArrayList(ctLiteral.getTypeCasts());
        Collections.reverse(casts);
        result.setTypeCasts(new ArrayList());
        for (CtTypeReference ctTypeReference : casts) {
            result = VisitorPartialEvaluator.promoteLiteral(ctTypeReference, result);
        }
        this.setResult(result);
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        CtStatement r = localVariable.clone();
        r.setDefaultExpression(this.evaluate(localVariable.getDefaultExpression()));
        this.setResult(r);
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        CtNamedElement r = catchVariable.clone();
        r.setDefaultExpression(this.evaluate(catchVariable.getDefaultExpression()));
        this.setResult(r);
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        CtReturn<R> r = returnStatement.getFactory().Core().createReturn();
        r.setReturnedExpression(this.evaluate(returnStatement.getReturnedExpression()));
        this.setResult(r);
        this.flowEnded = true;
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        CtSynchronized s = synchro.clone();
        s.setBlock(this.evaluate(synchro.getBlock()));
        this.setResult(s);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        CtThrow r = throwStatement.getFactory().Core().createThrow();
        r.setThrownExpression(this.evaluate(throwStatement.getThrownExpression()));
        this.setResult(r);
        this.flowEnded = true;
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        super.visitCtCatch(catchBlock);
        this.flowEnded = false;
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        CtExpression<?> operand = this.evaluate(operator.getOperand());
        if (operand instanceof CtLiteral) {
            Serializable value;
            CtLiteral literal = (CtLiteral)operand;
            CtTypeReference promotedType = OperatorHelper.getPromotedType(operator.getKind(), literal).orElse(null);
            if (promotedType == null) {
                return;
            }
            literal = VisitorPartialEvaluator.promoteLiteral(promotedType, literal);
            Object object = literal.getValue();
            switch (operator.getKind()) {
                case NOT: {
                    value = (Boolean)object == false;
                    break;
                }
                case NEG: {
                    if (this.isFloatingType(operator.getType())) {
                        value = VisitorPartialEvaluator.convert(operator.getType(), -1.0 * ((Number)object).doubleValue());
                        break;
                    }
                    value = VisitorPartialEvaluator.convert(operator.getType(), -1L * ((Number)object).longValue());
                    break;
                }
                case POS: {
                    if (this.isFloatingType(literal.getType())) {
                        value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)object).doubleValue());
                        break;
                    }
                    value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)object).longValue());
                    break;
                }
                case COMPL: {
                    if (!this.isIntegralType(object)) {
                        return;
                    }
                    value = VisitorPartialEvaluator.convert(operator.getType(), ((Number)object).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported operator " + operator.getKind());
                }
            }
            CtLiteral<Boolean> res = operator.getFactory().createLiteral(value);
            this.setResult(res);
            return;
        }
        this.setResult(operator.clone());
    }

    private boolean isFloatingType(CtTypeReference<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals(type.getFactory().Type().doublePrimitiveType()) || type.equals(type.getFactory().Type().floatPrimitiveType()) || type.equals(type.getFactory().Type().doubleType()) || type.equals(type.getFactory().Type().floatType());
    }

    @Override
    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        this.visitVariableAccess(variableRead);
    }

    @Override
    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        this.visitVariableAccess(variableWrite);
    }

    private <T> void visitVariableAccess(CtVariableAccess<T> variableAccess) {
        CtElement v = variableAccess.getVariable().getDeclaration();
        if (v != null && v.hasModifier(ModifierKind.FINAL) && v.getDefaultExpression() != null) {
            this.setResult(this.evaluate(v.getDefaultExpression()));
        } else {
            this.setResult(variableAccess.clone());
        }
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> variableAssignment) {
        CtStatement a = variableAssignment.clone();
        a.setAssignment(this.evaluate(a.getAssignment()));
        this.setResult(a);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        CtWhile w = whileLoop.clone();
        w.setLoopingExpression(this.evaluate(whileLoop.getLoopingExpression()));
        if (whileLoop.getLoopingExpression() instanceof CtLiteral && !((Boolean)((CtLiteral)whileLoop.getLoopingExpression()).getValue()).booleanValue()) {
            this.setResult(null);
            return;
        }
        w.setBody(this.evaluate(whileLoop.getBody()));
        this.setResult(w);
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        CtExpression<Boolean> r = this.evaluate(conditional.getCondition());
        if (r instanceof CtLiteral) {
            CtLiteral l = (CtLiteral)r;
            if (((Boolean)l.getValue()).booleanValue()) {
                this.setResult(this.evaluate(conditional.getThenExpression()));
            } else {
                this.setResult(this.evaluate(conditional.getElseExpression()));
            }
        } else {
            CtConditional<T> ifRes = conditional.getFactory().Core().createConditional();
            ifRes.setCondition(r);
            ifRes.setThenExpression(this.evaluate(conditional.getThenExpression()));
            ifRes.setElseExpression(this.evaluate(conditional.getElseExpression()));
            this.setResult(ifRes);
        }
    }
}

