/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import spoon.JLSViolation;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtRecord;
import spoon.reflect.declaration.CtRecordComponent;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.DerivedProperty;
import spoon.support.UnsettableProperty;
import spoon.support.reflect.CtExtendedModifier;
import spoon.support.reflect.declaration.CtClassImpl;

public class CtRecordImpl
extends CtClassImpl<Object>
implements CtRecord {
    private static final String ABSTRACT_MODIFIER_ERROR = "Abstract modifier is not allowed on record";
    @MetamodelPropertyField(role={CtRole.RECORD_COMPONENT})
    private Set<CtRecordComponent> components = new LinkedHashSet<CtRecordComponent>();

    @Override
    @DerivedProperty
    public CtTypeReference<?> getSuperclass() {
        return this.getFactory().Type().createReference("java.lang.Record");
    }

    @Override
    @UnsettableProperty
    public <C extends CtType<Object>> C setSuperclass(CtTypeReference<?> superClass) {
        return (C)this;
    }

    @Override
    public CtRecord addRecordComponent(CtRecordComponent component) {
        if (component == null) {
            return this;
        }
        component.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onSetAdd((CtElement)this, CtRole.RECORD_COMPONENT, this.components, component);
        this.components.add(component);
        if (this.getField(component.getSimpleName()) == null) {
            this.addField(component.toField());
        }
        if (!this.hasMethodWithSameNameAndNoParameter(component)) {
            this.addMethod(component.toMethod());
        }
        return this;
    }

    @Override
    public CtRecord removeRecordComponent(CtRecordComponent component) {
        this.getFactory().getEnvironment().getModelChangeListener().onSetDelete((CtElement)this, CtRole.RECORD_COMPONENT, this.components, component);
        this.components.remove(component);
        if (this.getField(component.getSimpleName()) != null && this.getField(component.getSimpleName()).isImplicit()) {
            this.typeMembers.remove(component.toField());
        }
        if (this.getMethods().contains(component.toMethod())) {
            this.typeMembers.remove(component.toMethod());
        }
        return this;
    }

    @Override
    public Set<CtRecordComponent> getRecordComponents() {
        return Collections.unmodifiableSet(this.components);
    }

    @Override
    public void accept(CtVisitor v) {
        v.visitCtRecord(this);
    }

    @Override
    public <C extends CtType<Object>> C addTypeMemberAt(int position, CtTypeMember member) {
        String memberName = member.getSimpleName();
        if (member instanceof CtField && !member.isStatic()) {
            member.setImplicit(true);
            this.getAnnotationsWithName(memberName, ElementType.FIELD).forEach(member::addAnnotation);
        }
        if (member instanceof CtMethod && member.isImplicit()) {
            this.getAnnotationsWithName(memberName, ElementType.METHOD).forEach(member::addAnnotation);
        }
        if (member instanceof CtConstructor && member.isImplicit()) {
            for (CtParameter<?> parameter : ((CtConstructor)member).getParameters()) {
                this.getAnnotationsWithName(parameter.getSimpleName(), ElementType.PARAMETER).forEach(parameter::addAnnotation);
            }
        }
        if (member instanceof CtMethod && (member.isAbstract() || member.isNative())) {
            JLSViolation.throwIfSyntaxErrorsAreNotIgnored(this, String.format("%s method is native or abstract, both is not allowed", memberName));
        }
        if (member instanceof CtAnonymousExecutable && !member.isStatic()) {
            JLSViolation.throwIfSyntaxErrorsAreNotIgnored(this, "Instance initializer is not allowed in a record (JLS 17 $8.10.2)");
        }
        return super.addTypeMemberAt(position, member);
    }

    private List<CtAnnotation<?>> getAnnotationsWithName(String name, ElementType elementType) {
        ArrayList result = new ArrayList();
        for (CtRecordComponent component : this.components) {
            if (!component.getSimpleName().equals(name)) continue;
            for (CtAnnotation<? extends Annotation> annotation : component.getAnnotations()) {
                Target target;
                CtType<? extends Annotation> annotationType = annotation.getAnnotationType().getTypeDeclaration();
                if (annotationType == null || (target = annotationType.getAnnotation(Target.class)) == null && elementType == ElementType.TYPE_USE || target != null && !Arrays.stream(target.value()).anyMatch(e -> e == elementType)) continue;
                result.add((CtAnnotation<?>)annotation.clone());
            }
        }
        return result;
    }

    @Override
    public <C extends CtType<Object>> C setFields(List<CtField<?>> fields) {
        super.setFields(fields);
        for (CtRecordComponent component : this.components) {
            if (this.getField(component.getSimpleName()) != null) continue;
            this.addField(component.toField());
        }
        return (C)this;
    }

    @Override
    public <C extends CtType<Object>> C setMethods(Set<CtMethod<?>> methods) {
        super.setMethods(methods);
        for (CtRecordComponent component : this.components) {
            if (this.hasMethodWithSameNameAndNoParameter(component)) continue;
            this.addMethod(component.toMethod());
        }
        return (C)this;
    }

    private boolean hasMethodWithSameNameAndNoParameter(CtRecordComponent component) {
        for (CtMethod<?> method : this.getMethodsByName(component.getSimpleName())) {
            if (!method.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <C extends CtType<Object>> C setTypeMembers(List<CtTypeMember> members) {
        super.setTypeMembers(members);
        for (CtRecordComponent component : this.components) {
            if (this.hasMethodWithSameNameAndNoParameter(component)) {
                this.addMethod(component.toMethod());
            }
            if (this.getField(component.getSimpleName()) != null) continue;
            this.addField(component.toField());
        }
        return (C)this;
    }

    @Override
    public <C extends CtModifiable> C addModifier(ModifierKind modifier) {
        if (modifier.equals((Object)ModifierKind.ABSTRACT)) {
            JLSViolation.throwIfSyntaxErrorsAreNotIgnored(this, ABSTRACT_MODIFIER_ERROR);
        }
        return super.addModifier(modifier);
    }

    @Override
    public <C extends CtModifiable> C setModifiers(Set<ModifierKind> modifiers) {
        if (modifiers.contains((Object)ModifierKind.ABSTRACT)) {
            JLSViolation.throwIfSyntaxErrorsAreNotIgnored(this, ABSTRACT_MODIFIER_ERROR);
        }
        return super.setModifiers(modifiers);
    }

    @Override
    public <C extends CtModifiable> C setExtendedModifiers(Set<CtExtendedModifier> extendedModifiers) {
        this.checkIfAbstractModifier(extendedModifiers);
        return (C)super.setExtendedModifiers(extendedModifiers);
    }

    private boolean isAbstract(CtExtendedModifier v) {
        return v.getKind().equals((Object)ModifierKind.ABSTRACT);
    }

    private void checkIfAbstractModifier(Set<CtExtendedModifier> extendedModifiers) {
        for (CtExtendedModifier extendedModifier : extendedModifiers) {
            if (!this.isAbstract(extendedModifier)) continue;
            JLSViolation.throwIfSyntaxErrorsAreNotIgnored(this, ABSTRACT_MODIFIER_ERROR);
        }
    }

    @Override
    public CtRecord setRecordComponents(Set<CtRecordComponent> components) {
        this.getRecordComponents().forEach(this::removeRecordComponent);
        components.forEach(this::addRecordComponent);
        return this;
    }

    @Override
    public <E extends CtElement> E setParent(CtElement parent) {
        HashSet<CtExtendedModifier> extendedModifiers = new HashSet<CtExtendedModifier>(this.getExtendedModifiers());
        if (parent instanceof CtType) {
            extendedModifiers.add(CtExtendedModifier.implicit(ModifierKind.STATIC));
        } else {
            extendedModifiers.remove(CtExtendedModifier.implicit(ModifierKind.STATIC));
        }
        this.setExtendedModifiers(extendedModifiers);
        return super.setParent(parent);
    }

    @Override
    public Set<CtTypeReference<?>> getPermittedTypes() {
        return Set.of();
    }

    @Override
    @UnsettableProperty
    public CtRecord setPermittedTypes(Collection<CtTypeReference<?>> permittedTypes) {
        return this;
    }

    @Override
    @UnsettableProperty
    public CtRecord addPermittedType(CtTypeReference<?> type) {
        return this;
    }

    @Override
    @UnsettableProperty
    public CtRecord removePermittedType(CtTypeReference<?> type) {
        return this;
    }

    @Override
    public CtRecord clone() {
        return (CtRecord)super.clone();
    }
}

