/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import spoon.JLSViolation;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtRecord;
import spoon.reflect.declaration.CtRecordComponent;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.CtExtendedModifier;
import spoon.support.reflect.declaration.CtNamedElementImpl;

public class CtRecordComponentImpl
extends CtNamedElementImpl
implements CtRecordComponent {
    private static final Set<String> forbiddenNames = CtRecordComponentImpl.createForbiddenNames();
    @MetamodelPropertyField(role={CtRole.TYPE})
    private CtTypeReference<Object> type;
    @MetamodelPropertyField(role={CtRole.IS_SHADOW})
    boolean isShadow;

    @Override
    public CtMethod<?> toMethod() {
        CtMethod method = this.getFactory().createMethod();
        method.setSimpleName(this.getSimpleName());
        method.setType(this.getClonedType());
        method.setExtendedModifiers(Collections.singleton(new CtExtendedModifier(ModifierKind.PUBLIC, true)));
        CtFieldAccess ctVariableAccess = (CtFieldAccess)this.getFactory().Code().createVariableRead(this.getRecordFieldReference(), false);
        method.setBody(this.getFactory().Code().createCtReturn(ctVariableAccess));
        return CtRecordComponentImpl.makeTreeImplicit(method);
    }

    private CtFieldReference<?> getRecordFieldReference() {
        CtRecord parent = this.isParentInitialized() ? (CtRecord)this.getParent() : null;
        CtFieldReference reference = (CtFieldReference)this.getFactory().createFieldReference().setFinal(true).setStatic(false).setType(this.getClonedType()).setSimpleName(this.getSimpleName());
        if (parent != null) {
            reference.setDeclaringType((CtTypeReference<?>)parent.getReference());
        }
        return reference;
    }

    @Override
    public CtField<?> toField() {
        CtField field = this.getFactory().createField();
        field.setSimpleName(this.getSimpleName());
        field.setType(this.getClonedType());
        HashSet<CtExtendedModifier> modifiers = new HashSet<CtExtendedModifier>();
        modifiers.add(new CtExtendedModifier(ModifierKind.PRIVATE, true));
        modifiers.add(new CtExtendedModifier(ModifierKind.FINAL, true));
        field.setExtendedModifiers(modifiers);
        return CtRecordComponentImpl.makeTreeImplicit(field);
    }

    @Override
    public boolean isImplicit() {
        return true;
    }

    private @Nullable CtTypeReference<?> getClonedType() {
        return this.getType() != null ? this.getType().clone() : null;
    }

    @Override
    public CtTypeReference<Object> getType() {
        return this.type;
    }

    @Override
    public <C extends CtTypedElement> C setType(CtTypeReference type) {
        if (type != null) {
            type.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.TYPE, type, this.type);
        this.type = type;
        return (C)this;
    }

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtRecordComponent(this);
    }

    @Override
    public <T extends CtNamedElement> T setSimpleName(String simpleName) {
        this.checkName(simpleName);
        return super.setSimpleName(simpleName);
    }

    private void checkName(String simpleName) {
        if (forbiddenNames.contains(simpleName)) {
            JLSViolation.throwIfSyntaxErrorsAreNotIgnored(this, "The name '" + simpleName + "' is not allowed as record component name.");
        }
    }

    private static Set<String> createForbiddenNames() {
        return Set.of("clone", "finalize", "getClass", "notify", "notifyAll", "equals", "hashCode", "toString", "wait");
    }

    @Override
    public CtRecordComponent clone() {
        return (CtRecordComponent)super.clone();
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_SHADOW, isShadow, this.isShadow);
        this.isShadow = isShadow;
        return (E)this;
    }

    private static <T extends CtElement> T makeTreeImplicit(T element) {
        element.accept(new CtScanner(){

            @Override
            protected void enter(CtElement e) {
                e.setImplicit(true);
            }
        });
        return element;
    }
}

