/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.LinkedHashSet;
import java.util.Set;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtNamedElementImpl;
import spoon.support.util.internal.ElementNameMap;

public class CtPackageImpl
extends CtNamedElementImpl
implements CtPackage {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.SUB_PACKAGE})
    protected ElementNameMap<CtPackage> packs = new ElementNameMap<CtPackage>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected CtElement getOwner() {
            return CtPackageImpl.this;
        }

        @Override
        protected CtRole getRole() {
            return CtRole.SUB_PACKAGE;
        }

        @Override
        public CtPackage put(String simpleName, CtPackage pack) {
            if (pack == null || pack == CtPackageImpl.this) {
                return null;
            }
            CtPackage ctPackage = (CtPackage)this.get(simpleName);
            if (ctPackage != null) {
                CtPackageImpl.this.addAllTypes(pack, ctPackage);
                CtPackageImpl.this.addAllPackages(pack, ctPackage);
                return null;
            }
            return super.put(simpleName, pack);
        }
    };
    @MetamodelPropertyField(role={CtRole.CONTAINED_TYPE})
    private final ElementNameMap<CtType<?>> types = new ElementNameMap<CtType<?>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected CtElement getOwner() {
            return CtPackageImpl.this;
        }

        @Override
        protected CtRole getRole() {
            return CtRole.CONTAINED_TYPE;
        }
    };
    @MetamodelPropertyField(role={CtRole.IS_SHADOW})
    boolean isShadow;

    @Override
    public void accept(CtVisitor v) {
        v.visitCtPackage(this);
    }

    @Override
    public <T extends CtPackage> T addPackage(CtPackage pack) {
        if (pack == null) {
            return (T)this;
        }
        this.packs.put(pack.getSimpleName(), pack);
        return (T)this;
    }

    private void addAllTypes(CtPackage from, CtPackage to) {
        for (CtType<?> t : from.getTypes()) {
            for (CtType<?> t2 : to.getTypes()) {
                if (!t2.getQualifiedName().equals(t.getQualifiedName()) || t2.equals(t)) continue;
                throw new IllegalStateException("types with same qualified names and different code cannot be merged");
            }
            to.addType(t);
        }
    }

    private void addAllPackages(CtPackage from, CtPackage to) {
        for (CtPackage p : from.getPackages()) {
            to.addPackage(p);
        }
    }

    @Override
    public boolean removePackage(CtPackage pack) {
        return this.packs.remove(pack.getSimpleName()) != null;
    }

    @Override
    public CtModule getDeclaringModule() {
        return this.getParent(CtModule.class);
    }

    @Override
    public CtPackage getDeclaringPackage() {
        return this.getParent(CtPackage.class);
    }

    @Override
    public CtPackage getPackage(String simpleName) {
        return (CtPackage)this.packs.get(simpleName);
    }

    @Override
    public Set<CtPackage> getPackages() {
        return new LinkedHashSet<CtPackage>(this.packs.values());
    }

    @Override
    public <T extends CtNamedElement> T setSimpleName(String simpleName) {
        String oldName = this.getSimpleName();
        super.setSimpleName(simpleName);
        if (this.parent instanceof CtPackageImpl) {
            ((CtPackageImpl)this.parent).updatePackageName(this, oldName);
        }
        return (T)this;
    }

    @Override
    public String getQualifiedName() {
        if (this.getDeclaringPackage() == null || this.getDeclaringPackage().isUnnamedPackage()) {
            return this.getSimpleName();
        }
        return this.getDeclaringPackage().getQualifiedName() + "." + this.getSimpleName();
    }

    @Override
    public <T extends CtType<?>> T getType(String simpleName) {
        return (T)((CtType)this.types.get(simpleName));
    }

    @Override
    public Set<CtType<?>> getTypes() {
        return new LinkedHashSet(this.types.values());
    }

    @Override
    public <T extends CtPackage> T setPackages(Set<CtPackage> packs) {
        this.packs.clear();
        for (CtPackage pack : packs) {
            this.packs.put(pack.getSimpleName(), pack);
        }
        return (T)this;
    }

    @Override
    public <T extends CtPackage> T setTypes(Set<CtType<?>> types) {
        this.types.clear();
        for (CtType<?> type : types) {
            this.types.put(type.getSimpleName(), type);
        }
        return (T)this;
    }

    @Override
    public CtPackageReference getReference() {
        return this.getFactory().Package().createReference(this);
    }

    @Override
    public <T extends CtPackage> T addType(CtType<?> type) {
        if (type == null) {
            return (T)this;
        }
        this.types.put(type.getSimpleName(), type);
        return (T)this;
    }

    @Override
    public void removeType(CtType<?> type) {
        this.types.remove(type.getSimpleName());
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_SHADOW, isShadow, this.isShadow);
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtPackage clone() {
        return (CtPackage)super.clone();
    }

    @Override
    public boolean isUnnamedPackage() {
        return "unnamed package".equals(this.getSimpleName());
    }

    @Override
    public boolean hasPackageInfo() {
        return !(this.getPosition() instanceof NoSourcePosition);
    }

    @Override
    public boolean isEmpty() {
        return !this.hasPackages() && !this.hasTypes();
    }

    @Override
    public boolean hasTypes() {
        return !this.types.isEmpty();
    }

    @Override
    public boolean hasPackages() {
        return !this.packs.isEmpty();
    }

    void updateTypeName(CtType<?> newType, String oldName) {
        this.types.updateKey(oldName, newType.getSimpleName());
    }

    void updatePackageName(CtPackage newPackage, String oldName) {
        this.packs.updateKey(oldName, newPackage.getSimpleName());
    }
}

