/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackageExport;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtElementImpl;

public class CtPackageExportImpl
extends CtElementImpl
implements CtPackageExport {
    @MetamodelPropertyField(role={CtRole.PACKAGE_REF})
    private CtPackageReference packageReference;
    @MetamodelPropertyField(role={CtRole.MODULE_REF})
    private List<CtModuleReference> targets = CtElementImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.OPENED_PACKAGE})
    private boolean isOpen;

    @Override
    public <T extends CtPackageExport> T setOpenedPackage(boolean openedPackage) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.OPENED_PACKAGE, openedPackage, this.isOpen);
        this.isOpen = openedPackage;
        return (T)this;
    }

    @Override
    public boolean isOpenedPackage() {
        return this.isOpen;
    }

    @Override
    public CtPackageReference getPackageReference() {
        return this.packageReference;
    }

    @Override
    public <T extends CtPackageExport> T setPackageReference(CtPackageReference packageReference) {
        if (packageReference != null) {
            packageReference.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.PACKAGE_REF, packageReference, this.packageReference);
        this.packageReference = packageReference;
        return (T)this;
    }

    @Override
    public List<CtModuleReference> getTargetExport() {
        return Collections.unmodifiableList(this.targets);
    }

    @Override
    public <T extends CtPackageExport> T setTargetExport(List<CtModuleReference> targetExports) {
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.MODULE_REF, this.targets, new ArrayList<CtModuleReference>(this.targets));
        if (targetExports == null || targetExports.isEmpty()) {
            this.targets = CtElementImpl.emptyList();
            return (T)this;
        }
        if (this.targets == CtElementImpl.emptyList()) {
            this.targets = new ArrayList<CtModuleReference>();
        }
        this.targets.clear();
        for (CtModuleReference targetExport : targetExports) {
            this.addTargetExport(targetExport);
        }
        return (T)this;
    }

    @Override
    public <T extends CtPackageExport> T addTargetExport(CtModuleReference targetExport) {
        if (targetExport == null) {
            return (T)this;
        }
        if (this.targets == CtElementImpl.emptyList()) {
            this.targets = new ArrayList<CtModuleReference>();
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.MODULE_REF, this.targets, targetExport);
        targetExport.setParent(this);
        this.targets.add(targetExport);
        return (T)this;
    }

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtPackageExport(this);
    }

    @Override
    public CtPackageExport clone() {
        return (CtPackageExport)super.clone();
    }
}

