/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtModuleDirective;
import spoon.reflect.declaration.CtModuleRequirement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtPackageExport;
import spoon.reflect.declaration.CtProvidedService;
import spoon.reflect.declaration.CtUsedService;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.DerivedProperty;
import spoon.support.comparator.CtLineElementComparator;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtNamedElementImpl;
import spoon.support.util.SortedList;

public class CtModuleImpl
extends CtNamedElementImpl
implements CtModule {
    @MetamodelPropertyField(role={CtRole.MODIFIER})
    private boolean openModule;
    @MetamodelPropertyField(role={CtRole.MODULE_DIRECTIVE})
    private List<CtModuleDirective> moduleDirectives = CtElementImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.SUB_PACKAGE})
    private CtPackage rootPackage;

    @Override
    public boolean isUnnamedModule() {
        return "unnamed module".equals(this.getSimpleName());
    }

    @Override
    public boolean isOpenModule() {
        return this.openModule;
    }

    @Override
    public <T extends CtModule> T setModuleDirectives(List<CtModuleDirective> moduleDirectives) {
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.MODULE_DIRECTIVE, this.moduleDirectives, new ArrayList<CtModuleDirective>(this.moduleDirectives));
        if (moduleDirectives == null || moduleDirectives.isEmpty()) {
            this.moduleDirectives = CtElementImpl.emptyList();
            return (T)this;
        }
        if (this.moduleDirectives == CtElementImpl.emptyList()) {
            this.moduleDirectives = new SortedList<CtElement>(new CtLineElementComparator());
        }
        this.moduleDirectives.clear();
        for (CtModuleDirective moduleDirective : moduleDirectives) {
            this.addModuleDirective(moduleDirective);
        }
        return (T)this;
    }

    @Override
    public <T extends CtModule> T addModuleDirective(CtModuleDirective moduleDirective) {
        if (moduleDirective == null) {
            return (T)this;
        }
        if (this.moduleDirectives == CtElementImpl.emptyList()) {
            this.moduleDirectives = new SortedList<CtElement>(new CtLineElementComparator());
        }
        if (!this.moduleDirectives.contains(moduleDirective)) {
            moduleDirective.setParent(this);
            CtRole role = CtRole.MODULE_DIRECTIVE.getMatchingSubRoleFor(moduleDirective);
            this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, role, this.moduleDirectives, moduleDirective);
            this.moduleDirectives.add(moduleDirective);
        }
        return (T)this;
    }

    @Override
    public <T extends CtModule> T addModuleDirectiveAt(int position, CtModuleDirective moduleDirective) {
        if (moduleDirective == null) {
            return (T)this;
        }
        if (this.moduleDirectives == CtElementImpl.emptyList()) {
            this.moduleDirectives = new SortedList<CtElement>(new CtLineElementComparator());
        }
        if (!this.moduleDirectives.contains(moduleDirective)) {
            moduleDirective.setParent(this);
            CtRole role = CtRole.MODULE_DIRECTIVE.getMatchingSubRoleFor(moduleDirective);
            this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, role, this.moduleDirectives, position, moduleDirective);
            this.moduleDirectives.add(position, moduleDirective);
        }
        return (T)this;
    }

    @Override
    public List<CtModuleDirective> getModuleDirectives() {
        return Collections.unmodifiableList(this.moduleDirectives);
    }

    @Override
    public <T extends CtModule> T removeModuleDirective(CtModuleDirective moduleDirective) {
        if (moduleDirective == null || this.moduleDirectives.isEmpty()) {
            return (T)this;
        }
        if (this.moduleDirectives.contains(moduleDirective)) {
            this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.MODULE_DIRECTIVE.getMatchingSubRoleFor(moduleDirective), this.moduleDirectives, this.moduleDirectives.indexOf(moduleDirective), moduleDirective);
            if (this.moduleDirectives.size() == 1) {
                this.moduleDirectives = CtElementImpl.emptyList();
            } else {
                this.moduleDirectives.remove(moduleDirective);
            }
        }
        return (T)this;
    }

    @Override
    public <T extends CtModule> T setIsOpenModule(boolean openModule) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.MODIFIER, openModule, this.openModule);
        this.openModule = openModule;
        return (T)this;
    }

    @Override
    public List<CtUsedService> getUsedServices() {
        if (this.moduleDirectives.isEmpty()) {
            return CtElementImpl.emptyList();
        }
        ArrayList<CtUsedService> usedServices = new ArrayList<CtUsedService>();
        for (CtModuleDirective moduleDirective : this.moduleDirectives) {
            if (!(moduleDirective instanceof CtUsedService)) continue;
            usedServices.add((CtUsedService)moduleDirective);
        }
        return Collections.unmodifiableList(usedServices);
    }

    @Override
    public <T extends CtModule> T setUsedServices(List<CtUsedService> consumedServices) {
        if (consumedServices == null || consumedServices.isEmpty()) {
            return (T)this;
        }
        List<CtUsedService> usedServices = this.getUsedServices();
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.SERVICE_TYPE, this.moduleDirectives, new ArrayList<CtUsedService>(usedServices));
        this.moduleDirectives.removeAll(usedServices);
        for (CtUsedService consumedService : consumedServices) {
            this.addModuleDirective(consumedService);
        }
        return (T)this;
    }

    @Override
    public <T extends CtModule> T addUsedService(CtUsedService consumedService) {
        if (consumedService == null) {
            return (T)this;
        }
        this.addModuleDirective(consumedService);
        return (T)this;
    }

    @Override
    public <T extends CtModule> T removeUsedService(CtUsedService usedService) {
        if (usedService == null) {
            return (T)this;
        }
        return this.removeModuleDirective(usedService);
    }

    @Override
    public List<CtPackageExport> getExportedPackages() {
        if (this.moduleDirectives.isEmpty()) {
            return CtElementImpl.emptyList();
        }
        ArrayList<CtPackageExport> exportedPackages = new ArrayList<CtPackageExport>();
        for (CtModuleDirective moduleDirective : this.moduleDirectives) {
            CtPackageExport exportedPackage;
            if (!(moduleDirective instanceof CtPackageExport) || (exportedPackage = (CtPackageExport)moduleDirective).isOpenedPackage()) continue;
            exportedPackages.add(exportedPackage);
        }
        return Collections.unmodifiableList(exportedPackages);
    }

    @Override
    public <T extends CtModule> T setExportedPackages(List<CtPackageExport> exportedPackages) {
        if (exportedPackages == null || exportedPackages.isEmpty()) {
            return (T)this;
        }
        List<CtPackageExport> oldExportedPackages = this.getExportedPackages();
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.EXPORTED_PACKAGE, this.moduleDirectives, new ArrayList<CtPackageExport>(oldExportedPackages));
        this.moduleDirectives.removeAll(oldExportedPackages);
        for (CtPackageExport exportedPackage : exportedPackages) {
            exportedPackage.setOpenedPackage(false);
            this.addModuleDirective(exportedPackage);
        }
        return (T)this;
    }

    @Override
    public <T extends CtModule> T addExportedPackage(CtPackageExport exportedPackage) {
        if (exportedPackage == null) {
            return (T)this;
        }
        exportedPackage.setOpenedPackage(false);
        this.addModuleDirective(exportedPackage);
        return (T)this;
    }

    @Override
    public <T extends CtModule> T removeExportedPackage(CtPackageExport exportedPackage) {
        if (exportedPackage == null) {
            return (T)this;
        }
        return this.removeModuleDirective(exportedPackage);
    }

    @Override
    public List<CtPackageExport> getOpenedPackages() {
        if (this.moduleDirectives.isEmpty()) {
            return CtElementImpl.emptyList();
        }
        ArrayList<CtPackageExport> openedPackages = new ArrayList<CtPackageExport>();
        for (CtModuleDirective moduleDirective : this.moduleDirectives) {
            CtPackageExport exportedPackage;
            if (!(moduleDirective instanceof CtPackageExport) || !(exportedPackage = (CtPackageExport)moduleDirective).isOpenedPackage()) continue;
            openedPackages.add(exportedPackage);
        }
        return Collections.unmodifiableList(openedPackages);
    }

    @Override
    public <T extends CtModule> T setOpenedPackages(List<CtPackageExport> openedPackages) {
        if (openedPackages == null || openedPackages.isEmpty()) {
            return (T)this;
        }
        List<CtPackageExport> oldOpenedPackages = this.getOpenedPackages();
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.OPENED_PACKAGE, this.moduleDirectives, new ArrayList<CtPackageExport>(oldOpenedPackages));
        this.moduleDirectives.removeAll(oldOpenedPackages);
        for (CtPackageExport exportedPackage : openedPackages) {
            exportedPackage.setOpenedPackage(true);
            this.addModuleDirective(exportedPackage);
        }
        return (T)this;
    }

    @Override
    public <T extends CtModule> T addOpenedPackage(CtPackageExport openedPackage) {
        if (openedPackage == null) {
            return (T)this;
        }
        openedPackage.setOpenedPackage(true);
        this.addModuleDirective(openedPackage);
        return (T)this;
    }

    @Override
    public <T extends CtModule> T removeOpenedPackage(CtPackageExport openedPackage) {
        if (openedPackage == null) {
            return (T)this;
        }
        return this.removeModuleDirective(openedPackage);
    }

    @Override
    public List<CtModuleRequirement> getRequiredModules() {
        if (this.moduleDirectives.isEmpty()) {
            return CtElementImpl.emptyList();
        }
        ArrayList<CtModuleRequirement> moduleRequirements = new ArrayList<CtModuleRequirement>();
        for (CtModuleDirective moduleDirective : this.moduleDirectives) {
            if (!(moduleDirective instanceof CtModuleRequirement)) continue;
            moduleRequirements.add((CtModuleRequirement)moduleDirective);
        }
        return Collections.unmodifiableList(moduleRequirements);
    }

    @Override
    public <T extends CtModule> T setRequiredModules(List<CtModuleRequirement> requiredModules) {
        if (requiredModules == null || requiredModules.isEmpty()) {
            return (T)this;
        }
        List<CtModuleRequirement> oldRequiredModules = this.getRequiredModules();
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.REQUIRED_MODULE, this.moduleDirectives, new ArrayList<CtModuleRequirement>(oldRequiredModules));
        this.moduleDirectives.removeAll(oldRequiredModules);
        for (CtModuleRequirement moduleRequirement : requiredModules) {
            this.addModuleDirective(moduleRequirement);
        }
        return (T)this;
    }

    @Override
    public <T extends CtModule> T addRequiredModule(CtModuleRequirement requiredModule) {
        if (requiredModule == null) {
            return (T)this;
        }
        this.addModuleDirective(requiredModule);
        return (T)this;
    }

    @Override
    public <T extends CtModule> T removeRequiredModule(CtModuleRequirement requiredModule) {
        if (requiredModule == null) {
            return (T)this;
        }
        return this.removeModuleDirective(requiredModule);
    }

    @Override
    public List<CtProvidedService> getProvidedServices() {
        if (this.moduleDirectives.isEmpty()) {
            return CtElementImpl.emptyList();
        }
        ArrayList<CtProvidedService> providedServices = new ArrayList<CtProvidedService>();
        for (CtModuleDirective moduleDirective : this.moduleDirectives) {
            if (!(moduleDirective instanceof CtProvidedService)) continue;
            providedServices.add((CtProvidedService)moduleDirective);
        }
        return Collections.unmodifiableList(providedServices);
    }

    @Override
    public <T extends CtModule> T setProvidedServices(List<CtProvidedService> providedServices) {
        if (providedServices == null || providedServices.isEmpty()) {
            return (T)this;
        }
        List<CtProvidedService> oldProvidedServices = this.getProvidedServices();
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.PROVIDED_SERVICE, this.moduleDirectives, new ArrayList<CtProvidedService>(oldProvidedServices));
        this.moduleDirectives.removeAll(oldProvidedServices);
        for (CtProvidedService providedService : providedServices) {
            this.addModuleDirective(providedService);
        }
        return (T)this;
    }

    @Override
    public <T extends CtModule> T addProvidedService(CtProvidedService providedService) {
        if (providedService == null) {
            return (T)this;
        }
        this.addModuleDirective(providedService);
        return (T)this;
    }

    @Override
    public <T extends CtModule> T removeProvidedService(CtProvidedService providedService) {
        if (providedService == null) {
            return (T)this;
        }
        return this.removeModuleDirective(providedService);
    }

    @Override
    public CtPackage getRootPackage() {
        return this.rootPackage;
    }

    @Override
    public <T extends CtModule> T setRootPackage(CtPackage rootPackage) {
        if (rootPackage != null) {
            rootPackage.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.SUB_PACKAGE, rootPackage, this.rootPackage);
        this.rootPackage = rootPackage;
        return (T)this;
    }

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtModule(this);
    }

    @Override
    public CtModuleReference getReference() {
        return this.getFactory().Module().createReference(this);
    }

    @Override
    public CtModule clone() {
        return (CtModule)super.clone();
    }

    @DerivedProperty
    public <T extends CtElement> T setParent(CtElement parent) {
        return (T)this;
    }

    @Override
    @DerivedProperty
    public CtElement getParent() {
        return this.getFactory().getModel().getUnnamedModule();
    }
}

