/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.UnsettableProperty;
import spoon.support.reflect.CtExtendedModifier;
import spoon.support.reflect.code.CtStatementImpl;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtTypeImpl;
import spoon.support.reflect.eval.VisitorPartialEvaluator;

public class CtInterfaceImpl<T>
extends CtTypeImpl<T>
implements CtInterface<T> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.PERMITTED_TYPE})
    Set<CtTypeReference<?>> permittedTypes = CtInterfaceImpl.emptySet();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtInterface(this);
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        return this.getReference().isSubtypeOf(type);
    }

    @Override
    public boolean isInterface() {
        return true;
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        Set<CtTypeReference<?>> superInterfaces = this.getSuperInterfaces();
        if (superInterfaces.isEmpty()) {
            return super.getDeclaredExecutables();
        }
        ArrayList l = new ArrayList(super.getDeclaredExecutables());
        for (CtTypeReference<?> sup : superInterfaces) {
            l.addAll(sup.getAllExecutables());
        }
        return Collections.unmodifiableList(l);
    }

    @Override
    public <R extends CtCodeElement> R partiallyEvaluate() {
        VisitorPartialEvaluator eval = new VisitorPartialEvaluator();
        return (R)eval.evaluate(this);
    }

    public <C extends CtStatement> C insertAfter(CtStatement statement) throws ParentNotInitializedException {
        CtStatementImpl.insertAfter((CtStatement)this, statement);
        return (C)this;
    }

    public <C extends CtStatement> C insertAfter(CtStatementList statements) throws ParentNotInitializedException {
        CtStatementImpl.insertAfter((CtStatement)this, statements);
        return (C)this;
    }

    public <C extends CtStatement> C insertBefore(CtStatement statement) throws ParentNotInitializedException {
        CtStatementImpl.insertBefore((CtStatement)this, statement);
        return (C)this;
    }

    public <C extends CtStatement> C insertBefore(CtStatementList statements) throws ParentNotInitializedException {
        CtStatementImpl.insertBefore((CtStatement)this, statements);
        return (C)this;
    }

    @UnsettableProperty
    public <C extends CtStatement> C setLabel(String label) {
        return (C)this;
    }

    @Override
    public CtInterface<T> clone() {
        return (CtInterface)super.clone();
    }

    @Override
    @UnsettableProperty
    public <C extends CtType<T>> C setSuperclass(CtTypeReference<?> superClass) {
        return (C)this;
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public Set<CtTypeReference<?>> getPermittedTypes() {
        return Collections.unmodifiableSet(this.permittedTypes);
    }

    @Override
    public CtInterface<T> setPermittedTypes(Collection<CtTypeReference<?>> permittedTypes) {
        Collection<CtTypeReference<?>> types = permittedTypes != null ? permittedTypes : CtElementImpl.emptySet();
        this.getFactory().getEnvironment().getModelChangeListener().onSetDeleteAll(this, CtRole.PERMITTED_TYPE, this.permittedTypes, new LinkedHashSet(this.permittedTypes));
        this.permittedTypes.clear();
        for (CtTypeReference<?> type : types) {
            this.addPermittedType((CtTypeReference)type);
        }
        return this;
    }

    @Override
    public CtInterface<T> addPermittedType(CtTypeReference<?> type) {
        if (type == null) {
            return this;
        }
        if (this.permittedTypes == CtElementImpl.emptySet()) {
            this.permittedTypes = new LinkedHashSet();
        }
        type.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onSetAdd((CtElement)this, CtRole.PERMITTED_TYPE, this.permittedTypes, type);
        this.permittedTypes.add(type);
        return this;
    }

    @Override
    public CtInterface<T> removePermittedType(CtTypeReference<?> type) {
        if (this.permittedTypes == CtElementImpl.emptySet()) {
            return this;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onSetDelete((CtElement)this, CtRole.PERMITTED_TYPE, this.permittedTypes, type);
        this.permittedTypes.remove(type);
        return this;
    }

    @Override
    public <N, C extends CtType<T>> C addNestedType(CtType<N> nestedType) {
        super.addNestedType(nestedType);
        if (nestedType == null) {
            return (C)this;
        }
        HashSet<CtExtendedModifier> modifiers = new HashSet<CtExtendedModifier>(nestedType.getExtendedModifiers());
        if (!nestedType.isPublic()) {
            modifiers.add(CtExtendedModifier.implicit(ModifierKind.PUBLIC));
        }
        if (!nestedType.isStatic()) {
            modifiers.add(CtExtendedModifier.implicit(ModifierKind.STATIC));
        }
        nestedType.setExtendedModifiers(modifiers);
        return (C)this;
    }

    @Override
    public <N> boolean removeNestedType(CtType<N> nestedType) {
        if (!super.removeNestedType(nestedType)) {
            return false;
        }
        EnumSet<ModifierKind> addedKinds = EnumSet.of(ModifierKind.STATIC, ModifierKind.PUBLIC);
        HashSet<CtExtendedModifier> newModifiers = new HashSet<CtExtendedModifier>(nestedType.getExtendedModifiers());
        newModifiers.removeIf(modifier -> modifier.isImplicit() && addedKinds.contains((Object)modifier.getKind()));
        nestedType.setExtendedModifiers(newModifiers);
        return true;
    }
}

